/*
 * Decompiled with CFR 0.152.
 */
package jsky.plot;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import jsky.coords.SiteDesc;
import jsky.plot.ElevationPlotUtil;
import jsky.util.CalendarUtil;

public class SunRiseSet {
    private Date _date;
    private Date _sunset;
    private Date _sunrise;
    private Date _civilTwilightStart;
    private Date _civilTwilightEnd;
    private Date _nauticalTwilightStart;
    private Date _nauticalTwilightEnd;
    private Date _astronomicalTwilightStart;
    private Date _astronomicalTwilightEnd;

    public SunRiseSet(Date date, SiteDesc site) {
        this._date = date;
        double longitude = site.getLongitude();
        double latitude = site.getLatitude();
        Calendar cal = Calendar.getInstance(site.getTimeZone());
        cal.setTime(date);
        int dayOfYear = cal.get(6);
        double lngHour = longitude / 15.0;
        this._sunset = this._calcTime(false, 90.83333333333333, dayOfYear, lngHour, latitude);
        this._sunrise = this._calcTime(true, 90.83333333333333, dayOfYear, lngHour, latitude);
        this._civilTwilightStart = this._calcTime(false, 96.0, dayOfYear, lngHour, latitude);
        this._civilTwilightEnd = this._calcTime(true, 96.0, dayOfYear, lngHour, latitude);
        this._nauticalTwilightStart = this._calcTime(false, 102.0, dayOfYear, lngHour, latitude);
        this._nauticalTwilightEnd = this._calcTime(true, 102.0, dayOfYear, lngHour, latitude);
        this._astronomicalTwilightStart = this._calcTime(false, 108.0, dayOfYear, lngHour, latitude);
        this._astronomicalTwilightEnd = this._calcTime(true, 108.0, dayOfYear, lngHour, latitude);
    }

    public Date getSunset() {
        return this._sunset;
    }

    public Date getSunrise() {
        return this._sunrise;
    }

    public Date getCivilTwilightStart() {
        return this._civilTwilightStart;
    }

    public Date getCivilTwilightEnd() {
        return this._civilTwilightEnd;
    }

    public Date getNauticalTwilightStart() {
        return this._nauticalTwilightStart;
    }

    public Date getNauticalTwilightEnd() {
        return this._nauticalTwilightEnd;
    }

    public Date getAstronomicalTwilightStart() {
        return this._astronomicalTwilightStart;
    }

    public Date getAstronomicalTwilightEnd() {
        return this._astronomicalTwilightEnd;
    }

    private static double _sin(double d) {
        return Math.sin(Math.toRadians(d));
    }

    private static double _cos(double d) {
        return Math.cos(Math.toRadians(d));
    }

    private static double _tan(double d) {
        return Math.tan(Math.toRadians(d));
    }

    private static double _asin(double d) {
        return Math.toDegrees(Math.asin(d));
    }

    private static double _acos(double d) {
        return Math.toDegrees(Math.acos(d));
    }

    private static double _atan(double d) {
        return Math.toDegrees(Math.atan(d));
    }

    private Date _calcTime(boolean rise, double zenith, int dayOfYear, double lngHour, double latitude) {
        if (rise) {
            ++dayOfYear;
        }
        double t = rise ? (double)dayOfYear + (6.0 - lngHour) / 24.0 : (double)dayOfYear + (18.0 - lngHour) / 24.0;
        double m = 0.9856 * t - 3.289;
        double l = m + 1.916 * SunRiseSet._sin(m) + 0.02 * SunRiseSet._sin(2.0 * m) + 282.634;
        l = SunRiseSet._normalize(l, 360.0);
        double ra = SunRiseSet._atan(0.91764 * SunRiseSet._tan(l));
        ra = SunRiseSet._normalize(ra, 360.0);
        double lQuadrant = Math.floor(l / 90.0) * 90.0;
        double raQuadrant = Math.floor(ra / 90.0) * 90.0;
        ra += lQuadrant - raQuadrant;
        ra /= 15.0;
        double sinDec = 0.39782 * SunRiseSet._sin(l);
        double cosDec = SunRiseSet._cos(SunRiseSet._asin(sinDec));
        double cosH = (SunRiseSet._cos(zenith) - sinDec * SunRiseSet._sin(latitude)) / (cosDec * SunRiseSet._cos(latitude));
        if (cosH > 1.0 || cosH < -1.0) {
            // empty if block
        }
        double h = (rise ? 360.0 - SunRiseSet._acos(cosH) : SunRiseSet._acos(cosH)) / 15.0;
        t = h + ra - 0.06571 * t - 6.622;
        double ut = t - lngHour;
        return this._getDate(ut);
    }

    private static double _normalize(double value, double maxValue) {
        if (value > maxValue) {
            value -= maxValue;
        } else if (value < 0.0) {
            value += maxValue;
        }
        return value;
    }

    private static String _fmt(Date date, TimeZone tz) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
        dateFormat.setTimeZone(tz);
        return dateFormat.format(date);
    }

    private Date _getDate(double hours) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UT"));
        cal.setTime(this._date);
        int h = cal.get(11);
        boolean nextDay = hours < (double)h;
        CalendarUtil.setHours(cal, hours, nextDay);
        return cal.getTime();
    }

    public static void main(String[] args) {
        SiteDesc site = ElevationPlotUtil.MAUNA_KEA;
        TimeZone tz = site.getTimeZone();
        Calendar cal = Calendar.getInstance(tz);
        cal.set(2005, 2, 8, 12, 0, 0);
        Date date = cal.getTime();
        SunRiseSet srs = new SunRiseSet(date, site);
        System.out.println("Date = " + SunRiseSet._fmt(date, tz) + ", site = " + site.getName());
        System.out.println("Sunset                      = " + SunRiseSet._fmt(srs.getSunset(), tz));
        System.out.println("Sunrise                     = " + SunRiseSet._fmt(srs.getSunrise(), tz));
        System.out.println("CivilTwilight Start         = " + SunRiseSet._fmt(srs.getCivilTwilightStart(), tz));
        System.out.println("Civil Twilight End          = " + SunRiseSet._fmt(srs.getCivilTwilightEnd(), tz));
        System.out.println("NauticalTwilight Start      = " + SunRiseSet._fmt(srs.getNauticalTwilightStart(), tz));
        System.out.println("NauticalTwilight End        = " + SunRiseSet._fmt(srs.getNauticalTwilightEnd(), tz));
        System.out.println("Astronomical Twilight Start = " + SunRiseSet._fmt(srs.getAstronomicalTwilightStart(), tz));
        System.out.println("AstronomicalTwilight End    = " + SunRiseSet._fmt(srs.getAstronomicalTwilightEnd(), tz));
        System.out.println();
        cal.set(2005, 2, 9, 12, 0, 0);
        date = cal.getTime();
        srs = new SunRiseSet(date, site);
        tz = site.getTimeZone();
        System.out.println("Date = " + SunRiseSet._fmt(date, tz) + ", site = " + site.getName());
        System.out.println("Sunset                      = " + SunRiseSet._fmt(srs.getSunset(), tz));
        System.out.println("Sunrise                     = " + SunRiseSet._fmt(srs.getSunrise(), tz));
        System.out.println("CivilTwilight Start         = " + SunRiseSet._fmt(srs.getCivilTwilightStart(), tz));
        System.out.println("Civil Twilight End          = " + SunRiseSet._fmt(srs.getCivilTwilightEnd(), tz));
        System.out.println("NauticalTwilight Start      = " + SunRiseSet._fmt(srs.getNauticalTwilightStart(), tz));
        System.out.println("NauticalTwilight End        = " + SunRiseSet._fmt(srs.getNauticalTwilightEnd(), tz));
        System.out.println("Astronomical Twilight Start = " + SunRiseSet._fmt(srs.getAstronomicalTwilightStart(), tz));
        System.out.println("AstronomicalTwilight End    = " + SunRiseSet._fmt(srs.getAstronomicalTwilightEnd(), tz));
    }
}

