/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.image.ImageChangeEvent;
import jsky.image.graphics.gui.CanvasDraw;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.util.I18N;
import jsky.util.gui.BasicWindowMonitor;

public class ImageGraphicsMenu
extends JMenu {
    private static final I18N _I18N = I18N.getInstance(ImageGraphicsMenu.class);
    protected CanvasDraw canvasDraw;
    protected JMenuItem saveGraphicsMenuItem;

    public ImageGraphicsMenu(CanvasDraw canvasDraw) {
        super("Graphics");
        this.canvasDraw = canvasDraw;
        this.add(this.createDrawingModeMenu());
        this.add(this.createLineWidthMenu());
        this.add(this.createOutlineMenu());
        this.add(this.createFillMenu());
        this.add(this.createCompositeMenu());
        this.add(this.createFontMenu());
        this.addSeparator();
        this.add(canvasDraw.deleteSelectedAction);
        this.add(canvasDraw.clearAction);
        this.addSeparator();
        this.add(new JCheckBoxMenuItem(canvasDraw.hideGraphicsAction));
        this.addSeparator();
        this.saveGraphicsMenuItem = this.createSaveGraphicsWithImageMenuItem();
        this.add(this.saveGraphicsMenuItem);
        canvasDraw.getImageDisplay().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewImage() && !e.isBefore()) {
                    ImageGraphicsMenu.this.updateStates();
                }
            }
        });
        this.updateStates();
    }

    protected void updateStates() {
        this.saveGraphicsMenuItem.setEnabled(this.canvasDraw.getImageDisplay().getFitsImage() != null);
    }

    protected JMenu createDrawingModeMenu() {
        JMenu menu = new JMenu(_I18N.getString("drawingMode"));
        ButtonGroup group = new ButtonGroup();
        final JRadioButtonMenuItem[] drawingModeMenuItems = new JRadioButtonMenuItem[CanvasDraw.NUM_DRAWING_MODES];
        for (int i = 0; i < CanvasDraw.NUM_DRAWING_MODES; ++i) {
            AbstractAction a = this.canvasDraw.getDrawingModeAction(i);
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(a);
            menu.add(menuItem);
            group.add(menuItem);
            drawingModeMenuItems[i] = menuItem;
        }
        drawingModeMenuItems[0].setSelected(true);
        this.canvasDraw.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int drawingMode = ImageGraphicsMenu.this.canvasDraw.getDrawingMode();
                if (!drawingModeMenuItems[drawingMode].isSelected()) {
                    drawingModeMenuItems[drawingMode].setSelected(true);
                }
            }
        });
        return menu;
    }

    protected JMenu createLineWidthMenu() {
        JMenu menu = new JMenu(_I18N.getString("lineWidth"));
        ButtonGroup group = new ButtonGroup();
        int n = CanvasDraw.NUM_LINE_WIDTHS;
        for (int i = 0; i < n; ++i) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.canvasDraw.getLineWidthAction(i));
            menu.add(menuItem);
            group.add(menuItem);
        }
        menu.getItem(0).setSelected(true);
        return menu;
    }

    protected JMenu createOutlineMenu() {
        JMenu menu = new JMenu(_I18N.getString("outline"));
        ButtonGroup group = new ButtonGroup();
        int n = CanvasDraw.NUM_COLORS;
        for (int i = 0; i < n; ++i) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.canvasDraw.getOutlineAction(i));
            menuItem.setBackground(CanvasDraw.COLORS[i]);
            if (CanvasDraw.COLOR_NAMES[i] != null) {
                menuItem.setText(CanvasDraw.COLOR_NAMES[i]);
            }
            menu.add(menuItem);
            group.add(menuItem);
        }
        menu.getItem(0).setSelected(true);
        return menu;
    }

    protected JMenu createFillMenu() {
        JMenu menu = new JMenu(_I18N.getString("fill"));
        ButtonGroup group = new ButtonGroup();
        int n = CanvasDraw.NUM_COLORS;
        for (int i = 0; i < n; ++i) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.canvasDraw.getFillAction(i));
            menuItem.setBackground(CanvasDraw.COLORS[i]);
            if (CanvasDraw.COLOR_NAMES[i] != null) {
                menuItem.setText(CanvasDraw.COLOR_NAMES[i]);
            }
            menu.add(menuItem);
            group.add(menuItem);
        }
        menu.getItem(n - 1).setSelected(true);
        return menu;
    }

    protected JMenu createCompositeMenu() {
        JMenu menu = new JMenu(_I18N.getString("composite"));
        ButtonGroup group = new ButtonGroup();
        int n = CanvasDraw.NUM_COMPOSITES;
        for (int i = 0; i < n; ++i) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.canvasDraw.getCompositeAction(i));
            menu.add(menuItem);
            group.add(menuItem);
        }
        menu.getItem(n - 1).setSelected(true);
        return menu;
    }

    protected JMenu createFontMenu() {
        JMenu menu = new JMenu(_I18N.getString("font"));
        ButtonGroup group = new ButtonGroup();
        int n = CanvasDraw.NUM_FONTS;
        for (int i = 0; i < n; ++i) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.canvasDraw.getFontAction(i));
            menuItem.setFont(CanvasDraw.FONTS[i]);
            menu.add(menuItem);
            group.add(menuItem);
        }
        menu.getItem(3).setSelected(true);
        return menu;
    }

    protected JMenuItem createSaveGraphicsWithImageMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("saveGraphicsWithImage"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageGraphicsMenu.this.canvasDraw.imageDisplay.saveGraphicsWithImage();
            }
        });
        return menuItem;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("ImageGraphicsMenu");
        DivaMainImageDisplay imageDisplay = new DivaMainImageDisplay();
        if (args.length > 0) {
            try {
                imageDisplay.setFilename(args[0]);
            }
            catch (Exception e) {
                System.out.println("error: " + e.toString());
                System.exit(1);
            }
        }
        CanvasDraw canvasDraw = new CanvasDraw(imageDisplay);
        JMenuBar menubar = new JMenuBar();
        menubar.add(new ImageGraphicsMenu(canvasDraw));
        frame.getContentPane().add((Component)menubar, "North");
        frame.getContentPane().add((Component)((Object)imageDisplay), "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener((WindowListener)new BasicWindowMonitor());
    }
}

