/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codec.PNMEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFEncodeParam;
import diva.canvas.GraphicsPane;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import jsky.coords.WorldCoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.image.fits.codec.FITSImage;
import jsky.image.fits.gui.FITSHDUChooser;
import jsky.image.fits.gui.FITSHDUChooserFrame;
import jsky.image.fits.gui.FITSKeywordsFrame;
import jsky.image.graphics.MeasureBand;
import jsky.image.graphics.gui.CanvasDraw;
import jsky.image.graphics.gui.FITSGraphics;
import jsky.image.gui.DivaGraphicsImageDisplay;
import jsky.image.gui.ImageColorsFrame;
import jsky.image.gui.ImageCutLevelsFrame;
import jsky.image.gui.ImageDisplayControlFrame;
import jsky.image.gui.ImageHistoryItem;
import jsky.image.gui.ImageHistoryList;
import jsky.image.gui.ImagePrintDialog;
import jsky.image.gui.ImagePropertiesFrame;
import jsky.image.gui.ImageSaveDialog;
import jsky.image.gui.MainImageDisplay;
import jsky.image.gui.PickObject;
import jsky.image.gui.PickObjectFrame;
import jsky.util.FileUtil;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.Resources;
import jsky.util.SwingWorker;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ExampleFileFilter;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanel;
import jsky.util.gui.SwingUtil;
import nom.tam.fits.FitsException;
import nom.tam.fits.ImageHDU;
import nom.tam.util.BufferedFile;

public class DivaMainImageDisplay
extends DivaGraphicsImageDisplay
implements MainImageDisplay {
    private static final I18N _I18N = I18N.getInstance(DivaMainImageDisplay.class);
    private ProgressPanel _progressPanel;
    private JFileChooser _fileChooser;
    private ImageSaveDialog _saveDialog;
    private ImagePrintDialog _printDialog;
    private String _filename;
    private boolean _saveNeeded = false;
    private URL _url;
    private URL _origURL;
    private String _title = _I18N.getString("imageDisplay");
    private CanvasDraw _canvasDraw;
    private ImageCutLevelsFrame _imageCutLevelsFrame;
    private FITSKeywordsFrame _fitsKeywordsFrame;
    private ImagePropertiesFrame _imagePropertiesFrame;
    private ImageColorsFrame _imageColorsFrame;
    private PickObjectFrame _pickObjectFrame;
    private PickObject _pickObjectPanel;
    private FITSHDUChooserFrame _fitsHDUChooserFrame;
    private FITSHDUChooser _fitsHDUChooser;
    private FITSGraphics _fitsGraphics;
    private ImageChangeEvent _imageChangeEvent = new ImageChangeEvent((Object)this);
    private SwingWorker _worker;
    private ImageHistoryList _historyList;
    private AbstractAction _openAction = new AbstractAction(_I18N.getString("open"), Resources.getIcon((String)"Open24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("imageOpenTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.open();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _openUrlAction = new AbstractAction(_I18N.getString("openURL")){
        {
            this.putValue("ShortDescription", _I18N.getString("openURLTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            DivaMainImageDisplay.this.openURL();
        }
    };
    private AbstractAction _clearAction = new AbstractAction(_I18N.getString("clearImage")){
        {
            this.putValue("ShortDescription", _I18N.getString("clearImageTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            DivaMainImageDisplay.this.clear();
        }
    };
    private AbstractAction _saveAction = new AbstractAction(_I18N.getString("save"), Resources.getIcon((String)"Save24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("saveImageFileTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.save(true);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _saveAsAction = new AbstractAction(_I18N.getString("saveAs"), Resources.getIcon((String)"SaveAs24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("saveAsImageFileTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.saveAs();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _printPreviewAction = new AbstractAction(_I18N.getString("printPreview"), Resources.getIcon((String)"PrintPreview24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("printPreviewTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.printPreview();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _printAction = new AbstractAction(_I18N.getString("print") + "...", Resources.getIcon((String)"Print24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("prinTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.print();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _cutLevelsAction = new AbstractAction(_I18N.getString("cutLevels"), Resources.getIcon((String)"CutLevels24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("cutLevelsTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.editCutLevels();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _colorsAction = new AbstractAction(_I18N.getString("colors"), Resources.getIcon((String)"Palette.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("colorsTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.editColors();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _fitsExtensionsAction = new AbstractAction(_I18N.getString("fitsExt"), Resources.getIcon((String)"colmeta0.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("fitsExtTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.viewFitsExtensions();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private boolean _inBlankImage = false;

    public DivaMainImageDisplay(GraphicsPane pane) {
        super(pane, new ImageProcessor(), "Main Image");
        this._historyList = new ImageHistoryList(this);
        this.setDownloadState(false);
        this.updateEnabledStates();
        new MeasureBand(this);
        this._canvasDraw = new CanvasDraw(this);
        this._fitsGraphics = new FITSGraphics(this);
    }

    public DivaMainImageDisplay() {
        this(new GraphicsPane());
    }

    public ImageDisplayControlFrame newWindow() {
        ImageDisplayControlFrame f = new ImageDisplayControlFrame();
        f.getImageDisplayControl().getImageDisplay().setTitle(this.getTitle());
        f.setVisible(true);
        return f;
    }

    public CanvasDraw getCanvasDraw() {
        return this._canvasDraw;
    }

    @Override
    public void setFilename(String fileOrUrl) {
        if (fileOrUrl.startsWith("http:")) {
            this.setURL(FileUtil.makeURL(null, (String)fileOrUrl));
            return;
        }
        if (fileOrUrl.startsWith("file:")) {
            fileOrUrl = FileUtil.makeURL(null, (String)fileOrUrl).getPath();
        }
        if (!this.checkSave()) {
            return;
        }
        this._canvasDraw.clear();
        this._historyList.addToHistory();
        this._filename = fileOrUrl;
        this._url = this._origURL = FileUtil.makeURL(null, (String)fileOrUrl);
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage != null) {
            fitsImage.close();
            fitsImage.clearTileCache();
            this.clearFitsImage();
        }
        if (this.isJAIImageType(this._filename)) {
            try {
                this.setImage((PlanarImage)JAI.create((String)"fileload", (Object)this._filename));
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
                this._filename = null;
                this._origURL = null;
                this._url = null;
                this.clear();
            }
        } else {
            try {
                fitsImage = new FITSImage(this._filename);
                this.initFITSImage(fitsImage);
                this.setImage(fitsImage);
            }
            catch (Exception e) {
                try {
                    this.setImage((PlanarImage)JAI.create((String)"fileload", (Object)this._filename));
                }
                catch (Exception ex) {
                    DialogUtil.error((Exception)e);
                    this._filename = null;
                    this._origURL = null;
                    this._url = null;
                    this.clear();
                }
            }
        }
        this.updateTitle();
    }

    @Override
    public void setFilename(String fileOrUrl, URL url) {
        this.setFilename(fileOrUrl);
        this._origURL = url;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    public boolean isJAIImageType(String filename) {
        return filename.endsWith("jpg") || filename.endsWith("jpeg") || filename.endsWith("gif") || filename.endsWith("tif") || filename.endsWith("tiff") || filename.endsWith("ppm") || filename.endsWith("png") || filename.endsWith("pgm") || filename.endsWith("pnm") || filename.endsWith("bmp");
    }

    @Override
    public void clear() {
        super.clear();
        this._canvasDraw.clear();
        this.updateEnabledStates();
    }

    @Override
    public void displayFITSTable(int hdu) {
    }

    @Override
    public void deleteFITSTable(int hdu) {
    }

    @Override
    public String getObjectName() {
        Object o;
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage != null && (o = fitsImage.getKeywordValue("OBJECT")) instanceof String) {
            return o.toString();
        }
        return null;
    }

    @Override
    public void setURL(URL url) {
        this._origURL = url;
        String s = url.getProtocol();
        if (s.equals("file")) {
            this.setFilename(url.getFile());
        } else if (s.equals("http")) {
            this.downloadImageToTempFile(url);
        } else {
            DialogUtil.error((String)("Unsupported URL syntax: " + s));
        }
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    protected void initFITSImage(FITSImage fitsImage) throws IOException, FitsException {
        float scale;
        ImageHistoryItem hi;
        int numHDUs = fitsImage.getNumHDUs();
        if (numHDUs >= 2 && fitsImage.isEmpty() && fitsImage.getHDU(1) instanceof ImageHDU) {
            fitsImage.setHDU(1);
        }
        if ((hi = this._historyList.getImageHistoryItem(new File(this._filename))) != null) {
            scale = hi.scale;
            this.addChangeListener(hi);
        } else {
            scale = this.getScale();
        }
        if (scale != 1.0f) {
            fitsImage.setScale(scale);
        }
    }

    @Override
    public void updateImageData() {
        if (this._filename != null) {
            this.setFilename(this._filename);
        } else if (this._url != null) {
            this.setURL(this._url);
        }
    }

    protected void initProgressPanel() {
        if (this._progressPanel == null) {
            JFrame parent = SwingUtil.getFrame((Component)((Object)this));
            this._progressPanel = ProgressPanel.makeProgressPanel((String)"Downloading image data", (Component)parent);
            this._progressPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DivaMainImageDisplay.this._worker != null) {
                        DivaMainImageDisplay.this._worker.interrupt();
                        DivaMainImageDisplay.this._worker = null;
                    }
                }
            });
        }
        this._progressPanel.start();
    }

    protected void loadImageFromURL(final URL url) {
        if (!this.checkSave()) {
            return;
        }
        this._historyList.addToHistory();
        this._url = this._origURL = url;
        this._filename = null;
        this.initProgressPanel();
        this._worker = new SwingWorker(){

            public Object construct() {
                DivaMainImageDisplay.this.setDownloadState(true);
                try {
                    ProgressBarFilterInputStream in = DivaMainImageDisplay.this._progressPanel.getLoggedInputStream(url);
                    SeekableStream stream = SeekableStream.wrapInputStream((InputStream)in, (boolean)true);
                    DivaMainImageDisplay.this.setImage((PlanarImage)JAI.create((String)"stream", (Object)stream));
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }

            public void finished() {
                DivaMainImageDisplay.this._progressPanel.stop();
                Object o = this.getValue();
                if (o instanceof Exception && !(o instanceof ProgressException)) {
                    DialogUtil.error((Exception)((Exception)o));
                }
                DivaMainImageDisplay.this.setDownloadState(false);
                DivaMainImageDisplay.this._worker = null;
            }
        };
        this._worker.start();
    }

    protected void downloadImageToTempFile(final URL url) {
        this.initProgressPanel();
        this._worker = new SwingWorker(){
            String filename;

            public Object construct() {
                DivaMainImageDisplay.this.setDownloadState(true);
                try {
                    String dir = Preferences.getPreferences().getCacheDir().getPath();
                    File file = File.createTempFile("jsky", ".tmp", new File(dir));
                    ProgressBarFilterInputStream in = DivaMainImageDisplay.this._progressPanel.getLoggedInputStream(url);
                    FileOutputStream out = new FileOutputStream(file);
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                    in.close();
                    out.close();
                    this.filename = file.toString();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }

            public void finished() {
                DivaMainImageDisplay.this._progressPanel.stop();
                DivaMainImageDisplay.this.setDownloadState(false);
                DivaMainImageDisplay.this._worker = null;
                Object o = this.getValue();
                if (o instanceof Exception && !(o instanceof ProgressException)) {
                    DialogUtil.error((Exception)((Exception)o));
                    return;
                }
                if (!DivaMainImageDisplay.this._progressPanel.isInterrupted()) {
                    DivaMainImageDisplay.this.setFilename(this.filename);
                }
            }
        };
        this._worker.start();
    }

    protected void setDownloadState(boolean downloading) {
        this._historyList.setDownloadState(downloading);
        if (downloading) {
            this._openAction.setEnabled(false);
        } else {
            this._openAction.setEnabled(true);
        }
    }

    protected void updateEnabledStates() {
        boolean fileLoaded = this._filename != null;
        boolean imageLoaded = fileLoaded || this._url != null;
        this._saveAction.setEnabled(fileLoaded && this._saveNeeded);
        this._saveAsAction.setEnabled(imageLoaded);
        this._cutLevelsAction.setEnabled(imageLoaded);
        this._colorsAction.setEnabled(imageLoaded);
    }

    public boolean loadCachedImage(double ra, double dec) {
        return this._historyList.loadCachedImage(ra, dec);
    }

    public void addHistoryMenuItems(JMenu menu) {
        this._historyList.addHistoryMenuItems(menu);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChange(ImageChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged((ChangeEvent)e);
        }
        e.reset();
    }

    public boolean isMainWindow() {
        return true;
    }

    public void exit() {
        if (!this.checkSave()) {
            return;
        }
        System.exit(0);
    }

    @Override
    protected void newImage(boolean before) {
        super.newImage(before);
        if (!before) {
            this._fitsGraphics.loadGraphicsFromImage(".GRAPHICS");
            FITSImage fitsImage = this.getFitsImage();
            this._fitsExtensionsAction.setEnabled(fitsImage != null && fitsImage.getNumHDUs() > 1);
            this.updateEnabledStates();
        }
        this._imageChangeEvent.setNewImage(true);
        this._imageChangeEvent.setBefore(before);
        this.fireChange(this._imageChangeEvent);
    }

    @Override
    protected void updateImage(PlanarImage im) {
        super.updateImage(im);
        if (im == null) {
            this.fireChange(this._imageChangeEvent);
            return;
        }
        this.fireChange(this._imageChangeEvent);
    }

    @Override
    public void setOrigin(Point2D.Double origin) {
        super.setOrigin(origin);
        this._imageChangeEvent.setNewOrigin(true);
    }

    @Override
    public void setScale(float scale) {
        super.setScale(scale);
        this._imageChangeEvent.setNewScale(true);
    }

    public void checkExtensions(boolean show) {
        boolean skipEmptyPrimary;
        int numHDUs;
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage == null || (numHDUs = fitsImage.getNumHDUs()) <= 1) {
            if (this._fitsHDUChooser != null) {
                this._fitsHDUChooser.clear();
                this._fitsHDUChooser.setShow(false);
            }
            return;
        }
        if (!show) {
            show = this._fitsHDUChooserFrame != null && this._fitsHDUChooserFrame.isVisible();
        }
        int currentHDU = fitsImage.getCurrentHDUIndex();
        boolean bl = skipEmptyPrimary = numHDUs >= 2 && currentHDU == 0 && fitsImage.isEmpty() && fitsImage.getHDU(1) instanceof ImageHDU;
        if (!show) {
            boolean bl2 = show = skipEmptyPrimary && numHDUs > 2;
        }
        if (!show && numHDUs <= 1) {
            return;
        }
        if (this._fitsHDUChooser != null) {
            this._fitsHDUChooser.updateDisplay(fitsImage);
        } else {
            this._fitsHDUChooserFrame = new FITSHDUChooserFrame(this, fitsImage);
            this._fitsHDUChooser = this._fitsHDUChooserFrame.getFitsHDUChooser();
        }
        if (skipEmptyPrimary) {
            this._fitsHDUChooser.selectImage(1);
        }
        this._fitsHDUChooser.setShow(show);
    }

    public void saveGraphicsWithImage() {
        try {
            this._fitsGraphics.saveGraphicsWithImage(".GRAPHICS");
            this.setSaveNeeded(true);
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
    }

    public void close() {
        if (this.isMainWindow()) {
            if (!this.checkSave()) {
                return;
            }
            this.dispose();
        } else {
            JFrame parent = SwingUtil.getFrame((Component)((Object)this));
            if (parent != null) {
                parent.setVisible(false);
            }
        }
    }

    public void dispose() {
        JFrame parent;
        if (this._imageCutLevelsFrame != null) {
            this._imageCutLevelsFrame.dispose();
        }
        if (this._imagePropertiesFrame != null) {
            this._imagePropertiesFrame.dispose();
        }
        if (this._imageColorsFrame != null) {
            this._imageColorsFrame.dispose();
        }
        if (this._pickObjectFrame != null) {
            this._pickObjectFrame.dispose();
        }
        if (this._fitsHDUChooserFrame != null) {
            this._fitsHDUChooserFrame.dispose();
        }
        if ((parent = SwingUtil.getFrame((Component)((Object)this))) != null) {
            parent.dispose();
        }
    }

    public void editCutLevels() {
        if (this._imageCutLevelsFrame != null) {
            SwingUtil.showFrame((JFrame)this._imageCutLevelsFrame);
        } else {
            this._imageCutLevelsFrame = new ImageCutLevelsFrame(this);
        }
    }

    public void editColors() {
        if (this._imageColorsFrame != null) {
            SwingUtil.showFrame((JFrame)this._imageColorsFrame);
        } else {
            this._imageColorsFrame = new ImageColorsFrame(this);
        }
    }

    public void pickObject() {
        if (this._pickObjectFrame != null) {
            SwingUtil.showFrame((JFrame)this._pickObjectFrame);
        } else {
            this._pickObjectFrame = new PickObjectFrame(this);
            this._pickObjectPanel = this._pickObjectFrame.getPickObject();
            this._pickObjectPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DivaMainImageDisplay.this.pickedObject();
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DivaMainImageDisplay.this._pickObjectPanel.pickObject();
            }
        });
    }

    protected void pickedObject() {
    }

    public void viewFitsExtensions() {
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage != null && fitsImage.getNumHDUs() > 1) {
            this.checkExtensions(true);
        } else {
            DialogUtil.error((String)"There are no FITS extensions for this image.");
        }
    }

    public void viewFitsKeywords() {
        if (this._fitsKeywordsFrame != null) {
            SwingUtil.showFrame((JFrame)this._fitsKeywordsFrame);
            this._fitsKeywordsFrame.getFITSKeywords().updateDisplay();
        } else {
            this._fitsKeywordsFrame = new FITSKeywordsFrame(this);
        }
    }

    public void viewImageProperties() {
        if (this._imagePropertiesFrame != null) {
            SwingUtil.showFrame((JFrame)this._imagePropertiesFrame);
            this._imagePropertiesFrame.getImageProperties().updateDisplay();
        } else {
            this._imagePropertiesFrame = new ImagePropertiesFrame(this);
        }
    }

    public void open() {
        int option;
        if (this._fileChooser == null) {
            this._fileChooser = DivaMainImageDisplay.makeImageFileChooser();
        }
        if ((option = this._fileChooser.showOpenDialog((Component)((Object)this))) == 0 && this._fileChooser.getSelectedFile() != null) {
            this.setFilename(this._fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public static JFileChooser makeImageFileChooser() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        ExampleFileFilter fitsFilter = new ExampleFileFilter(new String[]{"fits", "fits.gz", "fits.Z", "hfits"}, "FITS Image Files");
        fileChooser.addChoosableFileFilter((FileFilter)fitsFilter);
        ExampleFileFilter jpgFilter = new ExampleFileFilter(new String[]{"jpg", "jpeg"}, "JPEG Compressed Image Files");
        fileChooser.addChoosableFileFilter((FileFilter)jpgFilter);
        ExampleFileFilter gifFilter = new ExampleFileFilter("gif", "GIF Image Files");
        fileChooser.addChoosableFileFilter((FileFilter)gifFilter);
        ExampleFileFilter tifFilter = new ExampleFileFilter(new String[]{"tif", "tiff"}, "TIFF Image Files");
        fileChooser.addChoosableFileFilter((FileFilter)tifFilter);
        ExampleFileFilter ppmFilter = new ExampleFileFilter(new String[]{"ppm", "png", "pgm"}, "PPM Image Files");
        fileChooser.addChoosableFileFilter((FileFilter)ppmFilter);
        fileChooser.setFileFilter((FileFilter)fitsFilter);
        return fileChooser;
    }

    public void openURL() {
        String urlStr = DialogUtil.input((String)"Enter the World Wide Web location (URL) to display:");
        if (urlStr != null) {
            URL url;
            try {
                url = new URL(urlStr);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
                return;
            }
            this.setURL(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blankImage(double ra, double dec) {
        if (!this._inBlankImage) {
            this._inBlankImage = true;
            try {
                if (!this.checkSave()) {
                    return;
                }
                this._historyList.addToHistory();
                this._filename = null;
                this._url = null;
                this._origURL = null;
                super.blankImage(ra, dec);
                this.updateEnabledStates();
            }
            finally {
                this._inBlankImage = false;
            }
        }
    }

    @Override
    public void setSaveNeeded(boolean b) {
        this._saveNeeded = b;
        this.updateEnabledStates();
        this._imageChangeEvent.setEditStateChanged(true);
        this.fireChange(this._imageChangeEvent);
    }

    public boolean isSaveNeeded() {
        return this._saveNeeded;
    }

    @Override
    public boolean checkSave() {
        if (this._saveNeeded) {
            String s = this._filename;
            s = s != null ? new File(s).getName() : (this._url != null ? this._url.toString() : "unknown");
            int ans = DialogUtil.confirm((String)("Save changes to '" + s + "'?"));
            if (ans == 0) {
                this.save(false);
            } else if (ans == 2) {
                return false;
            }
            this.setSaveNeeded(false);
        }
        return true;
    }

    public void save(boolean reload) {
        if (this._filename != null) {
            this.saveAs(this._filename, reload);
        } else {
            this.saveAs();
        }
    }

    @Override
    public void saveAs() {
        if (this._saveDialog == null) {
            this._saveDialog = new ImageSaveDialog(this);
        }
        this._saveDialog.save();
    }

    @Override
    public void saveAs(String filename, boolean reload) {
        String s = filename.toLowerCase();
        String tmpFile = filename + ".TMP";
        File tf = new File(tmpFile);
        if (tf.exists() && !tf.delete()) {
            DialogUtil.error((String)("Can't delete temp file: " + tmpFile));
            return;
        }
        if (s.endsWith(".jpeg") || s.endsWith(".jpg")) {
            JAI.create((String)"filestore", (RenderedImage)this.getDisplayImage(), (Object)tmpFile, (Object)"JPEG", (Object)new JPEGEncodeParam());
        } else if (s.endsWith(".png")) {
            JAI.create((String)"filestore", (RenderedImage)this.getImage(), (Object)tmpFile, (Object)"PNG", (Object)new PNGEncodeParam.Gray());
        } else if (s.endsWith(".pnm")) {
            JAI.create((String)"filestore", (RenderedImage)this.getImage(), (Object)tmpFile, (Object)"PNM", (Object)new PNMEncodeParam());
        } else if (s.endsWith(".tiff") || s.endsWith(".tif")) {
            JAI.create((String)"filestore", (RenderedImage)this.getImage(), (Object)tmpFile, (Object)"TIFF", (Object)new TIFFEncodeParam());
        } else if (s.endsWith(".bmp")) {
            JAI.create((String)"filestore", (RenderedImage)this.getDisplayImage(), (Object)tmpFile, (Object)"BMP", (Object)new BMPEncodeParam());
        } else {
            FITSImage fitsImage = this.getFitsImage();
            if (fitsImage != null && this._url != null) {
                try {
                    BufferedFile bf = new BufferedFile(tmpFile, "rw");
                    fitsImage.getFits().write((DataOutput)bf);
                    bf.close();
                    fitsImage.getFits().getStream().close();
                }
                catch (Exception e) {
                    DialogUtil.error((Exception)e);
                }
            } else {
                DialogUtil.error((String)("Can't determine image format for: " + filename));
            }
        }
        File file = new File(filename);
        if (file.exists()) {
            File backup = new File(filename + ".BAK");
            if (backup.exists() && !backup.delete()) {
                DialogUtil.error((String)("Can't delete backup file: " + backup));
                return;
            }
            if (!file.renameTo(backup)) {
                DialogUtil.error((String)("Rename " + file + " to " + backup + " failed"));
                return;
            }
        }
        if (!new File(tmpFile).renameTo(file)) {
            DialogUtil.error((String)("Rename " + tmpFile + " to " + file + " failed"));
            return;
        }
        this.setSaveNeeded(false);
        if (reload) {
            this._historyList.setNoStack(true);
            try {
                this.setFilename(filename);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
            this._historyList.setNoStack(false);
        }
    }

    @Override
    public void paintImageAndGraphics(Graphics2D g2D) {
        this.getCanvasPane().paint(g2D);
    }

    public void printPreview() {
        if (this._printDialog == null) {
            this._printDialog = new ImagePrintDialog(this);
        }
        this._printDialog.preview();
    }

    @Override
    public void print() {
        try {
            if (this._printDialog == null) {
                this._printDialog = new ImagePrintDialog(this);
            }
            this._printDialog.print();
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
    }

    public void setTitle(String s) {
        this._title = s;
        this.updateTitle();
    }

    public String getTitle() {
        return this._title;
    }

    protected void updateTitle() {
        JFrame parent;
        String s = this._title;
        if (this._filename != null) {
            s = s + " - " + new File(this._filename).getName();
        }
        if ((parent = this.getParentFrame()) != null) {
            parent.setTitle(s);
        }
    }

    public JFrame getParentFrame() {
        return SwingUtil.getFrame((Component)((Object)this));
    }

    public AbstractAction getOpenAction() {
        return this._openAction;
    }

    public AbstractAction getOpenUrlAction() {
        return this._openUrlAction;
    }

    public AbstractAction getClearAction() {
        return this._clearAction;
    }

    public AbstractAction getBackAction() {
        return this._historyList.getBackAction();
    }

    public AbstractAction getForwAction() {
        return this._historyList.getForwAction();
    }

    public AbstractAction getColorsAction() {
        return this._colorsAction;
    }

    public AbstractAction getFitsExtensionsAction() {
        return this._fitsExtensionsAction;
    }

    public AbstractAction getCutLevelsAction() {
        return this._cutLevelsAction;
    }

    public AbstractAction getSaveAction() {
        return this._saveAction;
    }

    public AbstractAction getSaveAsAction() {
        return this._saveAsAction;
    }

    public AbstractAction getPrintPreviewAction() {
        return this._printPreviewAction;
    }

    public AbstractAction getPrintAction() {
        return this._printAction;
    }

    public ImageCutLevelsFrame getImageCutLevelsFrame() {
        return this._imageCutLevelsFrame;
    }

    public FITSKeywordsFrame getFitsKeywordsFrame() {
        return this._fitsKeywordsFrame;
    }

    public ImagePropertiesFrame getImagePropertiesFrame() {
        return this._imagePropertiesFrame;
    }

    public ImageColorsFrame getImageColorsFrame() {
        return this._imageColorsFrame;
    }

    public PickObjectFrame getPickObjectFrame() {
        return this._pickObjectFrame;
    }

    public PickObject getPickObjectPanel() {
        return this._pickObjectPanel;
    }

    public FITSHDUChooserFrame getFitsHDUChooserFrame() {
        return this._fitsHDUChooserFrame;
    }

    public FITSHDUChooser getFitsHDUChooser() {
        return this._fitsHDUChooser;
    }

    public FITSGraphics getFitsGraphics() {
        return this._fitsGraphics;
    }

    @Override
    public double[] getDefaultSearchRadius(WorldCoords centerPos, boolean useImageSize) {
        Point2D.Double p1 = new Point2D.Double(1.0, 1.0);
        WorldCoordinateConverter wcs = this.getWCS();
        wcs.imageToWorldCoords(p1, false);
        double equinox = wcs.getEquinox();
        WorldCoords origin = new WorldCoords(p1, equinox);
        double maxRadius = centerPos.dist(origin);
        return new double[]{0.0, maxRadius};
    }

    @Override
    public double[] getDefaultSearchMagRange() {
        return null;
    }

    @Override
    public URL getOrigURL() {
        return this._origURL;
    }

    public void clearHistory() {
        this._historyList.clearHistory();
    }
}

