/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.dynwrapper;

import alma.acs.component.dynwrapper.ComponentInvocationHandler;
import alma.acs.component.dynwrapper.DynWrapperException;
import alma.acs.component.dynwrapper.TypeMapper;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArrayMapper
extends TypeMapper {
    public ArrayMapper(Object delegate, Logger logger) {
        super(delegate, logger);
    }

    @Override
    public boolean canTranslate(Class<?> oldObjClass, Class<?> newObjClass, ComponentInvocationHandler invHandler) {
        boolean canTranslate = false;
        try {
            if (oldObjClass.isArray() && newObjClass.isArray()) {
                int dim1 = oldObjClass.getName().lastIndexOf(91) + 1;
                int dim2 = newObjClass.getName().lastIndexOf(91) + 1;
                if (dim1 == 1 && dim2 == 1) {
                    Class<?> oldCompType = oldObjClass.getComponentType();
                    Class<?> newCompType = newObjClass.getComponentType();
                    canTranslate = invHandler.canTranslate(oldCompType, newCompType);
                }
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.FINE, "failed to check array translation", e);
        }
        if (this.m_verbose) {
            String msg = "can " + (canTranslate ? "" : "not ") + "translate from class '" + oldObjClass.getName() + "' to class '" + newObjClass.getName() + "'.";
            this.m_logger.finer(msg);
        }
        return canTranslate;
    }

    @Override
    public <T> Object translate(Object oldArray, T newObjectTemplate, Class<T> newArrayClass, ComponentInvocationHandler invHandler) throws DynWrapperException {
        int length = Array.getLength(oldArray);
        Class<?> newType = newArrayClass.getComponentType();
        Object newArray = Array.newInstance(newType, length);
        for (int i = 0; i < length; ++i) {
            Object oldValue = Array.get(oldArray, i);
            Object newValue = invHandler.translate(oldValue, null, newType);
            Array.set(newArray, i, newValue);
        }
        return newArray;
    }
}

