/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container.archive;

import alma.ArchiveIdentifierError.wrappers.AcsJIdentifierUnavailableEx;
import alma.ArchiveIdentifierError.wrappers.AcsJIdentifierUnexpectedEx;
import alma.ArchiveIdentifierError.wrappers.AcsJRangeExhaustedEx;
import alma.ArchiveIdentifierError.wrappers.AcsJRangeLockedEx;
import alma.ArchiveIdentifierError.wrappers.AcsJRangeUnavailableEx;
import alma.ArchiveIdentifierError.wrappers.AcsJRangeUnlockedEx;
import alma.ArchiveIdentifierError.wrappers.AcsJUidAlreadyExistsEx;
import alma.acs.container.archive.Range;
import alma.archive.range.IdentifierRange;
import alma.entities.commonentity.EntityRefT;
import alma.entities.commonentity.EntityT;
import alma.xmlstore.IdentifierJ;
import alma.xmlstore.IdentifierPackage.NotAvailable;
import alma.xmlstore.IdentifierPackage.NotFound;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UIDLibrary {
    private final Logger logger;
    private static volatile Range defaultRange;
    private final HashMap<URI, Range> idRanges;
    private final HashMap<URI, Range> refRanges;

    public UIDLibrary(Logger logger) {
        this.logger = logger;
        this.idRanges = new HashMap();
        this.refRanges = new HashMap();
    }

    public synchronized void assignUniqueEntityId(EntityT entity, IdentifierJ identifier) throws AcsJUidAlreadyExistsEx, AcsJIdentifierUnavailableEx, AcsJRangeUnavailableEx, AcsJIdentifierUnexpectedEx {
        try {
            this.checkDefaultRange(identifier);
            defaultRange.assignUniqueEntityId(entity);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Assigned UID '" + entity.getEntityId() + "' to entity of type " + entity.getEntityTypeName());
            }
        }
        catch (AcsJUidAlreadyExistsEx e) {
            throw e;
        }
        catch (AcsJRangeUnavailableEx e) {
            throw e;
        }
        catch (AcsJIdentifierUnavailableEx e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AcsJIdentifierUnexpectedEx(e);
        }
    }

    public synchronized void replaceUniqueEntityId(EntityT entity, IdentifierJ identifier) throws AcsJRangeUnavailableEx, AcsJIdentifierUnavailableEx, AcsJIdentifierUnexpectedEx {
        if (entity == null) {
            throw new NullPointerException("argument 'entity' must not be null.");
        }
        try {
            String oldUid = entity.getEntityId();
            this.checkDefaultRange(identifier);
            defaultRange.replaceUniqueEntityId(entity);
            this.logger.info("Replaced old UID '" + oldUid + "' with new UID '" + entity.getEntityId() + "' on an entity of type " + entity.getEntityTypeName());
        }
        catch (AcsJRangeUnavailableEx e) {
            throw e;
        }
        catch (AcsJIdentifierUnavailableEx e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AcsJIdentifierUnexpectedEx(e);
        }
    }

    protected synchronized void checkDefaultRange(IdentifierJ identifier) throws AcsJRangeUnavailableEx, AcsJIdentifierUnavailableEx {
        if (identifier == null) {
            AcsJIdentifierUnavailableEx ex = new AcsJIdentifierUnavailableEx();
            ex.setContextInfo("Provided identifier reference is null.");
            throw ex;
        }
        try {
            if (defaultRange == null || !defaultRange.hasNextID()) {
                defaultRange = new Range(identifier.getNewRange());
            }
        }
        catch (NotAvailable e) {
            AcsJRangeUnavailableEx ex = new AcsJRangeUnavailableEx();
            ex.setRange("default");
            throw ex;
        }
    }

    public URI getNewRestrictedRange(int size, String user, IdentifierJ identifier, boolean printLogs) throws AcsJRangeUnavailableEx, AcsJIdentifierUnexpectedEx {
        Range range = null;
        try {
            if (printLogs) {
                this.logger.finest("UIDLibrary: Fetching a restricted range");
            }
            IdentifierRange idRange = identifier.getNewRestrictedRange(size, user);
            range = new Range(idRange);
        }
        catch (NotAvailable e) {
            throw new AcsJRangeUnavailableEx((Throwable)e);
        }
        URI uri = range.rangeId();
        if (this.idRanges.containsKey(uri)) {
            AcsJIdentifierUnexpectedEx ex = new AcsJIdentifierUnexpectedEx();
            ex.setContextInfo("Cannot store new range. URI occupied. This should never have happened by design!!");
            throw ex;
        }
        if (printLogs) {
            this.logger.finest("UIDLibrary: Storing Range under: " + uri.toASCIIString());
        }
        this.idRanges.put(uri, range);
        return uri;
    }

    public URI getNewRestrictedRange(int size, String user, IdentifierJ identifier) throws AcsJRangeUnavailableEx, AcsJIdentifierUnexpectedEx {
        return this.getNewRestrictedRange(size, user, identifier, true);
    }

    public void assignUniqueEntityId(EntityT entity, URI uri, boolean printLogs) throws AcsJRangeUnavailableEx, AcsJUidAlreadyExistsEx, AcsJRangeLockedEx, AcsJRangeExhaustedEx {
        if (this.idRanges.containsKey(uri)) {
            if (printLogs && this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("UIDLibrary: Assigning ID to entity from range " + uri.toASCIIString());
            }
        } else {
            AcsJRangeUnavailableEx ex = new AcsJRangeUnavailableEx();
            ex.setRange(uri.toASCIIString());
            throw ex;
        }
        Range r = this.idRanges.get(uri);
        r.assignUniqueEntityId(entity);
    }

    public void assignUniqueEntityId(EntityT entity, URI uri) throws AcsJRangeUnavailableEx, AcsJUidAlreadyExistsEx, AcsJRangeLockedEx, AcsJRangeExhaustedEx {
        this.assignUniqueEntityId(entity, uri, true);
    }

    public void fetchRange(URI uri, String user, IdentifierJ identifier) throws AcsJRangeUnavailableEx {
        IdentifierRange idRange = null;
        try {
            this.logger.finest("UIDLibrary: Fetching range: " + uri.toASCIIString());
            idRange = identifier.getExistingRange(uri.toASCIIString(), user);
        }
        catch (NotFound e) {
            throw new AcsJRangeUnavailableEx((Throwable)e);
        }
        Range r = new Range(idRange);
        if (this.refRanges.containsKey(uri)) {
            AcsJRangeUnavailableEx ex = new AcsJRangeUnavailableEx();
            ex.setRange(uri.toASCIIString());
            throw ex;
        }
        this.refRanges.put(uri, r);
    }

    public void assignUniqueEntityRef(EntityRefT ref, URI uri) throws AcsJRangeUnavailableEx, AcsJRangeExhaustedEx, AcsJRangeUnlockedEx {
        if (!this.refRanges.containsKey(uri)) {
            AcsJRangeUnavailableEx ex = new AcsJRangeUnavailableEx();
            ex.setRange(uri.toASCIIString());
            throw ex;
        }
        this.logger.finest("UIDLibrary: Assigning ID Ref to entity from: " + uri.toASCIIString());
        Range r = this.refRanges.get(uri);
        r.assignUniqueEntityRef(ref);
    }
}

