/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.components;

import alma.acs.container.ContainerServices;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.exceptions.ArchiveException;
import alma.archive.wrappers.ResultStruct;
import alma.xmlstore.ArchiveInternalError;
import alma.xmlstore.CursorPOA;
import alma.xmlstore.CursorPackage.QueryResult;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CursorImpl
extends CursorPOA {
    private final DBCursor cursor;
    private final ContainerServices containerServices;
    private final Logger logger;

    public CursorImpl(DBCursor cursor, ContainerServices cs) {
        if (cursor == null || cs == null) {
            throw new IllegalArgumentException("DBCursor and ContainerServices must not be null.");
        }
        this.cursor = cursor;
        this.containerServices = cs;
        this.logger = this.containerServices.getLogger();
    }

    public void close() {
        try {
            this.cursor.close();
        }
        catch (Throwable thr) {
            this.logger.log(Level.WARNING, "Failed to close the query cursor.", thr);
        }
        finally {
            try {
                this.containerServices.deactivateOffShoot((Object)this);
            }
            catch (Throwable thr) {
                this.logger.log(Level.WARNING, "Failed to deactivate the CORBA cursor object.", thr);
            }
        }
    }

    public boolean hasNext() throws ArchiveInternalError {
        try {
            return this.cursor.hasNext();
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError();
        }
    }

    public QueryResult next() throws ArchiveInternalError {
        try {
            ResultStruct res = this.cursor.next();
            QueryResult result = new QueryResult();
            result.xml = res.getXml();
            result.identifier = res.getUri().toASCIIString();
            return result;
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.getMessage());
        }
    }

    public QueryResult[] nextBlock(short size) throws ArchiveInternalError {
        try {
            ResultStruct[] res = this.cursor.nextBlock((int)size);
            QueryResult[] result = new QueryResult[size];
            for (int x = 0; x < res.length; ++x) {
                if (res[x] != null) {
                    result[x].xml = res[x].getXml();
                    result[x].identifier = res[x].getUri().toASCIIString();
                    continue;
                }
                result[x] = null;
            }
            return result;
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError();
        }
    }
}

