/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.loader;

import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.component.client.ComponentClient;
import alma.acs.container.archive.Range;
import alma.acs.logging.ClientLogManager;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.NamespaceDefinedException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.wrappers.Permissions;
import alma.xmlstore.Administrative;
import alma.xmlstore.ArchiveConnection;
import alma.xmlstore.ArchiveConnectionHelper;
import alma.xmlstore.ArchiveInternalError;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.omg.CORBA.Object;

public class SchemaLoader {
    static String errorString = new String();
    static boolean allFine = true;
    private SchemaManager smanager;
    private InternalIF internal;
    private IdentifierManager imanager;
    private URI identifier;
    private static Logger m_logger;
    private Range range;
    private SAXBuilder builder = new SAXBuilder();

    public SchemaLoader() {
        try {
            m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("SchemaLoader", false);
            this.internal = InternalIFFactory.getInternalIF((Logger)m_logger);
            this.smanager = this.internal.getSchemaManager("user");
            this.imanager = InternalIFFactory.getIdentifierManager((Logger)m_logger);
            this.internal.init();
            this.range = new Range(this.imanager.getNewRange());
            this.identifier = this.range.next();
        }
        catch (ModuleCriticalException e) {
            System.out.println("Critical exception:\n" + e.getCause().toString());
        }
        catch (Throwable e) {
            System.out.println("Critical Exception:\n" + e.toString());
        }
    }

    private Map checkNamespaces(List namespaces) throws DatabaseException, ModuleCriticalException, ArchiveException {
        HashMap<String, String> errors = new HashMap<String, String>();
        Map registered = this.smanager.namespaces();
        for (Namespace ns : namespaces) {
            String space;
            String prefix = ns.getPrefix();
            String uri = ns.getURI();
            if (!registered.containsKey(prefix) || (space = (String)registered.get(prefix)).equalsIgnoreCase(uri)) continue;
            errors.put(prefix, space);
        }
        return errors;
    }

    public void registerNamespaces(List namespaces) throws DatabaseException, MalformedURIException, ModuleCriticalException, ArchiveException, URISyntaxException {
        ListIterator iter = namespaces.listIterator();
        while (iter.hasNext()) {
            Namespace ns = (Namespace)iter.next();
            try {
                this.smanager.registerNamespace(ns.getPrefix(), new URI(ns.getURI()));
            }
            catch (NamespaceDefinedException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    public void associateNamespaces(List namespaces, URI schemaUri) throws DatabaseException, UnknownSchemaException, ModuleCriticalException, ArchiveException {
        ListIterator iter = namespaces.listIterator();
        while (iter.hasNext()) {
            Namespace ns = (Namespace)iter.next();
            String nsname = ns.getPrefix();
            this.smanager.assignNamespace(nsname, schemaUri);
        }
    }

    public void disassociateNamespaces(List namespaces, URI schemaUri) throws ModuleCriticalException, DatabaseException, ArchiveException {
        ListIterator iter = namespaces.listIterator();
        while (iter.hasNext()) {
            Namespace ns = (Namespace)iter.next();
            String nsname = ns.getPrefix();
            try {
                this.smanager.withdrawNamespace(nsname, schemaUri);
            }
            catch (Exception e) {
                m_logger.warning(e.toString());
            }
        }
    }

    private String addTab(String output, String text, int tab, boolean good) {
        int left = tab - ((String)output).length();
        for (int j = 0; j < left; ++j) {
            output = (String)output + " ";
        }
        output = good ? (String)output + "\u001b[33;32m" + text + "\u001b[m" : (String)output + "\u001b[33;31m" + text + "\u001b[m";
        return output;
    }

    private boolean addSchema(File schema, boolean update) {
        boolean retValue = true;
        String filename = schema.getName();
        java.lang.Object output = "Processing: " + filename + " ";
        String name = filename.substring(0, filename.indexOf("."));
        boolean stored = false;
        try {
            FileReader freader = new FileReader(schema);
            if (!freader.ready()) {
                throw new IOException("ERROR: Can not read from file " + String.valueOf(schema));
            }
            Document doc = this.builder.build((Reader)freader);
            freader.close();
            freader = null;
            Element root = doc.getRootElement();
            List namespaces = root.getAdditionalNamespaces();
            Map errors = this.checkNamespaces(namespaces);
            if (errors.isEmpty()) {
                XMLOutputter out = new XMLOutputter(Format.getRawFormat());
                String xml = out.outputString(doc);
                URI targetUri = null;
                URI newURI = this.identifier;
                try {
                    this.identifier = this.range.next();
                    targetUri = this.smanager.getSchemaURI(name);
                    if (update) {
                        output = (String)output + "Updating: " + String.valueOf(newURI);
                        this.smanager.updateSchema(name, xml, "", targetUri, newURI, "schemaLoader", new Permissions());
                        stored = true;
                        this.identifier = this.range.next();
                    } else {
                        output = (String)output + "No Update ";
                    }
                }
                catch (UnknownSchemaException e) {
                    try {
                        this.smanager.addSchema(name, xml, "", newURI, "schemaLoader", new Permissions());
                        stored = true;
                    }
                    catch (ModuleCriticalException e1) {
                        System.out.println("Critical exception:\n" + e1.getCause().toString());
                        output = this.addTab((String)output, " Failed", 70, false);
                        retValue = false;
                        stored = false;
                    }
                    output = (String)output + "Storing: " + String.valueOf(newURI);
                }
                catch (ModuleCriticalException e) {
                    System.out.println("Critical exception:\n" + e.getCause().toString());
                    output = this.addTab((String)output, " Failed", 70, false);
                    retValue = false;
                    stored = false;
                }
                catch (Throwable e) {
                    System.out.println("Critical Exception:\n" + e.toString());
                    output = this.addTab((String)output, " Failed", 70, false);
                    retValue = false;
                    stored = false;
                }
                try {
                    this.registerNamespaces(namespaces);
                    if (stored && targetUri != null) {
                        String oldSchema = this.internal.get(targetUri, "schemaLoader");
                        List oldNamespaces = this.builder.build((Reader)new StringReader(oldSchema)).getRootElement().getAdditionalNamespaces();
                        this.disassociateNamespaces(oldNamespaces, targetUri);
                    }
                    if (stored) {
                        this.associateNamespaces(namespaces, newURI);
                    }
                }
                catch (ModuleCriticalException e1) {
                    System.out.println("Critical exception:\n" + e1.getCause().toString());
                    output = this.addTab((String)output, " Failed", 70, false);
                    retValue = false;
                }
                output = this.addTab((String)output, " Done", 70, true);
                System.out.println((String)output);
            } else {
                output = this.addTab((String)output, " Failed", 70, false);
                retValue = false;
                System.out.println((String)output);
                for (String tag : errors.keySet()) {
                    String space = (String)errors.get(tag);
                    System.out.println("ERROR: " + tag + " already registered as " + space);
                }
            }
            doc = null;
        }
        catch (JDOMException e) {
            output = this.addTab((String)output, " Failed", 70, false);
            retValue = false;
            System.out.println((String)output);
            e.printStackTrace();
        }
        catch (IOException e) {
            output = this.addTab((String)output, " Failed", 70, false);
            retValue = false;
            System.out.println((String)output);
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            output = this.addTab((String)output, " Failed", 70, false);
            retValue = false;
            System.out.println((String)output);
            e.printStackTrace();
        }
        catch (ModuleCriticalException e) {
            output = this.addTab((String)output, " Failed", 70, false);
            retValue = false;
            System.out.println((String)output);
            System.out.println("Critical exception:\n" + e.getCause().toString());
        }
        catch (ArchiveException e) {
            output = this.addTab((String)output, " Failed", 70, false);
            retValue = false;
            System.out.println((String)output);
            e.printStackTrace();
        }
        if (!retValue) {
            errorString = errorString + "\n" + (String)output;
        }
        return retValue;
    }

    public void load(String inpaths, boolean update) {
        String[] paths = inpaths.split(":");
        for (int i = 0; i < paths.length; ++i) {
            File path = new File(paths[i]);
            if (path.exists()) {
                if (path.isDirectory()) {
                    System.out.println("Loading .xsd files from: " + paths[i]);
                    SuffixFilter filter = new SuffixFilter("xsd");
                    File[] files = path.listFiles(filter);
                    for (int x = 0; x < files.length; ++x) {
                        allFine = this.addSchema(files[x], update) && allFine;
                    }
                    continue;
                }
                System.out.println("Loading: " + paths[i]);
                this.addSchema(path, update);
                continue;
            }
            System.out.println("ERROR: " + paths[i] + " could not be found");
        }
    }

    public void loadIntList(String inpaths, boolean update) {
        String[] paths = inpaths.split(":");
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i] + "/idl";
            this.load(path, update);
        }
    }

    public void clear() throws DatabaseException, MalformedURIException, ModuleCriticalException, ArchiveException {
        this.smanager.removeAll();
    }

    public void close() throws ArchiveException {
        this.imanager.close();
        this.smanager.close();
        this.internal.close();
    }

    public static void main(String[] args) throws Exception {
        allFine = true;
        errorString = new String();
        if (args.length < 1) {
            System.out.println("Usage: archiveLoadSchema -[cul] paths");
            System.out.println("                           c Clear all schema");
            System.out.println("                           u Update");
            System.out.println("                           l Load from an INTLIST");
        } else {
            SchemaLoader sl = new SchemaLoader();
            if (args[0].startsWith("-")) {
                if (args[0].indexOf("c") != -1) {
                    sl.clear();
                }
                boolean update = false;
                if (args[0].indexOf("u") != -1) {
                    update = true;
                }
                if (args[0].indexOf("l") != -1) {
                    for (x = 1; x < args.length; ++x) {
                        sl.loadIntList(args[x], update);
                    }
                } else {
                    for (x = 1; x < args.length; ++x) {
                        sl.load(args[x], update);
                    }
                }
            } else {
                for (int x = 0; x < args.length; ++x) {
                    sl.load(args[x], false);
                }
            }
            if (System.getProperty("ACS.manager") != null) {
                String managerLoc = System.getProperty("ACS.manager").trim();
                System.out.println("Archive SchemaLoader: Trying to inform ACS components using manager location: " + managerLoc);
                try {
                    SchemaLoader schemaLoader = sl;
                    Objects.requireNonNull(schemaLoader);
                    AcsClient client = schemaLoader.new AcsClient(m_logger, managerLoc, "ArchiveSchemaLoader");
                    if (client.informACScomponents()) {
                        System.out.println("Archive/ACS component informed.");
                    } else {
                        System.out.println("No Archive components informed about new schemas.");
                    }
                    client.tearDown();
                }
                catch (Exception e) {
                    System.out.println("ACS not running or not available. No Archive components informed about new schemas.");
                }
            } else {
                System.out.println("Archive SchemaLoader: Running in standalone mode.");
            }
            if (!allFine) {
                System.out.println("WARNING! The following errors occurred (summary of errors mentioned above): ");
                System.out.println(errorString);
            } else {
                System.out.println("SUMMARY: All schemas loaded without errors.");
            }
            sl.close();
        }
    }

    private class SuffixFilter
    implements FileFilter {
        private String suffix;

        public SuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            return name.endsWith(this.suffix);
        }
    }

    private class AcsClient
    extends ComponentClient {
        private String connName;

        public AcsClient(Logger logger, String managerLoc, String clientName) throws Exception {
            super(logger, managerLoc, clientName);
            this.connName = "ARCHIVE_CONNECTION";
        }

        public boolean informACScomponents() {
            Administrative admin;
            ArchiveConnection conn = null;
            try {
                conn = ArchiveConnectionHelper.narrow((Object)this.getContainerServices().getComponent(this.connName));
            }
            catch (AcsJContainerServicesEx e) {
                this.m_logger.log(Level.WARNING, "Failed to connect to archive components. If any are running, they will not know about new schemas, better restart them.");
                return false;
            }
            try {
                admin = conn.getAdministrative("ArchiveSchemaLoader");
            }
            catch (Exception e) {
                this.m_logger.log(Level.SEVERE, "Failed to connect to 'administrative' archive component. Restart ACS to propagate the schema change.");
                return false;
            }
            try {
                admin.reinit("almabtrieb");
            }
            catch (ArchiveInternalError e1) {
                this.m_logger.log(Level.SEVERE, "Failed to reinitialize the 'administrative' archive component.");
                return false;
            }
            return true;
        }
    }
}

