/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.binding.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.builder.binding.xml.EnumClassName;
import org.exolab.castor.builder.binding.xml.EnumMember;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class EnumBindingType
implements Serializable {
    private EnumClassName _enumClassName;
    private List _enumMemberList = new ArrayList();

    public void addEnumMember(EnumMember vEnumMember) throws IndexOutOfBoundsException {
        this._enumMemberList.add(vEnumMember);
    }

    public void addEnumMember(int index, EnumMember vEnumMember) throws IndexOutOfBoundsException {
        this._enumMemberList.add(index, vEnumMember);
    }

    public Enumeration enumerateEnumMember() {
        return Collections.enumeration(this._enumMemberList);
    }

    public EnumClassName getEnumClassName() {
        return this._enumClassName;
    }

    public EnumMember getEnumMember(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._enumMemberList.size()) {
            throw new IndexOutOfBoundsException("getEnumMember: Index value '" + index + "' not in range [0.." + (this._enumMemberList.size() - 1) + "]");
        }
        return (EnumMember)this._enumMemberList.get(index);
    }

    public EnumMember[] getEnumMember() {
        EnumMember[] array = new EnumMember[]{};
        return this._enumMemberList.toArray(array);
    }

    public int getEnumMemberCount() {
        return this._enumMemberList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateEnumMember() {
        return this._enumMemberList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, handler);
    }

    public void removeAllEnumMember() {
        this._enumMemberList.clear();
    }

    public boolean removeEnumMember(EnumMember vEnumMember) {
        boolean removed = this._enumMemberList.remove(vEnumMember);
        return removed;
    }

    public EnumMember removeEnumMemberAt(int index) {
        Object obj = this._enumMemberList.remove(index);
        return (EnumMember)obj;
    }

    public void setEnumClassName(EnumClassName enumClassName) {
        this._enumClassName = enumClassName;
    }

    public void setEnumMember(int index, EnumMember vEnumMember) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._enumMemberList.size()) {
            throw new IndexOutOfBoundsException("setEnumMember: Index value '" + index + "' not in range [0.." + (this._enumMemberList.size() - 1) + "]");
        }
        this._enumMemberList.set(index, vEnumMember);
    }

    public void setEnumMember(EnumMember[] vEnumMemberArray) {
        this._enumMemberList.clear();
        for (int i = 0; i < vEnumMemberArray.length; ++i) {
            this._enumMemberList.add(vEnumMemberArray[i]);
        }
    }

    public static EnumBindingType unmarshalEnumBindingType(Reader reader) throws MarshalException, ValidationException {
        return (EnumBindingType)Unmarshaller.unmarshal(EnumBindingType.class, reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate(this);
    }
}

