/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.descriptors;

import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.SGTypes;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JPrimitiveType;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class DescriptorJClass
extends JClass {
    private static final String XMLCLASS_DESCRIPTOR_IMPL = "org.exolab.castor.xml.util.XMLClassDescriptorImpl";
    private static final String MAPPING_ACCESS_MODE = "org.exolab.castor.mapping.AccessMode";
    private static final JClass FIELD_DESCRIPTOR_CLASS = new JClass("org.exolab.castor.mapping.FieldDescriptor");
    private static final JClass XML_FIELD_DESCRIPTOR_CLASS = new JClass("org.exolab.castor.xml.XMLFieldDescriptor");
    private static final JType TYPE_VALIDATOR_CLASS = new JClass("org.exolab.castor.xml.TypeValidator");
    private final JClass _type;
    private final BuilderConfiguration _config;

    public DescriptorJClass(BuilderConfiguration config, String className, JClass type) {
        super(className);
        this._config = config;
        this._type = type;
        this.init();
    }

    private void init() {
        String superClass = null;
        if (this._config != null) {
            superClass = this._config.getProperty("org.exolab.castor.builder.superclass", null);
        }
        boolean extended = false;
        if (this._type.getSuperClassQualifiedName() == null || this._type.getSuperClassQualifiedName().equals(superClass)) {
            this.setSuperClass(XMLCLASS_DESCRIPTOR_IMPL);
        } else if (this._type.getSuperClass() == null) {
            this.setSuperClass(null);
        } else {
            extended = true;
            this.setSuperClass(this.getSuperClassName());
        }
        superClass = null;
        if (this._type.getPackageName() != null && this._type.getPackageName().length() > 0) {
            this.addImport(this._type.getName());
        }
        this.addField(new JField(JType.BOOLEAN, "_elementDefinition"));
        this.addField(new JField(SGTypes.STRING, "_nsPrefix"));
        this.addField(new JField(SGTypes.STRING, "_nsURI"));
        this.addField(new JField(SGTypes.STRING, "_xmlName"));
        this.addField(new JField(XML_FIELD_DESCRIPTOR_CLASS, "_identity"));
        this.addDefaultConstructor(extended);
        this.addXMLClassDescriptorImplOverrides();
        this.addXMLClassDescriptorOverrides();
        this.addClassDescriptorOverrides(extended);
    }

    private String getSuperClassName() {
        String superClassName = this._type.getSuperClass().getPackageName() == null || this._type.getSuperClass().getPackageName().equals("") ? (this.getPackageName() == null ? this._type.getSuperClass().getLocalName() + "Descriptor" : this.getPackageName() + "." + this._type.getSuperClass().getLocalName() + "Descriptor") : this._type.getSuperClass().getPackageName() + ".descriptors." + this._type.getSuperClass().getLocalName() + "Descriptor";
        return superClassName;
    }

    private void addDefaultConstructor(boolean extended) {
        this.addConstructor(this.createConstructor());
        JConstructor cons = this.getConstructor(0);
        JSourceCode jsc = cons.getSourceCode();
        jsc.add("super();");
        if (extended) {
            jsc.add("setExtendsWithoutFlatten(");
            jsc.append("new ");
            jsc.append(this.getSuperClassQualifiedName());
            jsc.append("());");
        }
    }

    private void addXMLClassDescriptorImplOverrides() {
        JMethod getElementDefinition = new JMethod("isElementDefinition", JType.BOOLEAN, "true if XML schema definition of this Class is that of a global\nelement or element with anonymous type definition.");
        JSourceCode jsc = getElementDefinition.getSourceCode();
        jsc.add("return _elementDefinition;");
        this.addMethod(getElementDefinition);
    }

    private void addXMLClassDescriptorOverrides() {
        JMethod method = new JMethod("getNameSpacePrefix", SGTypes.STRING, "the namespace prefix to use when marshaling as XML.");
        if (this._config.useJava50()) {
            method.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        JSourceCode jsc = method.getSourceCode();
        jsc.add("return _nsPrefix;");
        this.addMethod(method);
        method = new JMethod("getNameSpaceURI", SGTypes.STRING, "the namespace URI used when marshaling and unmarshaling as XML.");
        if (this._config.useJava50()) {
            method.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = method.getSourceCode();
        jsc.add("return _nsURI;");
        this.addMethod(method);
        method = new JMethod("getValidator", TYPE_VALIDATOR_CLASS, "a specific validator for the class described by this ClassDescriptor.");
        if (this._config.useJava50()) {
            method.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = method.getSourceCode();
        jsc.add("return this;");
        this.addMethod(method);
        method = new JMethod("getXMLName", SGTypes.STRING, "the XML Name for the Class being described.");
        if (this._config.useJava50()) {
            method.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = method.getSourceCode();
        jsc.add("return _xmlName;");
        this.addMethod(method);
    }

    private void addClassDescriptorOverrides(boolean extended) {
        JClass amClass = new JClass(MAPPING_ACCESS_MODE);
        JMethod getAccessMode = new JMethod("getAccessMode", amClass, "the access mode specified for this class.");
        if (this._config.useJava50()) {
            getAccessMode.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        JSourceCode jsc = getAccessMode.getSourceCode();
        jsc.add("return null;");
        this.addMethod(getAccessMode);
        JMethod getIdentity = new JMethod("getIdentity", FIELD_DESCRIPTOR_CLASS, "the identity field, null if this class has no identity.");
        if (this._config.useJava50()) {
            getIdentity.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = getIdentity.getSourceCode();
        if (extended) {
            jsc.add("if (_identity == null) {");
            jsc.indent();
            jsc.add("return super.getIdentity();");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add("return _identity;");
        this.addMethod(getIdentity, false);
        JMethod getJavaClass = new JMethod("getJavaClass", SGTypes.CLASS, "the Java class represented by this descriptor.");
        if (this._config.useJava50()) {
            getJavaClass.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = getJavaClass.getSourceCode();
        jsc.add("return ");
        jsc.append(DescriptorJClass.classType(this._type));
        jsc.append(";");
        this.addMethod(getJavaClass, false);
    }

    private static String classType(JType jType) {
        if (jType.isPrimitive()) {
            JPrimitiveType primitive = (JPrimitiveType)jType;
            return primitive.getWrapperName() + ".TYPE";
        }
        return jType.toString() + ".class";
    }
}

