/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;

public class RedefineSchema
extends Annotated {
    private static final long serialVersionUID = -7095458840388436859L;
    private Schema _originalSchema;
    private Schema _parentSchema;
    private String _schemaLocation = null;
    private Map<String, ComplexType> _complexTypes;
    private Map<String, SimpleType> _simpleTypes;
    private Map<String, ModelGroup> _groups;
    private Map<String, AttributeGroup> _attributeGroups;

    public RedefineSchema(Schema parentSchema) {
        this._parentSchema = parentSchema;
        this._schemaLocation = "";
    }

    public RedefineSchema(Schema parentSchema, Schema originalSchema) {
        this._schemaLocation = originalSchema.getSchemaLocation();
        this._parentSchema = parentSchema;
        this._originalSchema = originalSchema;
        this._complexTypes = new Hashtable<String, ComplexType>();
        this._simpleTypes = new Hashtable<String, SimpleType>();
        this._attributeGroups = new Hashtable<String, AttributeGroup>();
        this._groups = new Hashtable<String, ModelGroup>();
    }

    public void addComplexType(ComplexType complexType) throws SchemaException {
        if (this._schemaLocation.length() == 0) {
            throw new IllegalStateException("A RedefineSchema with no schemaLocation must contain only annotations");
        }
        String name = complexType.getName();
        if (name == null) {
            String err = "a global ComplexType must contain a name.";
            throw new SchemaException(err);
        }
        if (complexType.getSchema() != this._parentSchema) {
            Object err = "invalid attempt to add an ComplexType which ";
            err = (String)err + "belongs to a different Schema; type name: " + name;
            throw new SchemaException((String)err);
        }
        if (this.getComplexType(name) != null) {
            String err = "In the RedefineSchema:" + this._schemaLocation + "a ComplexType already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        complexType.setRedefined();
        this._complexTypes.put(name, complexType);
        complexType.setParent(this._parentSchema);
    }

    public Collection<ComplexType> enumerateComplexTypes() {
        if (this._schemaLocation.length() == 0) {
            return Collections.emptyList();
        }
        return this._complexTypes.values();
    }

    public ComplexType getComplexType(String name) {
        if (this._schemaLocation.length() == 0) {
            return null;
        }
        return this._complexTypes.get(name);
    }

    public boolean hasComplexTypeRedefinition(String name) {
        if (this._schemaLocation.length() == 0) {
            return false;
        }
        return this._complexTypes.containsKey(name);
    }

    public boolean removeComplexType(ComplexType complexType) {
        if (this._schemaLocation.length() == 0) {
            return false;
        }
        boolean result = false;
        if (this._complexTypes.containsValue(complexType)) {
            this._complexTypes.remove(complexType);
            result = true;
        }
        return result;
    }

    public void addSimpleType(SimpleType simpleType) throws SchemaException {
        String name = simpleType.getName();
        if (name == null) {
            throw new IllegalArgumentException("A redefined simpleType must have a name");
        }
        if (this._schemaLocation.length() == 0) {
            throw new IllegalStateException("A RedefineSchema with no schemaLocation must contain only annotations");
        }
        if (simpleType.getSchema() != this._parentSchema) {
            Object err = "invalid attempt to add a SimpleType which ";
            err = (String)err + "belongs to a different Schema; type name: " + name;
            throw new SchemaException((String)err);
        }
        if (this.getSimpleType(name) != null) {
            String err = "In the RedefineSchema:" + this._schemaLocation + "a SimpleType already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        simpleType.setRedefined();
        simpleType.setParent(this);
        this._simpleTypes.put(name, simpleType);
    }

    public Collection<SimpleType> enumerateSimpleTypes() {
        if (this._schemaLocation.length() == 0) {
            return Collections.emptyList();
        }
        return this._simpleTypes.values();
    }

    public SimpleType getSimpleType(String name) {
        if (this._schemaLocation.length() == 0) {
            return null;
        }
        return this._simpleTypes.get(name);
    }

    public boolean hasSimpleTypeRedefinition(String name) {
        if (this._schemaLocation.length() == 0) {
            return false;
        }
        return this._simpleTypes.containsKey(name);
    }

    public boolean removeSimpleType(SimpleType simpleType) {
        if (this._schemaLocation.length() == 0) {
            return false;
        }
        boolean result = false;
        if (this._simpleTypes.containsValue(simpleType)) {
            this._simpleTypes.remove(simpleType);
            result = true;
        }
        return result;
    }

    public void addGroup(ModelGroup group) throws SchemaException {
        if (this._schemaLocation.length() == 0) {
            throw new IllegalStateException("A RedefineSchema with no schemaLocation must contain only annotations");
        }
        String name = group.getName();
        if (name == null) {
            String err = "a group declaration must contain a name.";
            throw new SchemaException(err);
        }
        if (this.getModelGroup(name) != null) {
            String err = "In the RedefineSchema:" + this._schemaLocation + " a group declaration already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        group.setRedefined();
        group.setParent(this._parentSchema);
        this._groups.put(name, group);
    }

    public ModelGroup getModelGroup(String name) {
        if (this._schemaLocation.length() == 0) {
            return null;
        }
        return this._groups.get(name);
    }

    public Collection<ModelGroup> enumerateGroups() {
        if (this._schemaLocation.length() == 0) {
            return Collections.emptyList();
        }
        return this._groups.values();
    }

    public boolean hasGroupRedefinition(String name) {
        if (this._schemaLocation.length() == 0) {
            return false;
        }
        return this._groups.containsKey(name);
    }

    public boolean removeGroup(ModelGroup group) {
        if (this._schemaLocation.length() == 0) {
            return false;
        }
        boolean result = false;
        if (this._groups.containsValue(group)) {
            this._groups.remove(group);
            result = true;
        }
        return result;
    }

    public void addAttributeGroup(AttributeGroupDecl attrGroup) throws SchemaException {
        if (this._schemaLocation.length() == 0) {
            throw new IllegalStateException("A RedefineSchema with no schemaLocation must contain only annotations");
        }
        if (attrGroup == null) {
            return;
        }
        String name = attrGroup.getName();
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String nsPrefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            String ns = this._parentSchema.getNamespace(nsPrefix);
            if (ns == null) {
                Object err = "addAttributeGroup: ";
                err = (String)err + "Namespace prefix not recognized '" + nsPrefix + "'";
                throw new IllegalArgumentException((String)err);
            }
            if (!ns.equals(this._parentSchema.getTargetNamespace())) {
                String err = "AttributeGroup has different namespace than this Schema definition.";
                throw new IllegalArgumentException(err);
            }
        }
        if (attrGroup.getSchema() != this._parentSchema) {
            Object err = "invalid attempt to add an AttributeGroup which ";
            err = (String)err + "belongs to a different Schema; " + name;
            throw new SchemaException((String)err);
        }
        attrGroup.setRedefined();
        this._attributeGroups.put(name, attrGroup);
    }

    public AttributeGroupDecl getAttributeGroup(String name) {
        if (this._schemaLocation.length() == 0) {
            return null;
        }
        return (AttributeGroupDecl)this._attributeGroups.get(name);
    }

    public Collection<AttributeGroup> enumerateAttributeGroups() {
        if (this._schemaLocation.length() == 0) {
            return Collections.emptyList();
        }
        return this._attributeGroups.values();
    }

    public boolean hasAttributeGroupRedefinition(String name) {
        if (this._schemaLocation.length() == 0) {
            return false;
        }
        return this._attributeGroups.containsKey(name);
    }

    public boolean removeAttributeGroup(AttributeGroupDecl attrGroup) {
        if (this._schemaLocation.length() == 0) {
            return false;
        }
        boolean result = false;
        if (this._attributeGroups.containsValue(attrGroup)) {
            this._attributeGroups.remove(attrGroup);
            result = true;
        }
        return result;
    }

    public boolean hasRedefinition() {
        if (this._schemaLocation.length() == 0) {
            return false;
        }
        return !this._complexTypes.isEmpty() || !this._simpleTypes.isEmpty() || !this._groups.isEmpty() || !this._attributeGroups.isEmpty();
    }

    public String getSchemaLocation() {
        return this._schemaLocation;
    }

    public Schema getOriginalSchema() {
        return this._originalSchema;
    }

    public Schema getParentSchema() {
        return this._parentSchema;
    }

    @Override
    public short getStructureType() {
        return 18;
    }

    @Override
    public void validate() throws ValidationException {
    }
}

