/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.NamespacesStack;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.util.AttributeSetImpl;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Sax2ComponentReader
implements DocumentHandler,
ErrorHandler {
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String XML_PREFIX = "xml";
    private ComponentReader componentReader = null;
    private NamespacesStack namespacesStack = null;

    public Sax2ComponentReader(ComponentReader compReader) {
        this.componentReader = compReader;
        this.namespacesStack = new NamespacesStack();
    }

    private AttributeSet processAttributeList(AttributeList atts) throws SAXException {
        if (atts == null) {
            return new AttributeSetImpl(0);
        }
        int attCount = 0;
        boolean[] validAtts = new boolean[atts.getLength()];
        for (int i = 0; i < validAtts.length; ++i) {
            String attName = atts.getName(i);
            if (attName.equals(XMLNS)) {
                this.namespacesStack.addNamespace("", atts.getValue(i));
                continue;
            }
            if (attName.startsWith(XMLNS_PREFIX)) {
                String prefix = attName.substring(XMLNS_PREFIX.length());
                this.namespacesStack.addNamespace(prefix, atts.getValue(i));
                continue;
            }
            validAtts[i] = true;
            ++attCount;
        }
        AttributeSetImpl attSet = null;
        if (attCount > 0) {
            attSet = new AttributeSetImpl(attCount);
            for (int i = 0; i < validAtts.length; ++i) {
                String prefix;
                if (!validAtts[i]) continue;
                String namespace = null;
                String attName = atts.getName(i);
                int idx = attName.indexOf(58);
                if (idx > 0 && !(prefix = attName.substring(0, idx)).equals(XML_PREFIX)) {
                    attName = attName.substring(idx + 1);
                    namespace = this.namespacesStack.getNamespaceURI(prefix);
                    if (namespace == null) {
                        String error = "The namespace associated with the prefix '" + prefix + "' could not be resolved.";
                        throw new SAXException(error);
                    }
                }
                attSet.setAttribute(attName, atts.getValue(i), namespace);
            }
        } else {
            attSet = new AttributeSetImpl(0);
        }
        return attSet;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.componentReader.characters(ch, start, length);
        }
        catch (XMLException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String name) throws SAXException {
        String namespace = null;
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String prefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            namespace = this.namespacesStack.getNamespaceURI(prefix);
        } else {
            namespace = this.namespacesStack.getDefaultNamespaceURI();
        }
        this.namespacesStack.removeNamespaceScope();
        try {
            this.componentReader.endElement(name, namespace);
        }
        catch (XMLException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.componentReader.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String name, AttributeList atts) throws SAXException {
        this.namespacesStack.addNewNamespaceScope();
        AttributeSet attSet = this.processAttributeList(atts);
        String namespace = null;
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String prefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            namespace = this.namespacesStack.getNamespaceURI(prefix);
        } else {
            namespace = this.namespacesStack.getNamespaceURI("");
        }
        try {
            this.componentReader.startElement(name, namespace, attSet, this.namespacesStack.getCurrentNamespaceScope());
        }
        catch (XMLException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        String systemId = exception.getSystemId();
        String err = "Parsing Error : " + exception.getMessage() + "\nLine : " + exception.getLineNumber() + "\nColumn : " + exception.getColumnNumber() + "\n";
        if (systemId != null) {
            err = "In document: '" + systemId + "'\n" + err;
        }
        throw new SAXException(err);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        String systemId = exception.getSystemId();
        String err = "Parsing Error : " + exception.getMessage() + "\nLine : " + exception.getLineNumber() + "\nColumn : " + exception.getColumnNumber() + "\n";
        if (systemId != null) {
            err = "In document: '" + systemId + "'\n" + err;
        }
        throw new SAXException(err);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        String systemId = exception.getSystemId();
        String err = "Parsing Error : " + exception.getMessage() + "\nLine : " + exception.getLineNumber() + "\nColumn : " + exception.getColumnNumber() + "\n";
        if (systemId != null) {
            err = "In document: '" + systemId + "'\n" + err;
        }
        throw new SAXException(err);
    }
}

