/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.DispatchingLogQueue;
import alma.acs.logging.LogParameterUtil;
import alma.acs.logging.LogThrottle;
import alma.acs.logging.config.LogConfig;
import alma.acs.logging.config.LogConfigSubscriber;
import alma.acs.logging.level.AcsLogLevelDefinition;
import alma.acs.util.StopWatch;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class AcsLoggingHandler
extends Handler
implements LogConfigSubscriber {
    private DispatchingLogQueue logQueue;
    private static boolean DEBUG = Boolean.getBoolean("alma.acs.logging.verbose");
    private final boolean PROFILE = Boolean.getBoolean("alma.acs.logging.profile.local");
    private LogConfig logConfig;
    private final String loggerName;
    private final LogThrottle logThrottle;
    private AcsLogLevelDefinition immediateDispatchLevel;
    private boolean isClosed;

    public AcsLoggingHandler(DispatchingLogQueue logQueue, LogConfig logConfig, String loggerName, LogThrottle logThrottle) {
        this.logQueue = logQueue;
        this.logConfig = logConfig;
        this.loggerName = loggerName;
        this.logThrottle = logThrottle;
        this.configureLogging(logConfig);
        logConfig.addSubscriber(this);
    }

    @Override
    public void configureLogging(LogConfig logConfig) {
        this.logConfig = logConfig;
        try {
            AcsLogLevelDefinition minLogLevelACS = AcsLogLevelDefinition.fromXsdLogLevel(logConfig.getNamedLoggerConfig(this.loggerName).getMinLogLevel());
            this.setLevel(AcsLogLevel.getLowestMatchingJdkLevel(minLogLevelACS));
            this.immediateDispatchLevel = logConfig.getImmediateDispatchLevel();
        }
        catch (Exception ex) {
            this.publish(new LogRecord(Level.WARNING, "Failed to configure remote log handler: " + ex.toString()));
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        LogParameterUtil logParamUtil;
        StopWatch sw_parent;
        if (this.isClosed) {
            if (DEBUG) {
                System.out.println("AcsLoggingHandler: ignoring record with msg='" + logRecord.getMessage() + "' because this logging handler is already closed.");
            }
            return;
        }
        if (!this.isLoggable(logRecord) || logRecord.getLevel().intValue() == Level.OFF.intValue()) {
            if (DEBUG) {
                System.out.println("AcsLoggingHandler: ignoring record with msg='" + logRecord.getMessage() + "' because isLoggable() was false.");
            }
            return;
        }
        StopWatch sw_local = null;
        if (this.PROFILE && (sw_parent = (logParamUtil = new LogParameterUtil(logRecord)).getStopWatch()) != null) {
            sw_local = sw_parent.createStopWatchForSubtask("AcsLoggingHandler");
        }
        if (this.logThrottle == null || this.logThrottle.checkPublishLogRecordRemote()) {
            logRecord.getSourceClassName();
            this.logQueue.log(logRecord);
            if (AcsLogLevel.getNativeLevel(logRecord.getLevel()).getAcsLevel().compareTo(this.immediateDispatchLevel) >= 0) {
                if (DEBUG) {
                    System.out.println("flushing log queue because of log record with level " + logRecord.getLevel().getName());
                }
                this.logQueue.flush();
            }
        }
        if (this.PROFILE && sw_local != null) {
            sw_local.stop();
        }
    }

    @Override
    public void flush() {
        this.logQueue.flush();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.logConfig.removeSubscriber(this);
    }

    protected static void debug() {
        DEBUG = true;
        System.out.println("AcsLoggingHandler#DEBUG set to true...");
    }
}

