/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging;

import alma.acs.util.StopWatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogRecord;

public class LogParameterUtil {
    public static final String IS_ACS_PROPERTIES_MAP_KEYNAME = "isAcsPropertiesMap";
    public static final String PARAM_THREAD_NAME = "ThreadName";
    public static final String PARAM_LINE = "Line";
    public static final String PARAM_HOSTNAME = "HostName";
    public static final String PARAM_STACK_ID = "StackId";
    public static final String PARAM_STACK_LEVEL = "StackLevel";
    public static final String PARAM_PRIORITY = "Priority";
    public static final String PARAM_URI = "Uri";
    public static final String PARAM_PROCESSNAME = "ProcessName";
    public static final String PARAM_SOURCEOBJECT = "SourceObject";
    private static final String PARAM_STOPWATCH = "StopWatch";
    private LogRecord currentLogRecord;
    private Map<String, Object> specialProperties;
    private List<Object> otherParameters;

    public LogParameterUtil(LogRecord currentLogRecord) {
        this.setCurrentLogRecord(currentLogRecord);
    }

    public static Map<String, Object> createPropertiesMap() {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put(IS_ACS_PROPERTIES_MAP_KEYNAME, Boolean.TRUE);
        return propMap;
    }

    Map<String, Object> extractSpecialPropertiesMap() {
        if (this.specialProperties != null) {
            return this.specialProperties;
        }
        Map propMap = null;
        Object[] parameters = this.currentLogRecord.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (!(parameters[i] instanceof Map) || !((Map)parameters[i]).containsKey(IS_ACS_PROPERTIES_MAP_KEYNAME) || propMap != null) continue;
                propMap = (Map)parameters[i];
            }
        }
        return propMap;
    }

    public void setCurrentLogRecord(LogRecord logRecord) {
        if (this.currentLogRecord == logRecord) {
            return;
        }
        this.currentLogRecord = logRecord;
        this.specialProperties = this.extractSpecialPropertiesMap();
        this.otherParameters = new ArrayList<Object>();
        if (this.currentLogRecord.getParameters() != null) {
            this.otherParameters.addAll(Arrays.asList(this.currentLogRecord.getParameters()));
            if (this.specialProperties != null) {
                this.otherParameters.remove(this.specialProperties);
            }
        }
    }

    public List<Object> getNonSpecialPropertiesMapParameters() {
        return this.otherParameters;
    }

    public long extractLongProperty(String name, long defaultValue) {
        Object lv;
        long retVal = defaultValue;
        if (this.specialProperties != null && (lv = this.specialProperties.get(name)) != null && lv instanceof Long) {
            retVal = (Long)lv;
        }
        return retVal;
    }

    public String extractStringProperty(String name, String defaultValue) {
        Object sv;
        String retVal = defaultValue;
        if (this.specialProperties != null && (sv = this.specialProperties.get(name)) != null) {
            retVal = sv.toString();
        }
        return retVal;
    }

    void setStopWatch(StopWatch sw) {
        if (this.specialProperties != null) {
            this.specialProperties.put(PARAM_STOPWATCH, sw);
        }
    }

    StopWatch getStopWatch() {
        StopWatch ret = null;
        if (this.specialProperties != null) {
            ret = (StopWatch)this.specialProperties.get(PARAM_STOPWATCH);
        }
        return ret;
    }
}

