/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.statistics;

import java.util.List;

public class AcsLoggerStatistics {
    private Boolean disableStatistics = true;
    private String statisticsIdentification = "Undefined";
    private int accumulatedNumberOfMessages = 0;
    private int accumulatedNumberOfLogErrors = 0;
    private long lastStatisticsRepportTime = System.currentTimeMillis();
    private int statisticsCalculationPeriod = 600;
    private int statisticsGranularity = 1;
    private int lastPeriodNumberOfMessages = 0;
    private int lastPeriodNumberOfLogErrors = 0;
    private float messageStatistics;
    private float errorStatistics;
    private float messageIncrement;
    private float errorIncrement;
    private float actualStatisticsPeriod;
    public static final int INITIAL_NUMBER_MESSAGES = 0;
    public static final int INITIAL_NUMBER_ERRORS = 0;
    public static final int DEFAULT_STATISTICS_PERIOD = 600;
    public static final int DEFAULT_STATISTICS_GRANULARITY = 1;
    public static final boolean DEFAULT_STATISTICS_STATE = true;

    public AcsLoggerStatistics() {
        if (System.getenv("LOCATION") != null) {
            this.disableStatistics = false;
            this.statisticsGranularity = 3;
        }
    }

    public void calculateLoggingStatistics() {
        this.actualStatisticsPeriod = (float)(System.currentTimeMillis() - this.getLastStatisticsRepportTime()) / 1000.0f;
        this.messageStatistics = (float)(this.getAccumulatedNumberOfMessages() * this.getStatisticsGranularity()) / this.actualStatisticsPeriod;
        this.errorStatistics = (float)(this.getAccumulatedNumberOfLogErrors() * this.getStatisticsGranularity()) / this.actualStatisticsPeriod;
        this.messageIncrement = (float)(this.getAccumulatedNumberOfMessages() - this.getLastPeriodNumberOfMessages()) * (100.0f / (float)this.getLastPeriodNumberOfMessages());
        this.errorIncrement = (float)(this.getAccumulatedNumberOfLogErrors() - this.getLastPeriodNumberOfLogErrors()) * (100.0f / (float)this.getLastPeriodNumberOfLogErrors());
    }

    public void retrieveStatisticsLogs(List<String> statisticsLogList, String loggerId) {
        statisticsLogList.clear();
        statisticsLogList.add("-------- Logging Statistics for: " + this.statisticsIdentification + "." + loggerId);
        statisticsLogList.add("Total logging messages during last period: " + this.getLastPeriodNumberOfMessages());
        statisticsLogList.add("Number of messages per " + this.getStatisticsGranularity() + " second(s) during last " + this.actualStatisticsPeriod + " seconds = " + this.messageStatistics);
        statisticsLogList.add("Increment of messages from last period: " + this.messageIncrement + "%");
        statisticsLogList.add("Total logging errors during last period: " + this.getLastPeriodNumberOfLogErrors());
        statisticsLogList.add("Number of errors per " + this.getStatisticsGranularity() + " second(s) during last " + this.actualStatisticsPeriod + " seconds = " + this.errorStatistics);
        statisticsLogList.add("Increment of logging errors from last period: " + this.errorIncrement + "%");
        statisticsLogList.add("---------------------------------------------------------------------------------");
    }

    public void incrementNumberOfMessages() {
        this.setAccumulatedNumberOfMessages(this.getAccumulatedNumberOfMessages() + 1);
    }

    public void incrementNumberOfLogErrors() {
        this.setAccumulatedNumberOfLogErrors(this.getAccumulatedNumberOfLogErrors() + 1);
    }

    public void resetStatistics() {
        this.setLastPeriodNumberOfMessages(this.getAccumulatedNumberOfMessages());
        this.setLastPeriodNumberOfLogErrors(this.getAccumulatedNumberOfLogErrors());
        this.setAccumulatedNumberOfMessages(0);
        this.setAccumulatedNumberOfLogErrors(0);
        this.setLastStatisticsRepportTime(System.currentTimeMillis());
    }

    public void configureStatistics(String elementName, boolean state, int period, int granularity) {
        this.setStatisticsIdentification(elementName);
        this.resetStatistics();
        this.setDisableStatistics(state);
        if (period > 0) {
            this.setStatisticsCalculationPeriod(period);
        } else {
            this.setStatisticsCalculationPeriod(1);
        }
        if (granularity > 0) {
            this.setStatisticsGranularity(granularity);
        } else {
            this.setStatisticsGranularity(1);
        }
    }

    public Boolean getDisableStatistics() {
        return this.disableStatistics;
    }

    public String getStatisticsIdentification() {
        return this.statisticsIdentification;
    }

    public int getAccumulatedNumberOfMessages() {
        return this.accumulatedNumberOfMessages;
    }

    public int getAccumulatedNumberOfLogErrors() {
        return this.accumulatedNumberOfLogErrors;
    }

    public long getLastStatisticsRepportTime() {
        return this.lastStatisticsRepportTime;
    }

    public int getStatisticsCalculationPeriod() {
        return this.statisticsCalculationPeriod;
    }

    public int getStatisticsGranularity() {
        return this.statisticsGranularity;
    }

    public int getLastPeriodNumberOfMessages() {
        return this.lastPeriodNumberOfMessages;
    }

    public int getLastPeriodNumberOfLogErrors() {
        return this.lastPeriodNumberOfLogErrors;
    }

    public float getMessageStatistics() {
        return this.messageStatistics;
    }

    public float getErrorStatistics() {
        return this.errorStatistics;
    }

    public float getMessageIncrement() {
        return this.messageIncrement;
    }

    public float getErrorIncrement() {
        return this.errorIncrement;
    }

    public float getActualStatisticsPeriod() {
        return this.actualStatisticsPeriod;
    }

    public void setDisableStatistics(Boolean disableStatistics) {
        this.disableStatistics = disableStatistics;
    }

    public void setStatisticsIdentification(String statisticsIdentification) {
        this.statisticsIdentification = statisticsIdentification;
    }

    public void setAccumulatedNumberOfMessages(int accumulatedNumberOfMessages) {
        this.accumulatedNumberOfMessages = accumulatedNumberOfMessages;
    }

    public void setAccumulatedNumberOfLogErrors(int accumulatedNumberOfLogErrors) {
        this.accumulatedNumberOfLogErrors = accumulatedNumberOfLogErrors;
    }

    public void setLastStatisticsRepportTime(long lastStatisticsRepportTime) {
        this.lastStatisticsRepportTime = lastStatisticsRepportTime;
    }

    public void setStatisticsCalculationPeriod(int statisticsCalculationPeriod) {
        this.statisticsCalculationPeriod = statisticsCalculationPeriod;
    }

    public void setStatisticsGranularity(int statisticsGranularity) {
        this.statisticsGranularity = statisticsGranularity;
    }

    public void setLastPeriodNumberOfMessages(int lastPeriodNumberOfMessages) {
        this.lastPeriodNumberOfMessages = lastPeriodNumberOfMessages;
    }

    public void setLastPeriodNumberOfLogErrors(int lastPeriodNumberOfLogErrors) {
        this.lastPeriodNumberOfLogErrors = lastPeriodNumberOfLogErrors;
    }

    public void setMessageStatistics(float messageStatistics) {
        this.messageStatistics = messageStatistics;
    }

    public void setErrorStatistics(float errorStatistics) {
        this.errorStatistics = errorStatistics;
    }

    public void setMessageIncrement(float messageIncrement) {
        this.messageIncrement = messageIncrement;
    }

    public void setErrorIncrement(float errorIncrement) {
        this.errorIncrement = errorIncrement;
    }

    public void setActualStatisticsPeriod(float actualStatisticsPeriod) {
        this.actualStatisticsPeriod = actualStatisticsPeriod;
    }
}

