/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import java.util.Collection;
import java.util.Collections;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.ETF.Profile;
import org.omg.ETF._ProfileLocalBase;
import org.omg.GIOP.Version;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.slf4j.Logger;

public abstract class ProfileBase
extends _ProfileLocalBase
implements Cloneable,
Configurable {
    protected Version version = null;
    protected byte[] objectKey = null;
    protected TaggedComponentList components = null;
    protected Configuration configuration;
    protected String corbalocStr = null;
    protected Logger logger;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new ConfigurationException("ProfileBase: given configuration was null");
        }
        this.configuration = configuration;
    }

    public void set_object_key(byte[] key) {
        this.objectKey = key;
    }

    public byte[] get_object_key() {
        return this.objectKey;
    }

    public Version version() {
        return this.version;
    }

    public abstract int tag();

    public void patchPrimaryAddress(ProtocolAddressBase replacement) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(TaggedProfileHolder tagged_profile, TaggedComponentSeqHolder componentSequence) {
        TaggedComponentSeqHolder compSeq = componentSequence;
        if (this.encapsulation() != 0) {
            throw new BAD_PARAM("We can only marshal big endian style profiles !!");
        }
        try (CDROutputStream profileDataStream = new CDROutputStream();){
            profileDataStream.beginEncapsulatedArray();
            this.writeAddressProfile(profileDataStream);
            profileDataStream.write_long(this.objectKey.length);
            profileDataStream.write_octet_array(this.objectKey, 0, this.objectKey.length);
            switch (this.version.minor) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    int i;
                    if (compSeq == null) {
                        compSeq = new TaggedComponentSeqHolder(new TaggedComponent[0]);
                    }
                    profileDataStream.write_long(this.components.size() + compSeq.value.length);
                    TaggedComponent[] ourTaggedProfiles = this.components.asArray();
                    for (i = 0; i < ourTaggedProfiles.length; ++i) {
                        TaggedComponentHelper.write((OutputStream)profileDataStream, (TaggedComponent)ourTaggedProfiles[i]);
                    }
                    for (i = 0; i < compSeq.value.length; ++i) {
                        TaggedComponentHelper.write((OutputStream)profileDataStream, (TaggedComponent)compSeq.value[i]);
                    }
                    break;
                }
                default: {
                    throw new INTERNAL("Unknown GIOP version tag " + this.version.minor + " when marshalling for IIOPProfile");
                }
            }
            tagged_profile.value = new TaggedProfile(this.tag(), profileDataStream.getBufferCopy());
        }
    }

    public void demarshal(TaggedProfileHolder tagged_profile, TaggedComponentSeqHolder components) {
        if (tagged_profile.value.tag != this.tag()) {
            throw new BAD_PARAM("Wrong tag for Transport, tag: " + tagged_profile.value.tag);
        }
        this.initFromProfileData(tagged_profile.value.profile_data);
        if (components != null) {
            components.value = this.getComponents().asArray();
        }
    }

    public short encapsulation() {
        return 0;
    }

    public abstract void writeAddressProfile(CDROutputStream var1);

    public abstract void readAddressProfile(CDRInputStream var1);

    public TaggedComponentList getComponents() {
        return this.components;
    }

    public Object getComponent(int tag, Class<?> helper) {
        return this.components.getComponent(tag, helper);
    }

    public void addComponent(int tag, Object data, Class<?> helper) {
        this.components.addComponent(tag, data, helper);
    }

    public void addComponent(int tag, byte[] data) {
        this.components.addComponent(tag, data);
    }

    public TaggedProfile asTaggedProfile() {
        TaggedProfileHolder result = new TaggedProfileHolder();
        this.marshal(result, null);
        return result.value;
    }

    public Profile copy() {
        try {
            return (Profile)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("error cloning profile: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFromProfileData(byte[] data) {
        try (CDRInputStream in = new CDRInputStream(data);){
            in.openEncapsulatedArray();
            this.readAddressProfile(in);
            int length = in.read_ulong();
            if (in.available() < length) {
                throw new MARSHAL("Unable to extract object key. Only " + in.available() + " available and trying to assign " + length);
            }
            this.objectKey = new byte[length];
            in.read_octet_array(this.objectKey, 0, length);
            this.components = this.version != null && this.version.minor > 0 ? new TaggedComponentList((InputStream)in) : new TaggedComponentList();
        }
    }

    public Collection<ListenPoint> asListenPoints() {
        return Collections.emptyList();
    }

    public void removeComponents(int tags) {
        if (this.components != null) {
            this.components.removeComponents(tags);
        }
    }
}

