/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.HashSet;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public abstract class RecursionAwareCI
extends LocalObject
implements ClientRequestInterceptor {
    private final HashSet<Thread> thread_stacks = new HashSet();
    private final HashSet<String> ignore_operations = new HashSet();

    public RecursionAwareCI(boolean ignore_special_ops) {
        if (ignore_special_ops) {
            this.ignore_operations.add("_is_a");
            this.ignore_operations.add("_get_interface");
            this.ignore_operations.add("_non_existent");
            this.ignore_operations.add("_get_policy");
            this.ignore_operations.add("_get_domain_managers");
            this.ignore_operations.add("_set_policy_overrides");
            this.ignore_operations.add("_get_component");
        }
    }

    private boolean enterCall(String operation) {
        if (this.ignore_operations.contains(operation)) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        if (this.thread_stacks.contains(currentThread)) {
            return false;
        }
        this.thread_stacks.add(currentThread);
        return true;
    }

    private void exitCall() {
        this.thread_stacks.remove(Thread.currentThread());
    }

    public final void send_request(ClientRequestInfo requestInfo) throws ForwardRequest {
        if (this.enterCall(requestInfo.operation())) {
            try {
                this.do_send_request(requestInfo);
            }
            finally {
                this.exitCall();
            }
        }
    }

    public final void send_poll(ClientRequestInfo requestInfo) {
        if (this.enterCall(requestInfo.operation())) {
            try {
                this.do_send_poll(requestInfo);
            }
            finally {
                this.exitCall();
            }
        }
    }

    public final void receive_reply(ClientRequestInfo ri) {
        if (this.enterCall(ri.operation())) {
            try {
                this.do_receive_reply(ri);
            }
            finally {
                this.exitCall();
            }
        }
    }

    public final void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        if (this.enterCall(ri.operation())) {
            try {
                this.do_receive_exception(ri);
            }
            finally {
                this.exitCall();
            }
        }
    }

    public final void receive_other(ClientRequestInfo ri) throws ForwardRequest {
        if (this.enterCall(ri.operation())) {
            try {
                this.do_receive_other(ri);
            }
            finally {
                this.exitCall();
            }
        }
    }

    public abstract void do_send_request(ClientRequestInfo var1) throws ForwardRequest;

    public abstract void do_send_poll(ClientRequestInfo var1);

    public abstract void do_receive_reply(ClientRequestInfo var1);

    public abstract void do_receive_exception(ClientRequestInfo var1) throws ForwardRequest;

    public abstract void do_receive_other(ClientRequestInfo var1) throws ForwardRequest;
}

