/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.awt.Component;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.ladypleaser.rmilite.Client;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.votech.plastic.PlasticHubListener;
import org.votech.plastic.PlasticListener;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.HubManager;
import uk.ac.starlink.plastic.NoHubException;
import uk.ac.starlink.plastic.PlasticApplication;
import uk.ac.starlink.plastic.PlasticConnection;
import uk.ac.starlink.plastic.PlasticHub;
import uk.ac.starlink.plastic.XmlRpcAgent;

public class PlasticUtils {
    public static final String PLASTIC_FILE = ".plastic";
    public static final String PLASTIC_VERSION = "0.4";
    public static final String XMLRPC_PREFIX = Double.parseDouble("0.4") > 0.399 ? null : "plastic.client";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.plastic");
    private static Icon sendIcon_;
    private static Icon broadcastIcon_;
    public static boolean WARN_ABOUT_NOSUCHELEMENTEXCEPTIONS;

    private PlasticUtils() {
    }

    public static PlasticHubListener getLocalHub() throws IOException {
        try {
            return (PlasticHubListener)PlasticUtils.getLocalClient().lookup(PlasticHubListener.class);
        }
        catch (NotBoundException e) {
            throw (IOException)new IOException("Error connecting to PLASTIC hub").initCause(e);
        }
        catch (SocketException e) {
            throw (IOException)new IOException("No connection to PLASTIC hub (not running?)").initCause(e);
        }
    }

    public static URL getXmlRpcUrl() throws IOException {
        return new URL(PlasticUtils.getPlasticProperty("plastic.xmlrpc.url"));
    }

    private static Client getLocalClient() throws IOException {
        Client localClient = new Client("localhost", PlasticUtils.getPlasticPort());
        localClient.exportInterface(PlasticListener.class);
        return localClient;
    }

    public static boolean isHubRunning() {
        try {
            PlasticUtils.getPlasticProperties();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPlasticProperties() throws IOException {
        File rvfile = new File(System.getProperty("user.home"), PLASTIC_FILE);
        if (rvfile.exists()) {
            Properties props = new Properties();
            BufferedInputStream propStream = new BufferedInputStream(new FileInputStream(rvfile));
            try {
                props.load(propStream);
            }
            finally {
                ((InputStream)propStream).close();
            }
            return props;
        }
        throw new NoHubException("No PLASTIC hub detected (no file ~/.plastic)");
    }

    public static String getPlasticProperty(String key) throws IOException {
        String value = PlasticUtils.getPlasticProperties().getProperty(key);
        if (value == null) {
            throw new IOException("No property " + key + " in file " + new File(System.getProperty("user.home"), PLASTIC_FILE));
        }
        return value;
    }

    private static int getPlasticPort() throws IOException {
        String sport = PlasticUtils.getPlasticProperty("plastic.rmi.port");
        try {
            return Integer.parseInt(sport);
        }
        catch (NumberFormatException e) {
            throw (IOException)new IOException("Bad .plastic file: plastic.rmi.port=" + sport).initCause(e);
        }
    }

    public static PlasticConnection registerRMI(final PlasticApplication app) throws IOException {
        final HubManager hubber = new HubManager(app.getName(), app.getSupportedMessages()){

            public Object doPerform(URI sender, URI message, List args) {
                return app.perform(sender, message, args);
            }
        };
        hubber.register();
        final URI id = hubber.getRegisteredId();
        return new PlasticConnection(){

            public URI getId() {
                return id;
            }

            public void unregister() {
                hubber.unregister();
            }
        };
    }

    public static PlasticConnection registerXMLRPC(final PlasticApplication app) throws IOException {
        WebServer server;
        final XmlRpcClient client = PlasticUtils.createXmlRpcClient(PlasticUtils.getXmlRpcUrl());
        int port = PlasticUtils.getUnusedPort(3112);
        try {
            server = new WebServer(port);
            server.start();
        }
        catch (RuntimeException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        URL serverUrl = new URL("http://" + InetAddress.getLocalHost().getCanonicalHostName() + ":" + port + "/");
        XmlRpcHandler handler = new XmlRpcHandler(){

            public Object execute(String method, Vector params) throws URISyntaxException {
                URI sender = new URI((String)params.get(0));
                URI message = new URI((String)params.get(1));
                List args = (List)params.get(2);
                return app.perform(sender, message, args);
            }
        };
        server.addHandler(XMLRPC_PREFIX == null ? "$default" : XMLRPC_PREFIX, (Object)handler);
        Vector<Object> argv = new Vector<Object>();
        argv.add(app.getName());
        argv.add(XmlRpcAgent.doctorObject(app.getSupportedMessages()));
        argv.add(XmlRpcAgent.doctorObject(serverUrl));
        try {
            Object result = client.execute("plastic.hub.registerXMLRPC", argv);
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)((Object)result);
            }
            if (result instanceof String) {
                final URI id = new URI((String)result);
                PlasticConnection conn = new PlasticConnection(){
                    private boolean unreg_;

                    public URI getId() {
                        return id;
                    }

                    public synchronized void unregister() {
                        if (!this.unreg_) {
                            this.unreg_ = true;
                            Vector<String> argv = new Vector<String>();
                            argv.add(id.toString());
                            try {
                                client.execute("plastic.hub.unregister", argv);
                            }
                            catch (Throwable e) {
                                logger_.info("Unregister failed: " + e);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void finalize() throws Throwable {
                        try {
                            this.unregister();
                        }
                        finally {
                            super.finalize();
                        }
                    }
                };
                final WeakReference<4> connRef = new WeakReference<4>(conn);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        PlasticConnection conn = (PlasticConnection)connRef.get();
                        if (conn != null) {
                            conn.unregister();
                        }
                    }
                });
                return conn;
            }
            return null;
        }
        catch (XmlRpcException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object targetRequest(String name, URI message, List args, URI target) throws IOException {
        URI id;
        PlasticHubListener hub = PlasticUtils.getLocalHub();
        try {
            id = hub.registerNoCallBack(name);
        }
        catch (Throwable e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        if (id == null) {
            throw new IOException("Can't connect to hub");
        }
        try {
            Object object = PlasticUtils.targetRequest(id, message, args, target);
            return object;
        }
        finally {
            hub.unregister(id);
        }
    }

    public static Object targetRequest(URI sender, URI message, List args, URI target) throws IOException {
        PlasticHubListener hub = PlasticUtils.getLocalHub();
        Map resultMap = hub.requestToSubset(sender, message, args, Collections.singletonList(target));
        return resultMap.get(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void singleRequestAsynch(String name, URI message, List args) throws IOException {
        PlasticHubListener hub = PlasticUtils.getLocalHub();
        URI id = null;
        try {
            id = hub.registerNoCallBack(name);
        }
        catch (Throwable e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        if (id == null) {
            throw new IOException("Can't connect to hub");
        }
        try {
            hub.requestAsynch(id, message, args);
        }
        finally {
            hub.unregister(id);
        }
    }

    public static void startExternalHub(boolean gui) throws IOException {
        File javaHome = new File(System.getProperty("java.home"));
        File javaExec = new File(new File(javaHome, "bin"), "java");
        String javacmd = javaExec.exists() && !javaExec.isDirectory() ? javaExec.toString() : "java";
        String[] args = new String[]{javacmd, "-classpath", System.getProperty("java.class.path"), PlasticHub.class.getName(), gui ? "-gui" : "-verbose"};
        StringBuffer cmdbuf = new StringBuffer();
        for (int iarg = 0; iarg < args.length; ++iarg) {
            if (iarg > 0) {
                cmdbuf.append(' ');
            }
            cmdbuf.append(args[iarg]);
        }
        logger_.info("Starting external hub");
        logger_.info(cmdbuf.toString());
        Runtime.getRuntime().exec(args);
    }

    public static void waitToRegister(HubManager hubMan, int interval) throws InterruptedException {
        while (!Thread.currentThread().isInterrupted()) {
            if (PlasticUtils.isHubRunning()) {
                try {
                    hubMan.register();
                    return;
                }
                catch (IOException e) {
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
            }
            Thread.sleep(interval);
        }
        throw new InterruptedException();
    }

    public static ApplicationItem[] getRegisteredApplications(PlasticHubListener hub) {
        List ids = hub.getRegisteredIds();
        ArrayList<ApplicationItem> apps = new ArrayList<ApplicationItem>();
        Iterator it = hub.getRegisteredIds().iterator();
        while (it.hasNext()) {
            String idString = it.next().toString();
            try {
                URI id = new URI(idString);
                String name = hub.getName(id);
                List msgs = hub.getUnderstoodMessages(id);
                apps.add(new ApplicationItem(id, name, msgs));
            }
            catch (URISyntaxException e) {}
        }
        return apps.toArray(new ApplicationItem[0]);
    }

    public static URI createURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Bad URI: " + uri).initCause(e);
        }
    }

    public static XmlRpcClient createXmlRpcClient(URL url) {
        return new XmlRpcClient(url);
    }

    public static Icon getSendIcon() {
        if (sendIcon_ == null) {
            sendIcon_ = PlasticUtils.createIcon("send.gif");
        }
        return sendIcon_;
    }

    public static Icon getBroadcastIcon() {
        if (broadcastIcon_ == null) {
            broadcastIcon_ = PlasticUtils.createIcon("broadcast.gif");
        }
        return broadcastIcon_;
    }

    private static Icon createIcon(String imageName) {
        try {
            return new ImageIcon(PlasticUtils.class.getResource(imageName));
        }
        catch (Exception e) {
            return new Icon(){

                public int getIconHeight() {
                    return 24;
                }

                public int getIconWidth() {
                    return 24;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                }
            };
        }
    }

    static int getUnusedPort(int startPort) throws IOException {
        int nTry = 20;
        for (int iPort = startPort; iPort < startPort + 20; ++iPort) {
            try {
                Socket trySocket = new Socket("localhost", iPort);
                if (trySocket.isClosed()) continue;
                if (WARN_ABOUT_NOSUCHELEMENTEXCEPTIONS) {
                    WARN_ABOUT_NOSUCHELEMENTEXCEPTIONS = false;
                    System.err.println("Please ignore spurious \"java.util.NoSuchElementException\" messages.");
                }
                trySocket.close();
                continue;
            }
            catch (ConnectException e) {
                return iPort;
            }
        }
        throw new IOException("Can't locate an unused port in range " + startPort + " ... " + (startPort + 20));
    }

    static {
        WARN_ABOUT_NOSUCHELEMENTEXCEPTIONS = true;
    }
}

