/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jsky.catalog.Catalog;

public class CatalogFactory {
    private static Map<String, Catalog> _map = new HashMap<String, Catalog>();
    private static List<Catalog> _list = new ArrayList<Catalog>();

    public static void registerCatalog(Catalog catalog, boolean overwrite) {
        if (_map.containsKey(catalog.getName())) {
            if (overwrite) {
                _map.remove(catalog.getName());
                _list.remove(catalog);
            } else {
                return;
            }
        }
        _map.put(catalog.getName(), catalog);
        _list.add(catalog);
    }

    public static Catalog getCatalogByName(String catalogName) {
        return _map.get(catalogName);
    }

    public static List<Catalog> getCatalogsByType(String type) {
        ArrayList<Catalog> l = new ArrayList<Catalog>();
        for (Catalog cat : _list) {
            String s = cat.getType();
            if (s == null || !s.equals(type)) continue;
            l.add(cat);
        }
        return l;
    }

    public static void unregisterCatalog(Catalog catalog) {
        _map.remove(catalog.getName());
        _list.remove(catalog);
    }
}

