/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager;

import com.cosylab.acs.maci.ComponentInfo;
import com.cosylab.acs.maci.manager.HandleDataStore;
import com.cosylab.acs.maci.manager.IntHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ComponentInfoTopologicalSort {
    protected ComponentInfoVertex[] nodes;
    protected int count = 0;
    protected IntHashMap handleToHashIndexMap;
    protected HandleDataStore handleDataStore;

    public ComponentInfoTopologicalSort(int capacity) throws IllegalArgumentException {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.nodes = new ComponentInfoVertex[capacity];
        this.handleToHashIndexMap = new IntHashMap(capacity, 2.0f);
    }

    public ComponentInfoTopologicalSort(HandleDataStore dataStore) {
        this(dataStore.size());
        HashSet immortalChainMap = this.generateImmortalChainMap(dataStore);
        int pos = 0;
        int h = dataStore.first();
        while (h != 0) {
            ComponentInfo componentInfo = (ComponentInfo)dataStore.get(h);
            this.insert(new ComponentInfoVertex(componentInfo, pos++, immortalChainMap.contains(componentInfo)));
            h = dataStore.next(h);
        }
        this.handleDataStore = dataStore;
    }

    private HashSet generateImmortalChainMap(HandleDataStore dataStore) {
        HashSet set = new HashSet();
        this.markImmortalChain(set, dataStore, 0x5000000);
        return set;
    }

    private void markImmortalChain(HashSet immortalChainMap, HandleDataStore dataStore, int marker) {
        int h = dataStore.first();
        while (h != 0) {
            ComponentInfo componentInfo = (ComponentInfo)dataStore.get(h);
            int[] clients = componentInfo.getClients().toArray();
            for (int i = 0; i < clients.length; ++i) {
                if (clients[i] != marker || immortalChainMap.contains(componentInfo)) continue;
                immortalChainMap.add(componentInfo);
                this.markImmortalChain(immortalChainMap, dataStore, componentInfo.getHandle());
            }
            h = dataStore.next(h);
        }
    }

    protected final int parent(int k) {
        return (k - 1) / 2;
    }

    protected final int left(int k) {
        return 2 * k + 1;
    }

    protected final int right(int k) {
        return 2 * (k + 1);
    }

    public void insert(ComponentInfoVertex element) {
        if (this.count >= this.nodes.length) {
            int newcap = 3 * this.nodes.length / 2 + 1;
            ComponentInfoVertex[] newnodes = new ComponentInfoVertex[newcap];
            System.arraycopy(this.nodes, 0, newnodes, 0, this.nodes.length);
            this.nodes = newnodes;
        }
        int k = this.count++;
        this.downheap(element, k);
    }

    protected void downheap(ComponentInfoVertex element, int k) {
        int par;
        while (k > 0 && element.compareTo(this.nodes[par = this.parent(k)]) < 0) {
            this.nodes[k] = this.nodes[par];
            this.handleToHashIndexMap.put(this.nodes[par].getComponentInfo().getHandle(), k);
            k = par;
        }
        this.nodes[k] = element;
        this.handleToHashIndexMap.put(element.getComponentInfo().getHandle(), k);
    }

    protected ComponentInfoVertex heapExtract() {
        int l;
        if (this.count < 1) {
            return null;
        }
        int k = 0;
        ComponentInfoVertex least = this.nodes[k];
        this.handleToHashIndexMap.remove(least.getComponentInfo().getHandle());
        --this.count;
        ComponentInfoVertex x = this.nodes[this.count];
        this.nodes[this.count] = null;
        while ((l = this.left(k)) < this.count) {
            int child;
            int r = this.right(k);
            int n = child = r >= this.count || this.nodes[l].compareTo(this.nodes[r]) < 0 ? l : r;
            if (x.compareTo(this.nodes[child]) <= 0) break;
            this.nodes[k] = this.nodes[child];
            this.handleToHashIndexMap.put(this.nodes[child].getComponentInfo().getHandle(), k);
            k = child;
        }
        this.nodes[k] = x;
        this.handleToHashIndexMap.put(x.getComponentInfo().getHandle(), k);
        return least;
    }

    public ComponentInfoVertex extract() {
        ComponentInfoVertex civ = this.heapExtract();
        if (!civ.getComponentInfo().getComponents().isEmpty()) {
            int[] clients = civ.getComponentInfo().getComponents().toArray();
            int civHandle = civ.getComponentInfo().getHandle();
            for (int i = 0; i < clients.length; ++i) {
                int index = this.handleToHashIndexMap.get(clients[i]);
                if (index == -1 || !this.nodes[index].getComponentInfo().getClients().contains(civHandle)) continue;
                this.nodes[index].decrementIndegree();
                this.downheap(this.nodes[index], index);
            }
        }
        return civ;
    }

    public ComponentInfoVertex peek() {
        if (this.count > 0) {
            return this.nodes[0];
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.nodes[i] = null;
        }
        this.count = 0;
    }

    public static List sort(HandleDataStore handleDataStore) {
        ComponentInfoTopologicalSort ts = new ComponentInfoTopologicalSort(handleDataStore);
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>(ts.size());
        while (ts.size() > 0) {
            ComponentInfoVertex civ = ts.extract();
            list.add(civ.getComponentInfo());
        }
        return list;
    }

    private static class ComponentInfoVertex
    implements Comparable {
        private static final int IMMORTAL_CREDIT = 0x3FFFFFFF;
        private ComponentInfo componentInfo;
        private int indegree = 0;
        private int order;

        public ComponentInfoVertex(ComponentInfo componentInfo, int order, boolean immortalChain) {
            this.componentInfo = componentInfo;
            this.order = order;
            if (immortalChain) {
                this.indegree += 0x3FFFFFFF;
            }
            int[] clients = componentInfo.getClients().toArray();
            for (int i = 0; i < clients.length; ++i) {
                int type = clients[i] & 0xFF000000;
                if (type != 0x1000000) continue;
                ++this.indegree;
            }
        }

        public void decrementIndegree() {
            --this.indegree;
        }

        public int compareTo(Object obj) {
            int otherIndegree = ((ComponentInfoVertex)obj).indegree;
            if (this.indegree < otherIndegree) {
                return -1;
            }
            if (this.indegree == otherIndegree) {
                int otherOrder = ((ComponentInfoVertex)obj).order;
                if (this.order < otherOrder) {
                    return 1;
                }
                if (this.order == otherOrder) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }

        public ComponentInfo getComponentInfo() {
            return this.componentInfo;
        }

        public int getIndegree() {
            return this.indegree;
        }
    }
}

