/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.plug;

import alma.ACSErrTypeCommon.wrappers.AcsJCORBAProblemEx;
import alma.acs.util.IorParser;
import alma.acs.util.UTCUtility;
import com.cosylab.acs.maci.AuthenticationData;
import com.cosylab.acs.maci.Client;
import com.cosylab.acs.maci.ClientType;
import com.cosylab.acs.maci.ComponentInfo;
import com.cosylab.acs.maci.ImplLang;
import com.cosylab.acs.maci.MessageType;
import com.cosylab.acs.maci.RemoteException;
import com.cosylab.acs.maci.RemoteTimeoutException;
import com.cosylab.acs.maci.RemoteTransientException;
import com.cosylab.acs.maci.plug.CORBAReferenceSerializator;
import com.cosylab.acs.maci.plug.ManagerProxyImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import si.ijs.maci.ClientHelper;
import si.ijs.maci.ImplLangType;
import si.ijs.maci.PingCallback;

public class ClientProxy
extends CORBAReferenceSerializator
implements Client,
Serializable {
    private static final long serialVersionUID = 5300210586145192795L;
    protected si.ijs.maci.Client client;
    protected String ior;
    private static final String NAME_PING_TIMEOUT = "manager.pingCallTimeout";
    private static final double DEFAULT_PING_TIMEOUT_DEFAULT_SEC = 20.0;
    public static long pingTimeoutSec = 20000L;

    public ClientProxy(si.ijs.maci.Client client) {
        assert (client != null);
        this.client = client;
        this.ior = ClientProxy.serialize((Object)client);
    }

    public static ClientType toClientType(si.ijs.maci.ClientType type) {
        if (type == si.ijs.maci.ClientType.CLIENT_TYPE) {
            return ClientType.CLIENT;
        }
        if (type == si.ijs.maci.ClientType.ADMINISTRATOR_TYPE) {
            return ClientType.ADMINISTRATOR;
        }
        if (type == si.ijs.maci.ClientType.CONTAINER_TYPE) {
            return ClientType.CONTAINER;
        }
        throw new IllegalArgumentException("unsupported client type");
    }

    public static ImplLang toImplLang(ImplLangType type) {
        if (type == ImplLangType.JAVA) {
            return ImplLang.java;
        }
        if (type == ImplLangType.CPP) {
            return ImplLang.cpp;
        }
        if (type == ImplLangType.PYTHON) {
            return ImplLang.py;
        }
        throw new IllegalArgumentException("unsupported implementation language type");
    }

    @Override
    public AuthenticationData authenticate(long executionId, String question) throws RemoteException {
        try {
            si.ijs.maci.AuthenticationData retVal = this.client.authenticate(executionId, question);
            return new AuthenticationData(retVal.answer, ClientProxy.toClientType(retVal.client_type), ClientProxy.toImplLang(retVal.impl_lang), retVal.recover, UTCUtility.utcOmgToJava((long)retVal.timestamp), retVal.execution_id);
        }
        catch (Exception ex) {
            RemoteException re = new RemoteException("Failed to invoke 'authenticate()' method.", ex);
            throw re;
        }
    }

    @Override
    public void components_available(ComponentInfo[] cobs) throws RemoteException {
        try {
            si.ijs.maci.ComponentInfo invalidInfo = new si.ijs.maci.ComponentInfo("<invalid>", "<invalid>", null, "<invalid>", new int[0], 0, "<invalid>", 0, 0, new String[0]);
            si.ijs.maci.ComponentInfo[] infos = null;
            if (cobs != null) {
                infos = new si.ijs.maci.ComponentInfo[cobs.length];
                for (int i = 0; i < cobs.length; ++i) {
                    if (cobs[i] == null) {
                        infos[i] = invalidInfo;
                        continue;
                    }
                    Object obj = null;
                    if (cobs[i].getComponent() != null) {
                        obj = (Object)cobs[i].getComponent().getObject();
                    }
                    String[] interfaces = cobs[i].getInterfaces() != null ? cobs[i].getInterfaces() : new String[]{};
                    infos[i] = new si.ijs.maci.ComponentInfo(cobs[i].getType(), cobs[i].getCode(), obj, cobs[i].getName(), cobs[i].getClients().toArray(), cobs[i].getContainer(), cobs[i].getContainerName(), cobs[i].getHandle(), ManagerProxyImpl.mapAccessRights(cobs[i].getAccessRights()), interfaces);
                }
            } else {
                infos = new si.ijs.maci.ComponentInfo[]{};
            }
            this.client.components_available(infos);
        }
        catch (TIMEOUT te) {
            throw new RemoteTimeoutException("Failed to invoke 'components_available()' method due to timeout.", te);
        }
        catch (TRANSIENT tre) {
            throw new RemoteTransientException("Failed to invoke 'components_available()' method due to transient exception.", tre);
        }
        catch (Throwable ex) {
            throw new RemoteException("Failed to invoke 'component_available()' method.", ex);
        }
    }

    @Override
    public void components_unavailable(String[] cobs) throws RemoteException {
        try {
            this.client.components_unavailable(cobs);
        }
        catch (TIMEOUT te) {
            throw new RemoteTimeoutException("Failed to invoke 'components_unavailable()' method due to timeout.", te);
        }
        catch (TRANSIENT tre) {
            throw new RemoteTransientException("Failed to invoke 'components_unavailable()' method due to transient exception.", tre);
        }
        catch (Throwable ex) {
            throw new RemoteException("Failed to invoke 'component_unavailable()' method.", ex);
        }
    }

    @Override
    public void disconnect() throws RemoteException {
        try {
            this.client.disconnect();
        }
        catch (TIMEOUT te) {
            throw new RemoteTimeoutException("Failed to invoke 'disconnect()' method due to timeout.", te);
        }
        catch (TRANSIENT tre) {
            throw new RemoteTransientException("Failed to invoke 'disconnect()' method due to transient exception.", tre);
        }
        catch (Throwable ex) {
            throw new RemoteException("Failed to invoke 'disconnect()' method.", ex);
        }
    }

    @Override
    public void message(MessageType type, String message) throws RemoteException {
        try {
            short msgType = type == MessageType.MSG_ERROR ? (short)0 : 20;
            this.client.message(msgType, message);
        }
        catch (TIMEOUT te) {
            throw new RemoteTimeoutException("Failed to invoke 'message()' method due to timeout.", te);
        }
        catch (TRANSIENT tre) {
            throw new RemoteTransientException("Failed to invoke 'message()' method due to transient exception.", tre);
        }
        catch (Throwable ex) {
            throw new RemoteException("Failed to invoke 'message()' method.", ex);
        }
    }

    @Override
    public void taggedmessage(MessageType type, short id, String message) throws RemoteException {
        try {
            short msgType = type == MessageType.MSG_ERROR ? (short)0 : 20;
            this.client.taggedmessage(msgType, id, message);
        }
        catch (TIMEOUT te) {
            throw new RemoteTimeoutException("Failed to invoke 'tagged_message()' method due to timeout.", te);
        }
        catch (TRANSIENT tre) {
            throw new RemoteTransientException("Failed to invoke 'tagged_message()' method due to transient exception.", tre);
        }
        catch (Throwable ex) {
            throw new RemoteException("Failed to invoke 'tagged_message()' method.", ex);
        }
    }

    @Override
    public String name() throws RemoteException {
        try {
            return this.client.name();
        }
        catch (Exception ex) {
            RemoteException re = new RemoteException("Failed to invoke 'name()' method.", ex);
            throw re;
        }
    }

    @Override
    public boolean ping() throws RemoteException {
        if (this.client == null) {
            return false;
        }
        si.ijs.maci.Client wrappedClient = null;
        try {
            wrappedClient = this.wrapForRoundtripTimeout(this.client, pingTimeoutSec);
            boolean bl = wrappedClient.ping();
            return bl;
        }
        catch (TIMEOUT te) {
            throw new RemoteTimeoutException("Failed to invoke 'ping()' method due to timeout.", te);
        }
        catch (TRANSIENT tre) {
            throw new RemoteTransientException("Failed to invoke 'ping()' method due to transient exception.", tre);
        }
        catch (Throwable ex) {
            throw new RemoteException("Failed to invoke 'ping()' method.", ex);
        }
        finally {
            if (wrappedClient != null) {
                wrappedClient._release();
            }
        }
    }

    @Override
    public void pingCB(PingCallback cb) throws RemoteException {
        if (this.client == null) {
            return;
        }
        try {
            this.client.pingCB(cb);
        }
        catch (TIMEOUT te) {
            throw new RemoteTimeoutException("Failed to invoke 'ping()' method due to timeout.", te);
        }
        catch (TRANSIENT tre) {
            throw new RemoteTransientException("Failed to invoke 'ping()' method due to transient exception.", tre);
        }
        catch (Throwable ex) {
            throw new RemoteException("Failed to invoke 'ping()' method.", ex);
        }
    }

    public si.ijs.maci.Client wrapForRoundtripTimeout(si.ijs.maci.Client corbaRef, long timeout) throws AcsJCORBAProblemEx {
        try {
            ORB orb = ClientProxy.getOrb();
            Any rrtPolicyAny = orb.create_any();
            rrtPolicyAny.insert_ulonglong(UTCUtility.durationJavaMillisToOmg((long)timeout));
            Policy p = orb.create_policy(32, rrtPolicyAny);
            Object ret = corbaRef._set_policy_override(new Policy[]{p}, SetOverrideType.SET_OVERRIDE);
            p.destroy();
            return ClientHelper.narrow((Object)ret);
        }
        catch (Throwable thr) {
            AcsJCORBAProblemEx ex2 = new AcsJCORBAProblemEx(thr);
            ex2.setInfo("Failed to set the object-level client-side corba roundtrip timeout to " + (double)timeout / 1000.0);
            throw ex2;
        }
    }

    public si.ijs.maci.Client getClient() {
        return this.client;
    }

    @Override
    public String getRemoteLocation() throws RemoteException {
        try {
            String[] data = IorParser.parse((String)this.ior);
            return data[0] + ":" + data[1];
        }
        catch (Throwable th) {
            throw new RemoteException("Failed to extract remote location.", th);
        }
    }

    @Override
    public void release() {
        this.client._release();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.ior);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            this.ior = (String)stream.readObject();
            this.client = ClientHelper.narrow((Object)ClientProxy.deserialize(this.ior));
        }
        catch (Exception e) {
            this.client = null;
            this.ior = null;
        }
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("ClientProxy = { ");
        sbuff.append("client = '");
        sbuff.append(this.client);
        sbuff.append("' }");
        return new String(sbuff);
    }

    public boolean equals(Object obj) {
        if (this.client == null) {
            return obj == null;
        }
        if (obj instanceof si.ijs.maci.Client) {
            try {
                return this.client.toString().equals(((si.ijs.maci.Client)obj).toString());
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (obj instanceof ClientProxy) {
            try {
                return this.ior.equals(((ClientProxy)obj).ior);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    static {
        String secValue = System.getProperty(NAME_PING_TIMEOUT);
        if (secValue != null) {
            try {
                pingTimeoutSec = (long)Double.parseDouble(secValue) * 1000L;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            pingTimeoutSec = Math.max(1000L, pingTimeoutSec);
        }
    }
}

