/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jsky.catalog.MemoryCatalog;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.CatalogNavigator;
import jsky.catalog.gui.TableDisplayTool;
import jsky.interop.PlasticHelper;
import jsky.interop.SampHelper;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.gui.GenericToolBar;

public class CatalogNavigatorMenuBar
extends JMenuBar {
    private static final I18N _I18N = I18N.getInstance(CatalogNavigatorMenuBar.class);
    private final String _className = this.getClass().getName();
    private final String _viewToolBarPrefName = this._className + ".ShowToolBar";
    private final String _showToolBarAsPrefName = this._className + ".ShowToolBarAs";
    private final String _showCatalogTreePrefName = this._className + ".CatalogTree";
    private CatalogNavigator _navigator;
    private GenericToolBar _toolBar;
    private JMenu _fileMenu;
    private JMenu _viewMenu;
    private JMenu _goMenu;
    private JMenu _catalogMenu;
    private JMenu _tableMenu;
    private JMenu _queryMenu;
    private JMenu _interopMenu;
    private JCheckBoxMenuItem _tableCellsEditableMenuItem;
    private static CatalogNavigator _currentCatalogNavigator;
    private JCheckBoxMenuItem _showCatalogTreeMenuItem;
    private static Map<Class, Boolean> _catalogTreeIsVisibleMap;

    public CatalogNavigatorMenuBar(CatalogNavigator navigator, GenericToolBar toolBar) {
        this._navigator = navigator;
        this._toolBar = toolBar;
        this._fileMenu = this.createFileMenu();
        this.add(this._fileMenu);
        this._viewMenu = this.createViewMenu();
        this.add(this._viewMenu);
        this._goMenu = this.createGoMenu(null);
        this.add(this._goMenu);
        this._catalogMenu = this.createCatalogMenu();
        this.add(this._catalogMenu);
        this._tableMenu = this.createTableMenu();
        this.add(this._tableMenu);
        this._queryMenu = this.createQueryMenu(null);
        this.add(this._queryMenu);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CatalogNavigatorMenuBar.this._interopMenu = CatalogNavigatorMenuBar.this.createInteropMenu();
                if (CatalogNavigatorMenuBar.this._interopMenu != null) {
                    CatalogNavigatorMenuBar.this.add(CatalogNavigatorMenuBar.this._interopMenu);
                }
            }
        });
        this._goMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                _currentCatalogNavigator = CatalogNavigatorMenuBar.this._navigator;
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this._navigator.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CatalogNavigatorMenuBar.this._updateGoMenu();
                CatalogNavigatorMenuBar.this.updateCatalogTree();
            }
        });
        this._queryMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                _currentCatalogNavigator = CatalogNavigatorMenuBar.this._navigator;
                CatalogNavigatorMenuBar.this._updateQueryMenu();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private void _updateGoMenu() {
        this._goMenu.removeAll();
        this.createGoMenu(this._goMenu);
    }

    protected void updateCatalogTree() {
        JComponent component = this._navigator.getQueryComponent();
        if (component == null) {
            return;
        }
        Boolean showTreeObj = _catalogTreeIsVisibleMap.get(component.getClass());
        boolean showTree = showTreeObj != null ? showTreeObj : Preferences.get(this._showCatalogTreePrefName, true);
        if (showTree != this._showCatalogTreeMenuItem.isSelected()) {
            this._showCatalogTreeMenuItem.setSelected(showTree);
            this._showCatalogTree(showTree, false);
        }
    }

    public static CatalogNavigator getCurrentCatalogNavigator() {
        return _currentCatalogNavigator;
    }

    public static void setCurrentCatalogNavigator(CatalogNavigator navigator) {
        _currentCatalogNavigator = navigator;
    }

    public static void setCatalogTreeIsVisible(Class c, boolean visible) {
        _catalogTreeIsVisibleMap.put(c, visible);
    }

    protected JMenu createFileMenu() {
        JMenu menu = new JMenu(_I18N.getString("file"));
        menu.add(this._navigator.getOpenAction());
        menu.addSeparator();
        menu.add(this._navigator.getOpenUrlAction());
        menu.add(this._navigator.getClearAction());
        menu.addSeparator();
        menu.add(this._navigator.getSaveAsAction());
        menu.add(this._navigator.getSaveWithImageAction());
        menu.add(this._navigator.getSaveAsHTMLAction());
        menu.add(this._navigator.getPrintAction());
        menu.addSeparator();
        menu.add(this._navigator.getCloseAction());
        return menu;
    }

    protected JMenuItem createFileExitMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CatalogNavigatorMenuBar.this._navigator.exit();
            }
        });
        return menuItem;
    }

    protected JMenu createViewMenu() {
        JMenu menu = new JMenu(_I18N.getString("view"));
        menu.add(this.createViewToolBarMenuItem());
        menu.add(this.createViewShowToolBarAsMenu());
        menu.add(this.createViewCatalogTreeMenu());
        return menu;
    }

    protected JCheckBoxMenuItem createViewToolBarMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(_I18N.getString("toolbar"));
        menuItem.setToolTipText(_I18N.getString("toolbarTip"));
        menuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem rb = (JCheckBoxMenuItem)e.getSource();
                CatalogNavigatorMenuBar.this._toolBar.setVisible(rb.isSelected());
                if (rb.isSelected()) {
                    Preferences.set(CatalogNavigatorMenuBar.this._viewToolBarPrefName, "true");
                } else {
                    Preferences.set(CatalogNavigatorMenuBar.this._viewToolBarPrefName, "false");
                }
            }
        });
        String pref = Preferences.get(this._viewToolBarPrefName);
        if (pref != null && pref.equals("true")) {
            menuItem.setSelected(true);
        } else {
            menuItem.setSelected(true);
            this._toolBar.setVisible(true);
        }
        return menuItem;
    }

    protected JMenu createViewShowToolBarAsMenu() {
        JMenu menu = new JMenu(_I18N.getString("showToolBarAs"));
        JRadioButtonMenuItem b1 = new JRadioButtonMenuItem(_I18N.getString("picAndText"));
        JRadioButtonMenuItem b2 = new JRadioButtonMenuItem(_I18N.getString("picOnly"));
        JRadioButtonMenuItem b3 = new JRadioButtonMenuItem(_I18N.getString("textOnly"));
        b2.setSelected(true);
        this._toolBar.setShowPictures(true);
        this._toolBar.setShowText(false);
        menu.add(b1);
        menu.add(b2);
        menu.add(b3);
        ButtonGroup group = new ButtonGroup();
        group.add(b1);
        group.add(b2);
        group.add(b3);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
                if (rb.isSelected()) {
                    if (rb.getText().equals(_I18N.getString("picAndText"))) {
                        CatalogNavigatorMenuBar.this._toolBar.setShowPictures(true);
                        CatalogNavigatorMenuBar.this._toolBar.setShowText(true);
                        Preferences.set(CatalogNavigatorMenuBar.this._showToolBarAsPrefName, "1");
                    } else if (rb.getText().equals(_I18N.getString("picOnly"))) {
                        CatalogNavigatorMenuBar.this._toolBar.setShowPictures(true);
                        CatalogNavigatorMenuBar.this._toolBar.setShowText(false);
                        Preferences.set(CatalogNavigatorMenuBar.this._showToolBarAsPrefName, "2");
                    } else if (rb.getText().equals(_I18N.getString("textOnly"))) {
                        CatalogNavigatorMenuBar.this._toolBar.setShowPictures(false);
                        CatalogNavigatorMenuBar.this._toolBar.setShowText(true);
                        Preferences.set(CatalogNavigatorMenuBar.this._showToolBarAsPrefName, "3");
                    }
                }
            }
        };
        b1.addItemListener(itemListener);
        b2.addItemListener(itemListener);
        b3.addItemListener(itemListener);
        String pref = Preferences.get(this._showToolBarAsPrefName);
        if (pref != null) {
            JRadioButtonMenuItem[] ar = new JRadioButtonMenuItem[]{null, b1, b2, b3};
            try {
                ar[Integer.parseInt(pref)].setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return menu;
    }

    protected JCheckBoxMenuItem createViewCatalogTreeMenu() {
        this._showCatalogTreeMenuItem = new JCheckBoxMenuItem(_I18N.getString("catalogTree"));
        this._showCatalogTreeMenuItem.setToolTipText(_I18N.getString("catalogTreeTip"));
        this._showCatalogTreeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CatalogNavigatorMenuBar.this._showCatalogTree(CatalogNavigatorMenuBar.this._showCatalogTreeMenuItem.isSelected(), true);
            }
        });
        boolean showTree = Preferences.get(this._showCatalogTreePrefName, true);
        this._showCatalogTreeMenuItem.setSelected(showTree);
        this._showCatalogTree(showTree, false);
        return this._showCatalogTreeMenuItem;
    }

    private void _showCatalogTree(boolean show, boolean setPrefs) {
        if (show) {
            this._navigator.getCatalogTree().setVisible(true);
            this._navigator.getQuerySplitPane().resetToPreferredSizes();
            this._navigator.getQuerySplitPane().setDividerSize(10);
        } else {
            this._navigator.getCatalogTree().setVisible(false);
            this._navigator.getQuerySplitPane().setDividerSize(0);
        }
        if (setPrefs) {
            Preferences.set(this._showCatalogTreePrefName, show);
        } else {
            this._showCatalogTreeMenuItem.setSelected(show);
        }
    }

    protected JMenu createGoMenu(JMenu menu) {
        if (menu == null) {
            menu = new JMenu(_I18N.getString("go"));
        }
        menu.add(this._navigator.getBackAction());
        menu.add(this._navigator.getForwAction());
        menu.addSeparator();
        this._navigator.addHistoryMenuItems(menu);
        menu.addSeparator();
        menu.add(this.createGoClearHistoryMenuItem());
        return menu;
    }

    protected JMenuItem createGoClearHistoryMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("clearHistory"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CatalogNavigatorMenuBar.this._navigator.clearHistory();
                CatalogNavigatorMenuBar.this._goMenu.removeAll();
                CatalogNavigatorMenuBar.this.createGoMenu(CatalogNavigatorMenuBar.this._goMenu);
            }
        });
        return menuItem;
    }

    protected JMenu createCatalogMenu() {
        return new JMenu(_I18N.getString("catalog"));
    }

    protected JMenu createTableMenu() {
        JMenu menu = new JMenu(_I18N.getString("table"));
        menu.add(this._navigator.getAddRowAction());
        menu.add(this._navigator.getDeleteSelectedRowsAction());
        menu.addSeparator();
        this._tableCellsEditableMenuItem = this.createTableCellsEditableMenuItem();
        menu.add(this._tableCellsEditableMenuItem);
        this._navigator.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JComponent c = CatalogNavigatorMenuBar.this._navigator.getResultComponent();
                if (c instanceof TableDisplayTool) {
                    CatalogNavigatorMenuBar.this._tableCellsEditableMenuItem.setEnabled(true);
                    TableQueryResult queryResult = ((TableDisplayTool)c).getTable();
                    if (queryResult instanceof MemoryCatalog) {
                        MemoryCatalog cat = (MemoryCatalog)queryResult;
                        CatalogNavigatorMenuBar.this._tableCellsEditableMenuItem.setSelected(!cat.isReadOnly());
                    }
                } else {
                    CatalogNavigatorMenuBar.this._tableCellsEditableMenuItem.setSelected(false);
                    CatalogNavigatorMenuBar.this._tableCellsEditableMenuItem.setEnabled(false);
                }
            }
        });
        return menu;
    }

    protected JCheckBoxMenuItem createTableCellsEditableMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(_I18N.getString("editableTableCells"));
        menuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem rb = (JCheckBoxMenuItem)e.getSource();
                CatalogNavigatorMenuBar.this._navigator.setTableCellsEditable(rb.isSelected());
            }
        });
        return menuItem;
    }

    private void _updateQueryMenu() {
        this._queryMenu.removeAll();
        this.createQueryMenu(this._queryMenu);
    }

    protected JMenu createQueryMenu(JMenu menu) {
        if (menu == null) {
            menu = new JMenu(_I18N.getString("query"));
        }
        menu.add(this.createQueryStoreMenu());
        menu.add(this.createQueryDeleteMenu());
        menu.addSeparator();
        this._navigator.addQueryMenuItems(menu, null);
        return menu;
    }

    protected JMenu createQueryStoreMenu() {
        JMenu menu = new JMenu(_I18N.getString("storeQuery"));
        menu.add(this._navigator.getStoreNewQueryAction());
        menu.addSeparator();
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                String name = menuItem.getText();
                CatalogNavigatorMenuBar.this._navigator.storeQuery(name);
            }
        };
        this._navigator.addQueryMenuItems(menu, l);
        return menu;
    }

    protected JMenu createQueryDeleteMenu() {
        JMenu menu = new JMenu(_I18N.getString("deleteQuery"));
        menu.add(this._navigator.getDeleteAllQueryAction());
        menu.addSeparator();
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                String name = menuItem.getText();
                CatalogNavigatorMenuBar.this._navigator.deleteQuery(name);
            }
        };
        this._navigator.addQueryMenuItems(menu, l);
        return menu;
    }

    protected JMenu createInteropMenu() {
        SampHelper sh = SampHelper.getInstance();
        PlasticHelper ph = PlasticHelper.getInstance();
        if (sh == null && ph == null) {
            return null;
        }
        JMenu menu = new JMenu(_I18N.getString("interop"));
        if (sh != null && ph != null) {
            JMenu sampMenu = new JMenu("SAMP");
            menu.add(sampMenu);
            sh.initTableMenu(sampMenu);
            JMenu plasticMenu = new JMenu("PLASTIC");
            menu.add(plasticMenu);
            ph.initTableMenu(plasticMenu);
        } else {
            if (sh != null) {
                sh.initTableMenu(menu);
            }
            if (ph != null) {
                ph.initTableMenu(menu);
            }
        }
        return menu;
    }

    public CatalogNavigator getNavigator() {
        return this._navigator;
    }

    public GenericToolBar getToolBar() {
        return this._toolBar;
    }

    public JMenu getFileMenu() {
        return this._fileMenu;
    }

    public JMenu getViewMenu() {
        return this._viewMenu;
    }

    public JMenu getGoMenu() {
        return this._goMenu;
    }

    public JMenu getCatalogMenu() {
        return this._catalogMenu;
    }

    public JMenu getTableMenu() {
        return this._tableMenu;
    }

    public JMenu getInteropMenu() {
        return this._interopMenu;
    }

    public JMenu getQueryMenu() {
        return this._queryMenu;
    }

    static {
        _catalogTreeIsVisibleMap = new Hashtable<Class, Boolean>();
    }
}

