/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsky.catalog.FieldDesc;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.util.gui.DialogUtil;

public class HyperlinkTableCellRenderer
extends JButton
implements TableCellRenderer,
TableCellEditor,
ActionListener {
    protected FieldDesc _field;
    protected TableQueryResult _tableQueryResult;
    protected Object _value;
    protected int _row;
    QueryResultDisplay _queryResultDisplay;

    public HyperlinkTableCellRenderer(FieldDesc field, TableQueryResult tableQueryResult, QueryResultDisplay queryResultDisplay) {
        this._field = field;
        this._tableQueryResult = tableQueryResult;
        this._queryResultDisplay = queryResultDisplay;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        block2: {
            try {
                URLQueryResult queryResult = this._field.getLinkValue(this._tableQueryResult, this._value, this._row);
                this._queryResultDisplay.setQueryResult(queryResult);
            }
            catch (Exception e) {
                if (this.getText().length() == 0) break block2;
                DialogUtil.error(e);
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            if (value instanceof String) {
                String urlStr = (String)value;
                if (urlStr.startsWith("M=") || urlStr.startsWith("P=")) {
                    urlStr = urlStr.substring(2);
                }
                this.setText(this._field.getLinkText(this._tableQueryResult, urlStr, row, column));
                this.setToolTipText(new URL(urlStr).toString());
                this.setEnabled(true);
                return this;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return table.getDefaultRenderer(Object.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._row = row;
        this._value = value;
        try {
            if (value instanceof String) {
                String urlStr = (String)value;
                if (urlStr.startsWith("M=") || urlStr.startsWith("P=")) {
                    urlStr = urlStr.substring(2);
                }
                this.setText(this._field.getLinkText(this._tableQueryResult, urlStr, row, column));
                this.setToolTipText(new URL(urlStr).toString());
                this.setEnabled(true);
                return this;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return table.getDefaultEditor(Object.class).getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this._value;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return anEvent instanceof MouseEvent;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

