/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import jsky.catalog.MemoryCatalog;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.catalog.gui.SymbolSelectionEvent;
import jsky.catalog.gui.SymbolSelectionListener;
import jsky.catalog.gui.TableColumnConfigPanel;
import jsky.catalog.gui.TableDisplay;
import jsky.catalog.gui.TablePlotter;
import jsky.interop.SampHelper;
import jsky.util.I18N;
import jsky.util.IApplyCancel;
import jsky.util.PrintableWithDialog;
import jsky.util.Saveable;
import jsky.util.SaveableAsHTML;
import jsky.util.SaveableWithDialog;
import jsky.util.Storeable;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ExampleFileFilter;
import jsky.util.gui.GridBagUtil;
import jsky.util.gui.SortedJTable;
import jsky.util.gui.SwingUtil;
import jsky.util.gui.TabbedPaneDialog;
import jsky.util.gui.TabbedPanel;

public class TableDisplayTool
extends JPanel
implements QueryResultDisplay,
Saveable,
SaveableWithDialog,
SaveableAsHTML,
PrintableWithDialog,
Storeable {
    private static final I18N _I18N = I18N.getInstance(TableDisplayTool.class);
    private static final ExampleFileFilter VOTABLE_FILTER = new ExampleFileFilter(new String[]{"xml", "vot"}, "VOTable XML File");
    private static final ExampleFileFilter FITS_FILTER = new ExampleFileFilter(new String[]{"fit", "fits", "fts"}, "FITS File (with Table Extensions)");
    private static final ExampleFileFilter SKYCAT_TSV_FILTER = new ExampleFileFilter(new String[]{"table", "scat", "cat"}, "Skycat Local Catalog File");
    private TableQueryResult _table;
    private boolean _plotted = false;
    private TableDisplay _tableDisplay;
    private SortedJTable _sortedJTable;
    private TablePlotter _plotter;
    private JLabel _tableTitle;
    private JPanel _buttonPanel;
    private JButton _plotButton;
    private JButton _unplotButton;
    private JButton _unplotAllButton;
    private JButton _configButton;
    private TabbedPaneDialog _configureDialog;
    private TabbedPanel _configPanel;
    private TableColumnConfigPanel _tableConfig;
    private boolean ignoreSelection = false;
    private static JFileChooser _fileChooser;
    private static boolean _broadcastRowSelections;
    private SymbolSelectionListener _symbolListener = new SymbolSelectionListener(){

        @Override
        public void symbolSelected(SymbolSelectionEvent e) {
            if (!TableDisplayTool.this.ignoreSelection && e.getTable() == TableDisplayTool.this._table) {
                TableDisplayTool.this.ignoreSelection = true;
                try {
                    TableDisplayTool.this._tableDisplay.selectRow(e.getRow());
                    TableDisplayTool.this._broadcastRowSelections();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TableDisplayTool.this.ignoreSelection = false;
            }
        }

        @Override
        public void symbolDeselected(SymbolSelectionEvent e) {
            if (!TableDisplayTool.this.ignoreSelection && e.getTable() == TableDisplayTool.this._table) {
                TableDisplayTool.this.ignoreSelection = true;
                try {
                    TableDisplayTool.this._tableDisplay.deselectRow(e.getRow());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TableDisplayTool.this.ignoreSelection = false;
            }
        }
    };
    private ListSelectionListener _selectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || TableDisplayTool.this.ignoreSelection) {
                return;
            }
            ListSelectionModel model = TableDisplayTool.this._tableDisplay.getTable().getSelectionModel();
            int first = e.getFirstIndex();
            int last = e.getLastIndex();
            for (int i = first; i <= last; ++i) {
                int index = TableDisplayTool.this._sortedJTable.getSortedRowIndex(i);
                if (model.isSelectedIndex(i)) {
                    TableDisplayTool.this._plotter.selectSymbol(TableDisplayTool.this._table, index);
                    continue;
                }
                TableDisplayTool.this._plotter.deselectSymbol(TableDisplayTool.this._table, index);
            }
            TableDisplayTool.this._broadcastRowSelections();
        }
    };

    private void _broadcastRowSelections() {
        if (_broadcastRowSelections) {
            int[] rows = this._tableDisplay.getTable().getSelectedRows();
            ArrayList<Integer> selectedRows = new ArrayList<Integer>(rows.length);
            for (int row : rows) {
                int index = this._sortedJTable.getSortedRowIndex(row);
                selectedRows.add(index);
            }
            SampHelper sh = SampHelper.getInstance();
            if (sh != null) {
                sh.transmitSelectedRows(selectedRows);
            }
        }
    }

    public TableDisplayTool(TableQueryResult table, QueryResultDisplay queryResultDisplay, TablePlotter plotter) {
        this._table = table;
        this._plotter = plotter;
        this.makeLayout(queryResultDisplay);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableDisplayTool.this.plot();
            }
        });
    }

    protected void makeLayout(QueryResultDisplay queryResultDisplay) {
        this._tableDisplay = this.makeTableDisplay(this._table, queryResultDisplay);
        this._sortedJTable = this._tableDisplay.getTable();
        this._tableTitle = new JLabel("", 0);
        this.updateTitle();
        this._buttonPanel = this.makeButtonPanel();
        GridBagUtil layout = new GridBagUtil(this);
        layout.add(this._tableTitle, 0, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(3, 0, 3, 0));
        layout.add(this._tableDisplay, 0, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
        layout.add(this._buttonPanel, 0, 2, 1, 1, 0.0, 0.0, 2, 10, new Insets(5, 0, 0, 0));
    }

    protected TableDisplay makeTableDisplay(TableQueryResult table, QueryResultDisplay queryResultDisplay) {
        return new TableDisplay(table, queryResultDisplay);
    }

    public TableDisplay getTableDisplay() {
        return this._tableDisplay;
    }

    protected JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        this._plotButton = new JButton(_I18N.getString("plot"));
        this._plotButton.setToolTipText(_I18N.getString("plotTip"));
        panel.add(this._plotButton);
        this._plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TableDisplayTool.this.unplot();
                TableDisplayTool.this.plot();
            }
        });
        this._unplotButton = new JButton(_I18N.getString("unplot"));
        this._unplotButton.setToolTipText(_I18N.getString("unplotTip"));
        panel.add(this._unplotButton);
        this._unplotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TableDisplayTool.this.unplot();
            }
        });
        this._unplotAllButton = new JButton(_I18N.getString("unplotAll"));
        this._unplotAllButton.setToolTipText(_I18N.getString("unplotAllTip"));
        panel.add(this._unplotAllButton);
        this._unplotAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TableDisplayTool.this.unplotAll();
            }
        });
        this._configButton = new JButton(_I18N.getString("configure"));
        this._configButton.setToolTipText(_I18N.getString("configureTip"));
        panel.add(this._configButton);
        this._configButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TableDisplayTool.this.configure();
            }
        });
        return panel;
    }

    public JPanel getButtonPanel() {
        return this._buttonPanel;
    }

    public JButton getPlotButton() {
        return this._plotButton;
    }

    public JButton getUnplotButton() {
        return this._unplotButton;
    }

    public JButton getUnplotAllButton() {
        return this._unplotAllButton;
    }

    public JButton getConfigButton() {
        return this._configButton;
    }

    public static void setBroadcastRowSelections(boolean b) {
        _broadcastRowSelections = b;
    }

    public void plot() {
        if (this._plotter != null) {
            this._tableDisplay.getTable().clearSelection();
            this._plotter.addSymbolSelectionListener(this._symbolListener);
            this._tableDisplay.getTable().getSelectionModel().addListSelectionListener(this._selectionListener);
            try {
                this._plotter.plot(this._table);
                this._plotted = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void unplot() {
        if (this._plotter != null) {
            this._plotter.removeSymbolSelectionListener(this._symbolListener);
            this._tableDisplay.getTable().getSelectionModel().removeListSelectionListener(this._selectionListener);
            this._plotter.unplot(this._table);
            this._plotted = false;
        }
    }

    public void unplotAll() {
        if (this._plotter != null) {
            this._plotter.removeSymbolSelectionListener(this._symbolListener);
            this._plotter.unplotAll();
            this._plotted = false;
        }
    }

    public void replot() {
        this.unplot();
        this.plot();
    }

    public TableQueryResult getTable() {
        return this._table;
    }

    protected SortedJTable getSortedJTable() {
        return this._sortedJTable;
    }

    public TablePlotter getPlotter() {
        return this._plotter;
    }

    public void setPlotter(TablePlotter plotter) {
        this._plotter = plotter;
    }

    public void configure() {
        if (this._configureDialog != null) {
            this._configureDialog.setVisible(true);
            return;
        }
        String title = _I18N.getString("configureTableDisplay");
        this._configureDialog = new TabbedPaneDialog(SwingUtil.getFrame(this), title);
        this._configPanel = this._configureDialog.getTabbedPanel();
        this.addTableColumnConfigPanel();
        if (this._plotter != null) {
            this.addPlotterConfigPanel();
        }
        this._configureDialog.pack();
        this._configureDialog.setVisible(true);
    }

    protected void addPlotterConfigPanel() {
        JTabbedPane tabbedPane = this._configPanel.getTabbedPane();
        final IApplyCancel symbolConfig = this.getPlotter().getConfigPanel(this.getTable());
        tabbedPane.add((Component)((JPanel)((Object)symbolConfig)), _I18N.getString("plotSymbols"));
        ActionListener applyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                symbolConfig.apply();
            }
        };
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                symbolConfig.cancel();
            }
        };
        this._configPanel.getApplyButton().addActionListener(applyListener);
        this._configPanel.getOKButton().addActionListener(applyListener);
        this._configPanel.getCancelButton().addActionListener(cancelListener);
    }

    protected void addTableColumnConfigPanel() {
        JTabbedPane tabbedPane = this._configPanel.getTabbedPane();
        this._tableConfig = new TableColumnConfigPanel(this._tableDisplay);
        tabbedPane.add((Component)this._tableConfig, _I18N.getString("showTableCols"));
        ActionListener applyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDisplayTool.this._tableConfig.apply();
            }
        };
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDisplayTool.this._tableConfig.cancel();
            }
        };
        this._configPanel.getApplyButton().addActionListener(applyListener);
        this._configPanel.getOKButton().addActionListener(applyListener);
        this._configPanel.getCancelButton().addActionListener(cancelListener);
    }

    public TabbedPanel getConfigPanel() {
        return this._configPanel;
    }

    public void hidePopups() {
        if (this._configureDialog != null) {
            this._configureDialog.setVisible(false);
        }
    }

    @Override
    public String getName() {
        if (this._table != null) {
            return this._table.getName();
        }
        return _I18N.getString("table");
    }

    @Override
    public void setQueryResult(QueryResult queryResult) {
        if (queryResult instanceof TableQueryResult) {
            if (this._plotted && this._plotter != null) {
                this._plotter.unplot(this._table);
            }
            this._table = (TableQueryResult)queryResult;
            String title = this._table.getTitle() + " (" + this._table.getRowCount() + (this._table.isMore() ? "+)" : ")");
            this._tableTitle.setText(title);
            this._tableDisplay.setModel(this._table);
            if (this._plotter != null) {
                this._plotter.plot(this._table);
            }
            this.updateConfigPanel();
        }
    }

    protected void updateConfigPanel() {
        if (this._tableConfig != null) {
            this._tableConfig.cancel();
        }
    }

    protected JFileChooser makeFileChooser() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.addChoosableFileFilter(VOTABLE_FILTER);
        fileChooser.addChoosableFileFilter(FITS_FILTER);
        fileChooser.addChoosableFileFilter(SKYCAT_TSV_FILTER);
        fileChooser.setFileFilter(VOTABLE_FILTER);
        return fileChooser;
    }

    @Override
    public void saveAs() {
        if (this._table instanceof Saveable) {
            int option;
            if (_fileChooser == null) {
                _fileChooser = this.makeFileChooser();
            }
            if ((option = _fileChooser.showSaveDialog(this)) == 0 && _fileChooser.getSelectedFile() != null) {
                File file = _fileChooser.getSelectedFile();
                String filename = file.getAbsolutePath();
                if (!file.getName().contains(".")) {
                    FileFilter filter = _fileChooser.getFileFilter();
                    if (filter == VOTABLE_FILTER) {
                        filename = filename + ".vot";
                    } else if (filter == FITS_FILTER) {
                        filename = filename + ".fits";
                    }
                }
                this.saveAs(filename);
            }
        } else {
            DialogUtil.error(_I18N.getString("saveNotSupportedForTableType") + ": " + this._table.getClass());
        }
    }

    @Override
    public void saveAs(String filename) {
        if (this._table instanceof Saveable) {
            try {
                String msg;
                int ans;
                File file = new File(filename);
                if (file.exists() && (ans = DialogUtil.confirm(msg = _I18N.getString("fileOverWritePrompt", filename))) != 0) {
                    return;
                }
                ((Saveable)((Object)this._table)).saveAs(filename);
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        } else {
            DialogUtil.error(_I18N.getString("saveNotSupportedForTableType") + ": " + this._table.getClass());
        }
    }

    @Override
    public void saveAsHTML(String filename) {
        try {
            String msg;
            int ans;
            File file = new File(filename);
            if (file.exists() && (ans = DialogUtil.confirm(msg = _I18N.getString("fileOverWritePrompt", filename))) != 0) {
                return;
            }
            this._tableDisplay.saveAsHTML(filename);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    @Override
    public void print() throws PrinterException {
        this._tableDisplay.print(this._tableTitle.getText());
    }

    protected void updateTitle() {
        if (this._table != null) {
            String titleString = this._table.getTitle() + " (" + this._table.getRowCount() + ")";
            this.setName(titleString);
            this._tableTitle.setText(titleString);
        }
    }

    public void addRow() {
        this.addRow(null);
    }

    public void addRow(Vector v) {
        this._tableDisplay.getTable().addRow(v);
        this._tableDisplay.update();
        this.updateTitle();
    }

    public void updateRow(int rowIndex, Vector v) {
        TableQueryResult table = this._tableDisplay.getTableQueryResult();
        for (int colIndex = 0; colIndex < v.size(); ++colIndex) {
            table.setValueAt(v.get(colIndex), rowIndex, colIndex);
        }
        this._tableDisplay.update();
    }

    public Vector getRow(int rowIndex) {
        DefaultTableModel model = (DefaultTableModel)((Object)this._tableDisplay.getTableQueryResult());
        return model.getDataVector().get(rowIndex);
    }

    public void deleteSelectedRows() {
        SortedJTable t = this._tableDisplay.getTable();
        int[] selected = t.getSelectedRows();
        t.removeRows(selected);
        this._tableDisplay.update();
        if (this._plotter != null && this._plotted) {
            this.unplot();
            this.plot();
        }
        this.updateTitle();
    }

    public void setTableCellsEditable(boolean b) {
        TableQueryResult queryResult = this._tableDisplay.getTableQueryResult();
        if (queryResult instanceof MemoryCatalog) {
            ((MemoryCatalog)queryResult).setReadOnly(!b);
        }
    }

    public int getRowCount() {
        return this._tableDisplay.getTableQueryResult().getRowCount();
    }

    @Override
    public Object storeSettings() {
        return this._tableDisplay.storeSettings();
    }

    @Override
    public boolean restoreSettings(Object obj) {
        return this._tableDisplay.restoreSettings(obj);
    }

    static {
        _broadcastRowSelections = true;
    }
}

