/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.AbstractFigureContainer;
import diva.canvas.BasicZList;
import diva.canvas.Figure;
import diva.canvas.ZList;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureGroup;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerManager;
import jsky.image.graphics.RectangleGeometry;

public class ImageFigureGroup
extends AbstractFigureContainer
implements CanvasFigureGroup {
    private Object _clientData;
    private CanvasFigureListenerManager _listenerManager;
    private ZList _children = new BasicZList();
    private List<CanvasFigure> _slaves;
    private boolean _persistent;
    private RectangleGeometry _geometry;
    private boolean _resizable = true;

    public ImageFigureGroup(Interactor interactor) {
        this._listenerManager = new CanvasFigureListenerManager(this);
        this.updateGeometry();
        if (interactor != null) {
            this.setInteractor(interactor);
        }
    }

    @Override
    public void add(Figure f) {
        this._children.add(f);
        f.setParent(this);
        f.repaint();
        this.updateGeometry();
    }

    public void add(int index, Figure f) {
        this._children.add(index, f);
        f.setParent(this);
        f.repaint();
        this.updateGeometry();
    }

    @Override
    public void remove(Figure f) {
        f.repaint();
        f.setParent(null);
        this._children.remove(f);
        f.repaint();
        this.updateGeometry();
    }

    @Override
    public boolean contains(Figure f) {
        return this._children.contains(f);
    }

    @Override
    public Iterator figures() {
        return this._children.figures();
    }

    @Override
    public Iterator figuresFromBack() {
        return this._children.figuresFromBack();
    }

    @Override
    public Iterator figuresFromFront() {
        return this._children.figuresFromFront();
    }

    @Override
    public int getFigureCount() {
        return this._children.getFigureCount();
    }

    @Override
    public Shape getShape() {
        return this._children.getBounds();
    }

    @Override
    protected void replaceChild(Figure child, Figure replacement) {
        this.repaint();
        this._children.set(this._children.indexOf(child), replacement);
        this.repaint();
    }

    @Override
    public void setClientData(Object o) {
        this._clientData = o;
    }

    @Override
    public Object getClientData() {
        return this._clientData;
    }

    @Override
    public Rectangle2D getBoundsWithoutLabel() {
        return this.getBounds();
    }

    @Override
    public boolean isSelected() {
        return this.getInteractor() instanceof SelectionInteractor;
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        this.repaint();
    }

    @Override
    public boolean isPersistent() {
        return this._persistent;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    @Override
    public void addCanvasFigureListener(CanvasFigureListener listener) {
        this._listenerManager.addCanvasFigureListener(listener);
    }

    @Override
    public void removeCanvasFigureListener(CanvasFigureListener listener) {
        this._listenerManager.removeCanvasFigureListener(listener);
    }

    @Override
    public void fireCanvasFigureEvent(int eventType) {
        this._listenerManager.fireCanvasFigureEvent(eventType);
    }

    @Override
    public void addSlave(CanvasFigure fig) {
        if (this._slaves == null) {
            this._slaves = new LinkedList<CanvasFigure>();
        }
        this._slaves.add(fig);
    }

    @Override
    public void translate(double dx, double dy) {
        super.translate(dx, dy);
        this._geometry.translate(dx, dy);
        if (this._slaves != null) {
            ListIterator<CanvasFigure> it = this._slaves.listIterator(0);
            while (it.hasNext()) {
                Figure fig = it.next();
                fig.translate(dx, dy);
            }
        }
    }

    @Override
    public void transform(AffineTransform at) {
        super.transform(at);
        this._geometry.transform(at);
    }

    @Override
    public RectangleGeometry getGeometry() {
        return this._geometry;
    }

    public void setGeometry(RectangleGeometry geometry) {
        this._geometry = geometry;
    }

    public void updateGeometry() {
        this.setGeometry(new RectangleGeometry(this, this.getBounds()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode();
    }

    public void setEditable(boolean editable) {
        if (!editable) {
            this.setInteractor(null);
            this.repaint();
        }
    }

    @Override
    public boolean isResizable() {
        return this._resizable;
    }

    @Override
    public void setResizable(boolean resizable) {
        this._resizable = resizable;
    }
}

