/*
 * Decompiled with CFR 0.152.
 */
package jsky.interop;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.TableDisplayTool;
import jsky.catalog.vo.VoCatalog;
import jsky.catalog.vo.VoTable;
import jsky.image.ImageChangeEvent;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.interop.ImageSendActionManager;
import jsky.interop.SampFrame;
import jsky.interop.SendManager;
import jsky.interop.TableSendActionManager;
import jsky.navigator.Navigator;
import jsky.navigator.NavigatorImageDisplayFrame;
import jsky.util.Resources;
import jsky.util.gui.DialogUtil;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.client.AbstractMessageHandler;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;

public class SampHelper {
    private static final Logger LOG = Logger.getLogger(SampHelper.class.getName());
    private static final String TABLE_LOAD_VOTABLE = "table.load.votable";
    private static final String TABLE_LOAD_FITS = "table.load.fits";
    private static final String TABLE_HIGHLIGHT_ROW = "table.highlight.row";
    private static final String TABLE_SELECT_ROW_LIST = "table.select.rowList";
    private static final String IMAGE_LOAD_FITS = "image.load.fits";
    private static final String COORDS_POINT_AT_SKY = "coord.pointAt.sky";
    private static final String[] MESSAGE_TYPES = new String[]{"table.load.votable", "table.load.fits", "table.highlight.row", "table.select.rowList", "image.load.fits", "coord.pointAt.sky"};
    private static SampHelper _instance;
    private GuiHubConnector _connector;
    private NavigatorImageDisplayFrame _imageFrame;
    private WindowAction _windowAction;
    private JCheckBoxMenuItem _broadcastRowSelectionsMenuItem;
    private SendManager _tableSelectionSendManager;
    private boolean _processingMessage;

    public static void init(Metadata meta, NavigatorImageDisplayFrame imageFrame) {
        if (_instance == null) {
            _instance = new SampHelper(meta, imageFrame);
        }
    }

    public static SampHelper getInstance() {
        return _instance;
    }

    public GuiHubConnector getConnector() {
        return this._connector;
    }

    public SampHelper(Metadata meta, NavigatorImageDisplayFrame imageFrame) {
        this._imageFrame = imageFrame;
        StandardClientProfile profile = StandardClientProfile.getInstance();
        this._connector = new GuiHubConnector(profile);
        this._connector.declareMetadata(meta);
        this._connector.addMessageHandler(new AbstractMessageHandler(MESSAGE_TYPES){

            @Override
            public Map processCall(HubConnection c, final String senderId, final Message msg) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SampHelper.this._processingMessage = true;
                                SampHelper.this.handleMessage(senderId, msg);
                            }
                            catch (Exception e) {
                                DialogUtil.error(e);
                            }
                            finally {
                                SampHelper.this._processingMessage = false;
                            }
                        }
                    });
                    return null;
                }
                catch (Exception e) {
                    DialogUtil.error(e);
                    return null;
                }
            }
        });
        this._connector.declareSubscriptions(this._connector.computeSubscriptions());
        this._connector.setAutoconnect(10);
    }

    protected Map handleMessage(String senderId, Message message) throws Exception {
        LOG.info("process call from: " + senderId + ", msg = " + message);
        String type = message.getMType();
        if (TABLE_LOAD_VOTABLE.equals(type)) {
            URL url = new URL((String)message.getParam("url"));
            String name = (String)message.getParam("name");
            String tableId = (String)message.getParam("table-id");
            if (name == null) {
                name = tableId;
            }
            this.tableLoadVotable(url, tableId, name);
        } else if (TABLE_LOAD_FITS.equals(type)) {
            URL url = new URL((String)message.getParam("url"));
            String name = (String)message.getParam("name");
            String tableId = (String)message.getParam("table-id");
            if (name == null) {
                name = tableId;
            }
            this.tableLoadFits(url, tableId, name);
        } else if (IMAGE_LOAD_FITS.equals(type)) {
            URL url = new URL((String)message.getParam("url"));
            String name = (String)message.getParam("name");
            String imageId = (String)message.getParam("image-id");
            if (name == null) {
                name = imageId;
            }
            this.imageLoadFits(url, imageId, name);
        } else if (TABLE_HIGHLIGHT_ROW.equals(type)) {
            String rowStr;
            String tableId = (String)message.getParam("table-id");
            String urlStr = (String)message.getParam("url");
            URL url = null;
            if (urlStr != null) {
                url = new URL(urlStr);
            }
            if ((rowStr = (String)message.getParam("row")) != null) {
                int row = Integer.parseInt(rowStr);
                this.tableHighlightRow(tableId, url, row);
            }
        } else if (TABLE_SELECT_ROW_LIST.equals(type)) {
            List rowList;
            String tableId = (String)message.getParam("table-id");
            String urlStr = (String)message.getParam("url");
            URL url = null;
            if (urlStr != null) {
                url = new URL(urlStr);
            }
            if ((rowList = (List)message.getParam("row-list")) != null) {
                this.tableSelectRowList(tableId, url, rowList);
            }
        } else if (COORDS_POINT_AT_SKY.equals(type)) {
            double ra = Double.parseDouble((String)message.getParam("ra"));
            double dec = Double.parseDouble((String)message.getParam("dec"));
            this.coordPointAtSky(ra, dec);
        }
        return null;
    }

    protected void tableLoadVotable(URL url, String tableId, String name) throws Exception {
        Navigator navigator = this._imageFrame.getNavigator();
        if (navigator != null) {
            VoCatalog catalog = new VoCatalog(VoTable.createVoTable(url, tableId, name));
            navigator.setQueryResult(catalog);
            navigator.setOrigURL(url);
            navigator.registerTable(url, tableId);
        }
    }

    protected void tableLoadFits(URL url, String tableId, String name) throws Exception {
        this.tableLoadVotable(url, tableId, name);
    }

    protected void imageLoadFits(URL url, String imageId, String name) throws Exception {
        DivaMainImageDisplay imageDisplay = this._imageFrame.getImageDisplayControl().getImageDisplay();
        imageDisplay.setURL(url);
    }

    protected void tableHighlightRow(String tableId, URL url, int row) throws Exception {
        Navigator navigator = this._imageFrame.getNavigator();
        if (navigator != null) {
            navigator.selectTableRows(tableId, url, new int[]{row});
        }
    }

    protected void tableSelectRowList(String tableId, URL url, List<String> rowList) throws Exception {
        Navigator navigator = this._imageFrame.getNavigator();
        if (navigator != null) {
            int[] rows = new int[rowList.size()];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = Integer.parseInt(rowList.get(i));
            }
            navigator.selectTableRows(tableId, url, rows);
        }
    }

    protected void coordPointAtSky(double ra, double dec) throws Exception {
        DivaMainImageDisplay imageDisplay = this._imageFrame.getImageDisplayControl().getImageDisplay();
        imageDisplay.loadCachedImage(ra, dec);
    }

    public void initTableMenu(JMenu menu) {
        this._initTableMenu(menu, null, null, new HashMap());
    }

    public void initTableMenu(JPopupMenu menu, URL url, String format, Map ucdMap) {
        this._initTableMenu(menu, url, format, ucdMap);
    }

    public void initTableMenu(JMenu menu, URL url, String format, Map ucdMap) {
        this._initTableMenu(menu, url, format, ucdMap);
    }

    private void _initTableMenu(JComponent menu, URL url, String format, Map ucdMap) {
        if (menu instanceof JMenu) {
            JMenu m = (JMenu)menu;
            m.add(this.getWindowAction());
            m.addSeparator();
        }
        final Navigator navigator = this._imageFrame.getNavigator();
        final TableSendActionManager man = new TableSendActionManager(navigator, this._connector, url, format, ucdMap);
        menu.add(man.createSendMenu());
        final JMenuItem broadCastItem = new JMenuItem("Broadcast Table");
        broadCastItem.setIcon(Resources.getIcon("broadcast.gif"));
        broadCastItem.addActionListener(man.getBroadcastAction());
        menu.add(broadCastItem);
        if (url == null) {
            man.setEnabled(false);
            broadCastItem.setEnabled(false);
            navigator.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    boolean enabled = navigator.getResultComponent() instanceof TableDisplayTool;
                    man.setEnabled(enabled);
                    broadCastItem.setEnabled(enabled);
                }
            });
        } else {
            man.setEnabled(true);
        }
        if (menu instanceof JMenu) {
            JMenu m = (JMenu)menu;
            m.addSeparator();
            JMenu transmitSelectedRowsMenu = this._makeTransmitSelectedRowsMenu();
            this._broadcastRowSelectionsMenuItem = this._makeBroadcastRowSelectionsMenuItem(transmitSelectedRowsMenu);
            m.add(this._broadcastRowSelectionsMenuItem);
            m.add(transmitSelectedRowsMenu);
        }
    }

    private JCheckBoxMenuItem _makeBroadcastRowSelectionsMenuItem(final JMenu transmitSelectedRowsMenu) {
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Broadcast Row Selections");
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                transmitSelectedRowsMenu.setEnabled(item.isSelected());
            }
        });
        return item;
    }

    private JMenu _makeTransmitSelectedRowsMenu() {
        final JMenu menu = new JMenu("Transmit Selected Rows to");
        this._tableSelectionSendManager = new SendManager(this._connector, TABLE_SELECT_ROW_LIST);
        final ComboBoxModel comboBoxModel = this._tableSelectionSendManager.getComboBoxModel();
        comboBoxModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                menu.removeAll();
                ButtonGroup group = new ButtonGroup();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    final Object o = comboBoxModel.getElementAt(i);
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(o.toString());
                    group.add(item);
                    if (o == comboBoxModel.getSelectedItem()) {
                        item.setSelected(true);
                    }
                    menu.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            comboBoxModel.setSelectedItem(o);
                        }
                    });
                }
            }
        });
        menu.setEnabled(false);
        return menu;
    }

    private Map _makeTransmitSelectedRowsMessage(List<Integer> rowList) {
        Navigator navigator = this._imageFrame.getNavigator();
        QueryResult queryResult = navigator.getQueryResult();
        if (queryResult instanceof TableQueryResult) {
            URL url;
            TableQueryResult table = (TableQueryResult)queryResult;
            String tableId = table.getId();
            String sampId = TableSendActionManager.getSampId(tableId);
            if (sampId != null) {
                tableId = sampId;
            }
            String urlStr = (url = navigator.getOrigURL()) != null ? url.toString() : null;
            Message msg = new Message(TABLE_SELECT_ROW_LIST);
            if (tableId != null) {
                msg.addParam("table-id", tableId);
            }
            if (urlStr != null) {
                msg.addParam("url", urlStr);
            }
            if (urlStr != null || tableId != null) {
                ArrayList<String> strRowList = new ArrayList<String>(rowList.size());
                for (Integer i : rowList) {
                    strRowList.add(i.toString());
                }
                msg.addParam("row-list", strRowList);
                msg.check();
                return msg;
            }
        }
        return null;
    }

    public void transmitSelectedRows(List<Integer> rowList) {
        if (this._processingMessage || !this._broadcastRowSelectionsMenuItem.isSelected()) {
            return;
        }
        Map map = this._makeTransmitSelectedRowsMessage(rowList);
        if (map != null) {
            try {
                this._tableSelectionSendManager.call(map);
            }
            catch (SampException e) {
                LOG.warning(e.toString());
            }
        }
    }

    public void initImageMenu(JMenu menu) {
        this._initImageMenu(menu, null);
    }

    public void initImageMenu(JPopupMenu menu, URL url) {
        this._initImageMenu(menu, url);
    }

    private void _initImageMenu(JComponent menu, URL url) {
        if (menu instanceof JMenu) {
            JMenu m = (JMenu)menu;
            m.add(this.getWindowAction());
            m.addSeparator();
        }
        final DivaMainImageDisplay imageDisplay = this._imageFrame.getImageDisplayControl().getImageDisplay();
        final ImageSendActionManager man = new ImageSendActionManager(imageDisplay, this._connector, url);
        menu.add(man.createSendMenu());
        final JMenuItem broadCastItem = new JMenuItem("Broadcast Image");
        broadCastItem.setIcon(Resources.getIcon("broadcast.gif"));
        broadCastItem.addActionListener(man.getBroadcastAction());
        menu.add(broadCastItem);
        if (url == null) {
            broadCastItem.setEnabled(false);
            man.setEnabled(false);
            imageDisplay.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ImageChangeEvent e = (ImageChangeEvent)changeEvent;
                    if (e.isNewImage() && !e.isBefore()) {
                        boolean enabled = imageDisplay.getURL() != null || imageDisplay.getFilename() != null;
                        man.setEnabled(enabled);
                        broadCastItem.setEnabled(enabled);
                    }
                }
            });
        } else {
            man.setEnabled(true);
        }
    }

    public Action getWindowAction() {
        if (this._windowAction == null) {
            Icon sampOffIcon = Resources.getIcon("samp.gif");
            Icon sampOnIcon = Resources.getIcon("sampgo.gif");
            this._windowAction = new WindowAction("SAMP Control", sampOffIcon, sampOnIcon);
        }
        return this._windowAction;
    }

    private class WindowAction
    extends AbstractAction
    implements ChangeListener {
        private JFrame sampFrame;
        private Icon offIcon;
        private Icon onIcon;

        WindowAction(String name, Icon offIcon, Icon onIcon) {
            super(name);
            this.sampFrame = null;
            this.offIcon = offIcon;
            this.onIcon = onIcon;
            this.putValue("ShortDescription", "Show SAMP Control Window (Application Interoperability)");
            SampHelper.this._connector.addConnectionListener(this);
            this.stateChanged(null);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.sampFrame == null) {
                this.sampFrame = new SampFrame(SampHelper.this._connector);
            }
            this.sampFrame.setVisible(true);
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.putValue("SmallIcon", SampHelper.this._connector.isConnected() ? this.onIcon : this.offIcon);
        }
    }
}

