/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import jsky.image.gui.ImageDisplayToolBar;
import jsky.navigator.NavigatorImageDisplay;
import jsky.util.I18N;
import jsky.util.Resources;

public class NavigatorImageDisplayToolBar
extends ImageDisplayToolBar {
    private static final I18N _I18N = I18N.getInstance(NavigatorImageDisplayToolBar.class);
    protected JButton catalogButton;
    protected JToggleButton gridButton;

    public NavigatorImageDisplayToolBar(NavigatorImageDisplay imageDisplay) {
        super(imageDisplay);
    }

    @Override
    protected void addToolBarItems() {
        super.addToolBarItems();
        this.addSeparator();
        this.add(this.makeCatalogButton());
        this.addSeparator();
        this.add(this.makeGridButton());
    }

    protected JButton makeCatalogButton() {
        if (this.catalogButton == null) {
            this.catalogButton = this.makeButton(((NavigatorImageDisplay)this.imageDisplay).getCatalogBrowseAction());
        }
        this.updateButton(this.catalogButton, _I18N.getString("catalogs"), Resources.getIcon("Catalog24.gif"));
        return this.catalogButton;
    }

    protected JToggleButton makeGridButton() {
        if (this.gridButton == null) {
            this.gridButton = this.makeToggleButton(((NavigatorImageDisplay)this.imageDisplay).getGridAction());
        }
        this.updateButton(this.gridButton, _I18N.getString("grid"), this.getGridIcon());
        return this.gridButton;
    }

    protected Icon getGridIcon() {
        return (Icon)((NavigatorImageDisplay)this.imageDisplay).getGridAction().getValue("SmallIcon");
    }

    @Override
    public void update() {
        super.update();
        this.makeCatalogButton();
        this.makeGridButton();
    }
}

