/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.text.DecimalFormat;
import jsky.science.MathUtilities;

public class FormatUtilities {
    public static void writeError(Object source, Object message) {
        System.err.println("[ERROR] " + source + ": " + message);
    }

    public static String formatDouble(double inVal, int inDecs) {
        return FormatUtilities.formatDouble(inVal, inDecs, 14, false);
    }

    public static String formatDouble(double inVal, int inDecs, int inLeftOfDec) {
        return FormatUtilities.formatDouble(inVal, inDecs, inLeftOfDec, false);
    }

    public static String formatDouble(double inVal, int inDecs, int inLeftOfDec, boolean recursing) {
        String returnVal = "";
        if (Double.isInfinite(inVal)) {
            returnVal = Double.toString(Double.POSITIVE_INFINITY);
        } else if (Double.isNaN(inVal)) {
            returnVal = Double.toString(Double.NaN);
        } else if (inVal == 0.0) {
            StringBuffer sb = new StringBuffer("0");
            if (inDecs > 0) {
                sb.append(".");
            }
            for (int i = 0; i < inDecs; ++i) {
                sb.append("0");
            }
            returnVal = sb.toString();
        } else {
            double adjVal;
            boolean doSN;
            inLeftOfDec = Math.max(inLeftOfDec, 1);
            int maxExp = inLeftOfDec - inDecs;
            if (inDecs == 0) {
                ++maxExp;
            }
            if (inVal < 0.0) {
                --maxExp;
            }
            int minExp = -inDecs;
            boolean bl = Math.abs(inVal) > Math.pow(10.0, maxExp) ? true : (doSN = Math.abs(inVal) < Math.pow(10.0, minExp));
            if (!doSN) {
                String ret = null;
                if (inDecs == 0) {
                    ret = Long.toString(Math.round(inVal));
                } else {
                    String formatPattern = "0.";
                    for (int i = 1; i <= inDecs; ++i) {
                        formatPattern = formatPattern + "0";
                    }
                    ret = new DecimalFormat(formatPattern).format((double)Math.round(inVal * Math.pow(10.0, inDecs)) / Math.pow(10.0, inDecs));
                    int dotLoc = ret.indexOf(".");
                    if (inDecs > 0 && dotLoc > 0) {
                        ret = ret.substring(0, Math.min(ret.length(), dotLoc + inDecs + 1));
                    }
                }
                return ret;
            }
            inLeftOfDec = Math.max(inLeftOfDec, 1);
            int sign = 1;
            if (inVal < 0.0) {
                sign = -1;
                inVal = -inVal;
            }
            int pow10 = 0;
            if (inVal != 0.0) {
                pow10 = (int)Math.floor(MathUtilities.log10(inVal));
            }
            returnVal = Double.isNaN(adjVal = (double)sign * inVal / Math.pow(10.0, pow10)) ? "NaN" : (recursing ? Double.toString(inVal) + "e" + Integer.toString(pow10) : FormatUtilities.formatDouble(adjVal, inDecs, inLeftOfDec, true) + "e" + Integer.toString(pow10));
        }
        return returnVal;
    }
}

