/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jsky.util.ResourceMap;

public final class Resources {
    public static final String RESOURCE_PATH = "";
    public static final String IMAGES_SUBPATH = "images";
    public static final String IMAGES_PATH = "/images/";
    public static final String CONFIG_SUBPATH = "conf";
    private static ResourceMap _rmap = new ResourceMap();

    private Resources() {
    }

    public static URL getResource(String resource) {
        String path = "/" + resource;
        return Resources.class.getResource(path);
    }

    public static InputStream getResourceAsStream(String resource) {
        String path = "/" + resource;
        return Resources.class.getResourceAsStream(path);
    }

    public static Icon getIcon(String iconFileName) {
        Icon icon = _rmap.getIcon(iconFileName);
        if (icon != null) {
            return icon;
        }
        URL url = Resources.getResource("images/" + iconFileName);
        if (url == null) {
            return null;
        }
        icon = new ImageIcon(url);
        _rmap.storeIcon(iconFileName, icon);
        return icon;
    }

    public static Icon getSystemIcon(String iconName) {
        Icon icon = _rmap.getIcon(iconName);
        if (icon != null) {
            return icon;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(iconName);
        return new ImageIcon(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String fileName) throws IOException {
        URL url = Resources.getResource("conf/" + fileName);
        if (url == null) {
            return null;
        }
        Properties props = null;
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(url.openStream());
            props = new Properties();
            props.load(bis);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }
}

