/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import jsky.util.gui.RangeSliderUI;

public class BasicRangeSliderUI
extends BasicSliderUI
implements RangeSliderUI {
    private static final int LABEL_OFFSET = 0;
    private static final int TICK_OFFSET = 10;
    protected Rectangle extRect = null;
    protected transient boolean isDraggingThumb = false;
    protected transient boolean isDraggingExtent = false;
    protected transient boolean showExtent = true;
    private static Rectangle unionExtRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new BasicRangeSliderUI((JSlider)c, true);
    }

    public BasicRangeSliderUI(JSlider b, boolean showe) {
        super(b);
        this.showExtent = showe;
    }

    @Override
    protected void calculateLabelRect() {
        this.labelRect = new Rectangle(this.trackRect);
        if (this.slider.getOrientation() == 0) {
            this.labelRect.height += 0;
            this.labelRect.y += 0;
        } else {
            this.labelRect.width += 0;
            this.labelRect.x += 0;
        }
    }

    @Override
    protected void calculateTickRect() {
        this.tickRect = new Rectangle(this.trackRect);
        if (this.slider.getOrientation() == 0) {
            this.tickRect.height += 10;
            this.tickRect.y += 10;
        } else {
            this.tickRect.width += 10;
            this.tickRect.x += 10;
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            d = new Dimension(this.getPreferredVerticalSize());
            d.width = this.insetCache.left + this.insetCache.right;
            d.width += this.focusInsets.left + this.focusInsets.right;
            d.width += Math.max(this.trackRect.width, Math.max(this.tickRect.width, this.labelRect.width));
        } else {
            d = new Dimension(this.getPreferredHorizontalSize());
            d.height = this.insetCache.top + this.insetCache.bottom;
            d.height += this.focusInsets.top + this.focusInsets.bottom;
            d.height += Math.max(this.trackRect.height, Math.max(this.tickRect.height, this.labelRect.height));
        }
        return d;
    }

    @Override
    public void installUI(JComponent c) {
        this.isDraggingExtent = false;
        this.isDraggingThumb = false;
        this.extRect = new Rectangle();
        super.installUI(c);
        if (this.insetCache == null) {
            this.insetCache = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.extRect = null;
        super.uninstallUI(c);
    }

    @Override
    protected void calculateGeometry() {
        super.calculateGeometry();
        this.calculateExtentSize();
        this.calculateExtentLocation();
    }

    protected void calculateExtentSize() {
        if (this.showExtent) {
            Dimension size = this.getExtentSize();
            this.extRect.setSize(size.width, size.height);
        } else {
            this.extRect.setSize(0, 0);
        }
    }

    protected Dimension getExtentSize() {
        return this.getThumbSize();
    }

    protected int getRangeRight() {
        return this.slider.getValue() + this.slider.getExtent();
    }

    protected void setRangeMax(int value) {
        int newExtent = value - this.slider.getValue();
        if (newExtent > 0) {
            this.slider.setExtent(newExtent);
        }
    }

    protected int getRangeLeft() {
        return this.slider.getValue();
    }

    protected void setRangeMin(int value) {
        if (this.showExtent) {
            int newExtent = this.slider.getValue() + this.slider.getExtent() - value;
            if (newExtent >= 0) {
                this.slider.setValue(value);
                this.slider.setExtent(newExtent);
            } else {
                this.slider.setExtent(0);
                this.slider.setValue(this.slider.getValue() + this.slider.getExtent());
            }
        } else {
            this.slider.setValue(value);
        }
    }

    protected void calculateExtentLocation() {
        int valuePosition;
        if (this.slider.getSnapToTicks()) {
            int extValue;
            int snappedValue = extValue = this.getRangeRight();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((extValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(extValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != extValue) {
                    this.setRangeMax(snappedValue);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            valuePosition = this.xPositionForValue(this.getRangeRight());
            this.extRect.x = valuePosition - this.extRect.width / 2;
            this.extRect.y = this.trackRect.y;
        } else {
            valuePosition = this.yPositionForValue(this.getRangeRight());
            this.extRect.x = this.trackRect.x;
            this.extRect.y = valuePosition - this.extRect.height / 2;
        }
    }

    @Override
    protected void calculateTrackBuffer() {
        super.calculateTrackBuffer();
        this.trackBuffer = this.slider.getOrientation() == 0 ? Math.max(this.trackBuffer, this.extRect.width / 2) : Math.max(this.trackBuffer, this.extRect.height / 2);
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() == 0) {
            this.trackRect.height = Math.max(this.trackRect.height, this.extRect.height);
        } else {
            this.trackRect.width = Math.max(this.trackRect.width, this.extRect.width);
        }
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(final JSlider slider) {
        return new BasicSliderUI.PropertyChangeHandler(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName.equals("model")) {
                    ((BoundedRangeModel)e.getOldValue()).removeChangeListener(BasicRangeSliderUI.this.changeListener);
                    ((BoundedRangeModel)e.getNewValue()).addChangeListener(BasicRangeSliderUI.this.changeListener);
                    BasicRangeSliderUI.this.calculateThumbLocation();
                    BasicRangeSliderUI.this.calculateExtentLocation();
                    slider.repaint();
                } else {
                    super.propertyChange(e);
                }
            }
        };
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Rectangle clip = g.getClipBounds();
        if (clip.intersects(this.extRect)) {
            this.paintExtent(g);
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        this.paintThumb(g, this.thumbRect, 0.0);
    }

    public void paintThumbLocal(Graphics g) {
        super.paintThumb(g);
    }

    public void paintExtent(Graphics g) {
        if (this.showExtent) {
            this.paintThumb(g, this.extRect, 0.0);
        }
    }

    public void paintThumb(Graphics g, Rectangle knobBounds, double theta) {
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(knobBounds.x, knobBounds.y);
        g2.rotate(theta, knobBounds.width / 2, knobBounds.height / 2);
        g2.translate(-knobBounds.x, -knobBounds.y);
        Rectangle holdRect = this.thumbRect;
        this.thumbRect = knobBounds;
        Composite holdComposite = g2.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.4f);
        g2.setComposite(ac);
        this.paintThumbLocal(g2);
        g2.setComposite(holdComposite);
        this.thumbRect = holdRect;
        g2.translate(knobBounds.x, knobBounds.y);
        g2.rotate(-theta, knobBounds.width / 2, knobBounds.height / 2);
        g2.translate(-knobBounds.x, -knobBounds.y);
    }

    public void setExtentLocation(int x, int y) {
        unionExtRect.setBounds(this.extRect);
        this.extRect.setLocation(x, y);
        SwingUtilities.computeUnion(this.extRect.x, this.extRect.y, this.extRect.width, this.extRect.height, unionExtRect);
        this.slider.repaint(BasicRangeSliderUI.unionExtRect.x, BasicRangeSliderUI.unionExtRect.y, BasicRangeSliderUI.unionExtRect.width, BasicRangeSliderUI.unionExtRect.height);
    }

    @Override
    protected ChangeListener createChangeListener(JSlider slider) {
        return new RangeSliderChangeListener();
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeSliderTrackListener();
    }

    @Override
    public boolean thumbContains(int x, int y) {
        return this.thumbRect.contains(x, y);
    }

    @Override
    public boolean extentContains(int x, int y) {
        return this.extRect.contains(x, y);
    }

    public class RangeSliderTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeSliderTrackListener() {
            super(BasicRangeSliderUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            BasicRangeSliderUI.this.isDraggingThumb = false;
            BasicRangeSliderUI.this.isDraggingExtent = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            BasicRangeSliderUI.this.slider.requestFocus();
            if (BasicRangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                switch (BasicRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.x;
                    }
                }
                BasicRangeSliderUI.this.isDraggingThumb = true;
                BasicRangeSliderUI.this.slider.setValueIsAdjusting(true);
            } else if (BasicRangeSliderUI.this.extRect.contains(this.currentMouseX, this.currentMouseY)) {
                switch (BasicRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - BasicRangeSliderUI.this.extRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - BasicRangeSliderUI.this.extRect.x;
                    }
                }
                BasicRangeSliderUI.this.isDraggingExtent = true;
                BasicRangeSliderUI.this.slider.setValueIsAdjusting(true);
            } else {
                BasicRangeSliderUI.this.isDraggingThumb = false;
                BasicRangeSliderUI.this.isDraggingExtent = false;
                BasicRangeSliderUI.this.slider.setValueIsAdjusting(true);
                Dimension sbSize = BasicRangeSliderUI.this.slider.getSize();
                boolean bl = true;
            }
        }

        public boolean shouldScroll(int direction, Rectangle r) {
            if (BasicRangeSliderUI.this.slider.getOrientation() == 1 ? ((BasicRangeSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? r.y + r.height <= this.currentMouseY : r.y >= this.currentMouseY) : ((BasicRangeSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? r.x + r.width >= this.currentMouseX : r.x <= this.currentMouseX)) {
                return false;
            }
            if (direction > 0 && BasicRangeSliderUI.this.getRangeLeft() + BasicRangeSliderUI.this.getRangeRight() >= BasicRangeSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return direction >= 0 || BasicRangeSliderUI.this.getRangeLeft() > BasicRangeSliderUI.this.slider.getMinimum();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (BasicRangeSliderUI.this.isDraggingThumb) {
                int thumbMiddle = 0;
                int extMiddle = 0;
                switch (BasicRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        int halfThumbHeight = ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.height / 2;
                        int thumbTop = e.getY() - this.offset;
                        int hardTop = ((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.y;
                        int hardBottom = ((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.y + (((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.height - 1);
                        thumbTop = Math.max(thumbTop, hardTop - halfThumbHeight);
                        thumbTop = Math.min(thumbTop, hardBottom - halfThumbHeight);
                        thumbMiddle = thumbTop + halfThumbHeight;
                        extMiddle = BasicRangeSliderUI.this.extRect.y + BasicRangeSliderUI.this.extRect.height / 2;
                        if (BasicRangeSliderUI.this.showExtent && extMiddle > thumbMiddle) {
                            thumbMiddle = extMiddle;
                            thumbTop = thumbMiddle - halfThumbHeight;
                        }
                        BasicRangeSliderUI.this.setRangeMin(BasicRangeSliderUI.this.valueForYPosition(thumbMiddle));
                        BasicRangeSliderUI.this.setThumbLocation(((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.x, thumbTop);
                        break;
                    }
                    case 0: {
                        int halfThumbWidth = ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.width / 2;
                        int thumbLeft = e.getX() - this.offset;
                        int hardLeft = ((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.x;
                        int hardRight = ((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.x + (((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.width - 1);
                        thumbLeft = Math.max(thumbLeft, hardLeft - halfThumbWidth);
                        thumbLeft = Math.min(thumbLeft, hardRight - halfThumbWidth);
                        thumbMiddle = thumbLeft + halfThumbWidth;
                        extMiddle = BasicRangeSliderUI.this.extRect.x + BasicRangeSliderUI.this.extRect.width / 2;
                        if (BasicRangeSliderUI.this.showExtent && extMiddle < thumbMiddle) {
                            thumbMiddle = extMiddle;
                            thumbLeft = thumbMiddle - halfThumbWidth;
                        }
                        BasicRangeSliderUI.this.setRangeMin(BasicRangeSliderUI.this.valueForXPosition(thumbMiddle));
                        BasicRangeSliderUI.this.setThumbLocation(thumbLeft, ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.y);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            } else if (BasicRangeSliderUI.this.isDraggingExtent) {
                int extMiddle = 0;
                int thumbMiddle = 0;
                switch (BasicRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        int halfThumbHeight = BasicRangeSliderUI.this.extRect.height / 2;
                        int extTop = e.getY() - this.offset;
                        int trackTop = ((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.y;
                        int trackBottom = ((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.y + (((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.height - 1);
                        extTop = Math.max(extTop, trackTop - halfThumbHeight);
                        extTop = Math.min(extTop, trackBottom - halfThumbHeight);
                        extMiddle = extTop + halfThumbHeight;
                        thumbMiddle = ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.y + ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.height / 2;
                        if (thumbMiddle < extMiddle) {
                            extMiddle = thumbMiddle;
                            extTop = extMiddle - halfThumbHeight;
                        }
                        BasicRangeSliderUI.this.setExtentLocation(BasicRangeSliderUI.this.extRect.x, extTop);
                        BasicRangeSliderUI.this.setRangeMax(BasicRangeSliderUI.this.valueForYPosition(extMiddle));
                        break;
                    }
                    case 0: {
                        int halfThumbWidth = BasicRangeSliderUI.this.extRect.width / 2;
                        int extLeft = e.getX() - this.offset;
                        int trackLeft = ((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.x;
                        int trackRight = ((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.x + (((BasicRangeSliderUI)BasicRangeSliderUI.this).trackRect.width - 1);
                        extLeft = Math.max(extLeft, trackLeft - halfThumbWidth);
                        extLeft = Math.min(extLeft, trackRight - halfThumbWidth);
                        extMiddle = extLeft + halfThumbWidth;
                        thumbMiddle = ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.x + ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.width / 2;
                        if (thumbMiddle > extMiddle) {
                            extMiddle = thumbMiddle;
                            extLeft = extMiddle - halfThumbWidth;
                        }
                        BasicRangeSliderUI.this.setRangeMax(BasicRangeSliderUI.this.valueForXPosition(extMiddle));
                        BasicRangeSliderUI.this.setExtentLocation(extLeft, BasicRangeSliderUI.this.extRect.y);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }

    public class RangeSliderChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            if (!BasicRangeSliderUI.this.isDraggingThumb) {
                BasicRangeSliderUI.this.calculateThumbLocation();
                BasicRangeSliderUI.this.slider.repaint();
            }
            if (!BasicRangeSliderUI.this.isDraggingExtent) {
                BasicRangeSliderUI.this.calculateExtentLocation();
                BasicRangeSliderUI.this.slider.repaint();
            }
        }
    }
}

