/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import jsky.util.I18N;
import jsky.util.Resources;
import jsky.util.gui.GenericToolBarTarget;

public class GenericToolBar
extends JToolBar {
    private static final I18N _I18N = I18N.getInstance(GenericToolBar.class);
    protected GenericToolBarTarget target;
    protected JButton openButton;
    protected JButton backButton;
    protected JButton forwardButton;
    protected boolean showPictures = true;
    protected boolean showText = true;

    public GenericToolBar(GenericToolBarTarget target, boolean addItems, int orientation) {
        super(orientation);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setFloatable(false);
        if (target != null) {
            target.getBackAction().setEnabled(false);
            target.getForwAction().setEnabled(false);
            this.target = target;
        }
        if (addItems) {
            this.addToolBarItems();
        }
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), this.getBorder()));
    }

    public GenericToolBar(GenericToolBarTarget target, boolean addItems) {
        this(target, addItems, 0);
    }

    public GenericToolBar(GenericToolBarTarget target) {
        this(target, true);
    }

    public GenericToolBar() {
        this(null, true);
    }

    protected void addToolBarItems() {
        this.add(this.makeBackButton());
        this.add(this.makeForwardButton());
        this.addSeparator();
        this.add(this.makeOpenButton());
    }

    protected AbstractButton setupButton(AbstractButton button) {
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        return button;
    }

    protected JButton makeOpenButton() {
        if (this.openButton == null) {
            this.openButton = this.makeButton(this.target.getOpenAction());
        }
        this.updateButton(this.openButton, _I18N.getString("open"), Resources.getIcon("Open24.gif"));
        this.target.getOpenAction().setEnabled(true);
        return this.openButton;
    }

    protected JButton makeBackButton() {
        if (this.backButton == null) {
            this.backButton = this.makeButton(this.target.getBackAction());
        }
        if (!this.showPictures || !this.showText) {
            this.backButton.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.backButton.putClientProperty("JButton.segmentPosition", "first");
            this.backButton.setFocusable(false);
        } else {
            this.backButton.putClientProperty("JButton.buttonType", null);
            this.backButton.putClientProperty("JButton.segmentPosition", null);
            this.backButton.setFocusable(true);
        }
        if (!this.showText && "Mac OS X".equals(UIManager.getLookAndFeel().getName())) {
            this.updateButton(this.backButton, _I18N.getString("back"), Resources.getSystemIcon("NSImage://NSGoLeftTemplate"));
        } else {
            this.updateButton(this.backButton, _I18N.getString("back"), Resources.getIcon("Back24.gif"));
        }
        return this.backButton;
    }

    protected JButton makeForwardButton() {
        if (this.forwardButton == null) {
            this.forwardButton = this.makeButton(this.target.getForwAction());
        }
        if (!this.showPictures || !this.showText) {
            this.forwardButton.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.forwardButton.putClientProperty("JButton.segmentPosition", "last");
            this.forwardButton.setFocusable(false);
        } else {
            this.forwardButton.putClientProperty("JButton.buttonType", null);
            this.forwardButton.putClientProperty("JButton.segmentPosition", null);
            this.forwardButton.setFocusable(true);
        }
        if (!this.showText && "Mac OS X".equals(UIManager.getLookAndFeel().getName())) {
            this.updateButton(this.forwardButton, _I18N.getString("forward"), Resources.getSystemIcon("NSImage://NSGoRightTemplate"));
        } else {
            this.updateButton(this.forwardButton, _I18N.getString("forward"), Resources.getIcon("Forward24.gif"));
        }
        return this.forwardButton;
    }

    protected JButton makeButton(Action action) {
        JButton button = new JButton(action);
        this.setupButton(button);
        return button;
    }

    protected JToggleButton makeToggleButton(Action action) {
        JToggleButton button = new JToggleButton(action);
        this.setupButton(button);
        return button;
    }

    protected JButton makeMenuButton(String toolTip, final JPopupMenu menu) {
        JButton button = this.makeButton(null);
        button.setToolTipText(toolTip);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Component c = e.getComponent();
                menu.show(c, 0, c.getHeight());
            }
        });
        return button;
    }

    protected void updateButton(AbstractButton button, String text, Icon icon) {
        if (this.showText) {
            button.setText(text);
        } else {
            button.setText(null);
        }
        button.setAlignmentX(0.5f);
        if (this.showPictures) {
            button.setIcon(icon);
        } else {
            button.setIcon(null);
        }
    }

    public void setShowPictures(boolean b) {
        this.showPictures = b;
        this.update();
    }

    public void setShowText(boolean b) {
        this.showText = b;
        this.update();
    }

    public void update() {
        this.makeOpenButton();
        this.makeBackButton();
        this.makeForwardButton();
    }

    public JButton getOpenButton() {
        return this.openButton;
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    public JButton getForwardButton() {
        return this.forwardButton;
    }

    protected class ButtonPropertyChangeListener
    implements PropertyChangeListener {
        AbstractButton button;

        public ButtonPropertyChangeListener(AbstractButton button) {
            this.button = button;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("enabled")) {
                this.button.setEnabled((Boolean)e.getNewValue());
            }
        }
    }
}

