/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class JTextAreaCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final int ROW_PAD = 3;
    protected static Border noFocusBorder = new EmptyBorder(3, 3, 3, 3);
    protected static Border focusBorder = new CompoundBorder(UIManager.getBorder("Table.focusCellHighlightBorder"), new EmptyBorder(2, 2, 2, 2));
    private Color unselectedForeground;
    private Color unselectedBackground;

    public JTextAreaCellRenderer() {
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(focusBorder);
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setText(value == null ? "" : value.toString());
        this._updateRowHeight(row, column, table);
        return this;
    }

    private void _updateRowHeight(int row, int column, JTable table) {
        if (row < 0 || column < 0) {
            return;
        }
        int tableColWidth = table.getColumnModel().getColumn(column).getWidth();
        Dimension d = this.getPreferredSize();
        if (d.width != tableColWidth) {
            this.setSize(new Dimension(tableColWidth, 1000));
            d = this.getPreferredSize();
        }
        int tableRowHeight = table.getRowHeight(row);
        int defaultTableRowHeight = table.getRowHeight();
        if (d.height < defaultTableRowHeight) {
            d.height = defaultTableRowHeight;
        }
        if (d.height + 3 != tableRowHeight) {
            table.setRowHeight(row, d.height + 3);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public static class UIResource
    extends DefaultTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

