/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.timings;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.timings.CorrelatorType;
import alma.observatorycharacteristics.timings.DivisionModeType;
import alma.observatorycharacteristics.timings.SchedBlockTimingsXMLReader;
import alma.observatorycharacteristics.timings.Time;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.JAXBException;
import lombok.NonNull;

public class SchedBlockTimingExpert {
    private final CorrelatorType correlatorType;
    private final DivisionModeType divisionMode;
    private final Optional<Boolean> isFullPolarization;
    private final Optional<Boolean> isHighDataRate;
    private final Optional<Boolean> isLongBaseline;
    private final Optional<Boolean> isWalshEnabled;
    private final Optional<Boolean> isVLBI;
    private final Optional<Boolean> isSingleContinuumFDMHiRes;
    @NonNull
    private final SchedBlockTimingsXMLReader schedBlockTimingDatabase = SchedBlockTimingsXMLReader.getInstance();

    private static alma.valuetypes.Time getTime(@NonNull Time time) {
        if (time == null) {
            throw new NullPointerException("xmlTime is marked non-null but is null");
        }
        return alma.valuetypes.Time.createTime((double)time.getValue(), (String)time.getUnit().value());
    }

    public CorrelatorTimings findCorrelatorTimings() throws JAXBException, SchedBlockTimingsXMLReader.InvalidOTCOnfigurationException, UnableToDetermineTimingsException {
        List<alma.observatorycharacteristics.timings.CorrelatorTimings> list = this.schedBlockTimingDatabase.getSBTimingInformation().getCorrelatorTimings().stream().filter(correlatorTimings -> correlatorTimings.getCorrelator().equals((Object)this.correlatorType) && correlatorTimings.getDivisionMode().equals((Object)this.divisionMode)).toList();
        if (this.isFullPolarization.isPresent()) {
            list = list.stream().filter(correlatorTimings -> Objects.equals(correlatorTimings.isIsFullPolarization(), this.isFullPolarization.get())).toList();
        }
        if (this.isHighDataRate.isPresent()) {
            list = list.stream().filter(correlatorTimings -> Objects.equals(correlatorTimings.isIsHighDataRate(), this.isHighDataRate.get())).toList();
        }
        if (this.isSingleContinuumFDMHiRes.isPresent()) {
            list = list.stream().filter(correlatorTimings -> Objects.equals(correlatorTimings.isIsSingleContinuumFDM(), this.isSingleContinuumFDMHiRes.get())).toList();
        }
        if (this.isWalshEnabled.isPresent()) {
            list = list.stream().filter(correlatorTimings -> Objects.equals(correlatorTimings.isIsWalshEnabled(), this.isWalshEnabled.get())).toList();
        }
        if (this.isLongBaseline.isPresent()) {
            list = list.stream().filter(correlatorTimings -> Objects.equals(correlatorTimings.isIsLongBaseline(), this.isLongBaseline.get())).toList();
        }
        if (this.isVLBI.isPresent()) {
            list = list.stream().filter(correlatorTimings -> Objects.equals(correlatorTimings.isIsVLBI(), this.isVLBI.get())).toList();
        }
        if (list.isEmpty()) {
            Log.logger(SchedBlockTimingExpert.class).warning("No SB correlator timing information found: " + String.valueOf((Object)this.correlatorType) + " " + String.valueOf((Object)this.divisionMode) + " isFullPolarization " + this.isFullPolarization.isPresent() + " isHighDataRate " + this.isHighDataRate.isPresent() + " isSingleContinuumFDMHiRes " + this.isSingleContinuumFDMHiRes.isPresent() + " isWalshEnabled " + this.isWalshEnabled.isPresent() + " isLongBaseline " + this.isLongBaseline.isPresent() + " isVLBI " + this.isVLBI.isPresent());
            throw new UnableToDetermineTimingsException("No timing information found for the given search parameters");
        }
        if (list.size() != 1) {
            Log.logger(SchedBlockTimingExpert.class).warning("No SB correlator timing information found: " + String.valueOf((Object)this.correlatorType) + " " + String.valueOf((Object)this.divisionMode) + " isFullPolarization " + this.isFullPolarization.isPresent() + " isHighDataRate " + this.isHighDataRate.isPresent() + " isSingleContinuumFDMHiRes " + this.isSingleContinuumFDMHiRes.isPresent() + " isWalshEnabled " + this.isWalshEnabled.isPresent() + " isLongBaseline " + this.isLongBaseline.isPresent() + " isVLBI " + this.isVLBI.isPresent());
            throw new UnableToDetermineTimingsException("More than one timing found for the given search parameters");
        }
        alma.observatorycharacteristics.timings.CorrelatorTimings correlatorTimings2 = list.get(0);
        Log.logger(SchedBlockTimingExpert.class).fine("Timing information from coming timing index : " + correlatorTimings2.getTimingIndex());
        return new CorrelatorTimings(SchedBlockTimingExpert.getTime(correlatorTimings2.getIntegrationDuration()), SchedBlockTimingExpert.getTime(correlatorTimings2.getChannelAverageDuration()), SchedBlockTimingExpert.getTime(correlatorTimings2.getDumpDuration()));
    }

    private static Optional<Boolean> $default$isFullPolarization() {
        return Optional.empty();
    }

    private static Optional<Boolean> $default$isHighDataRate() {
        return Optional.empty();
    }

    private static Optional<Boolean> $default$isLongBaseline() {
        return Optional.empty();
    }

    private static Optional<Boolean> $default$isWalshEnabled() {
        return Optional.empty();
    }

    private static Optional<Boolean> $default$isVLBI() {
        return Optional.empty();
    }

    private static Optional<Boolean> $default$isSingleContinuumFDMHiRes() {
        return Optional.empty();
    }

    SchedBlockTimingExpert(CorrelatorType correlatorType, DivisionModeType divisionModeType, Optional<Boolean> optional, Optional<Boolean> optional2, Optional<Boolean> optional3, Optional<Boolean> optional4, Optional<Boolean> optional5, Optional<Boolean> optional6) {
        this.correlatorType = correlatorType;
        this.divisionMode = divisionModeType;
        this.isFullPolarization = optional;
        this.isHighDataRate = optional2;
        this.isLongBaseline = optional3;
        this.isWalshEnabled = optional4;
        this.isVLBI = optional5;
        this.isSingleContinuumFDMHiRes = optional6;
    }

    public static SchedBlockTimingExpertBuilder builder() {
        return new SchedBlockTimingExpertBuilder();
    }

    public class UnableToDetermineTimingsException
    extends Exception {
        public UnableToDetermineTimingsException(String string) {
            super(string);
        }
    }

    public record CorrelatorTimings(alma.valuetypes.Time integrationDuration, alma.valuetypes.Time channelAverage, alma.valuetypes.Time dumpDuration) {
    }

    public static class SchedBlockTimingExpertBuilder {
        private CorrelatorType correlatorType;
        private DivisionModeType divisionMode;
        private boolean isFullPolarization$set;
        private Optional<Boolean> isFullPolarization$value;
        private boolean isHighDataRate$set;
        private Optional<Boolean> isHighDataRate$value;
        private boolean isLongBaseline$set;
        private Optional<Boolean> isLongBaseline$value;
        private boolean isWalshEnabled$set;
        private Optional<Boolean> isWalshEnabled$value;
        private boolean isVLBI$set;
        private Optional<Boolean> isVLBI$value;
        private boolean isSingleContinuumFDMHiRes$set;
        private Optional<Boolean> isSingleContinuumFDMHiRes$value;

        SchedBlockTimingExpertBuilder() {
        }

        public SchedBlockTimingExpertBuilder correlatorType(CorrelatorType correlatorType) {
            this.correlatorType = correlatorType;
            return this;
        }

        public SchedBlockTimingExpertBuilder divisionMode(DivisionModeType divisionModeType) {
            this.divisionMode = divisionModeType;
            return this;
        }

        public SchedBlockTimingExpertBuilder isFullPolarization(Optional<Boolean> optional) {
            this.isFullPolarization$value = optional;
            this.isFullPolarization$set = true;
            return this;
        }

        public SchedBlockTimingExpertBuilder isHighDataRate(Optional<Boolean> optional) {
            this.isHighDataRate$value = optional;
            this.isHighDataRate$set = true;
            return this;
        }

        public SchedBlockTimingExpertBuilder isLongBaseline(Optional<Boolean> optional) {
            this.isLongBaseline$value = optional;
            this.isLongBaseline$set = true;
            return this;
        }

        public SchedBlockTimingExpertBuilder isWalshEnabled(Optional<Boolean> optional) {
            this.isWalshEnabled$value = optional;
            this.isWalshEnabled$set = true;
            return this;
        }

        public SchedBlockTimingExpertBuilder isVLBI(Optional<Boolean> optional) {
            this.isVLBI$value = optional;
            this.isVLBI$set = true;
            return this;
        }

        public SchedBlockTimingExpertBuilder isSingleContinuumFDMHiRes(Optional<Boolean> optional) {
            this.isSingleContinuumFDMHiRes$value = optional;
            this.isSingleContinuumFDMHiRes$set = true;
            return this;
        }

        public SchedBlockTimingExpert build() {
            Optional<Boolean> optional = this.isFullPolarization$value;
            if (!this.isFullPolarization$set) {
                optional = SchedBlockTimingExpert.$default$isFullPolarization();
            }
            Optional<Boolean> optional2 = this.isHighDataRate$value;
            if (!this.isHighDataRate$set) {
                optional2 = SchedBlockTimingExpert.$default$isHighDataRate();
            }
            Optional<Boolean> optional3 = this.isLongBaseline$value;
            if (!this.isLongBaseline$set) {
                optional3 = SchedBlockTimingExpert.$default$isLongBaseline();
            }
            Optional<Boolean> optional4 = this.isWalshEnabled$value;
            if (!this.isWalshEnabled$set) {
                optional4 = SchedBlockTimingExpert.$default$isWalshEnabled();
            }
            Optional<Boolean> optional5 = this.isVLBI$value;
            if (!this.isVLBI$set) {
                optional5 = SchedBlockTimingExpert.$default$isVLBI();
            }
            Optional<Boolean> optional6 = this.isSingleContinuumFDMHiRes$value;
            if (!this.isSingleContinuumFDMHiRes$set) {
                optional6 = SchedBlockTimingExpert.$default$isSingleContinuumFDMHiRes();
            }
            return new SchedBlockTimingExpert(this.correlatorType, this.divisionMode, optional, optional2, optional3, optional4, optional5, optional6);
        }

        public String toString() {
            return "SchedBlockTimingExpert.SchedBlockTimingExpertBuilder(correlatorType=" + String.valueOf((Object)this.correlatorType) + ", divisionMode=" + String.valueOf((Object)this.divisionMode) + ", isFullPolarization$value=" + String.valueOf(this.isFullPolarization$value) + ", isHighDataRate$value=" + String.valueOf(this.isHighDataRate$value) + ", isLongBaseline$value=" + String.valueOf(this.isLongBaseline$value) + ", isWalshEnabled$value=" + String.valueOf(this.isWalshEnabled$value) + ", isVLBI$value=" + String.valueOf(this.isVLBI$value) + ", isSingleContinuumFDMHiRes$value=" + String.valueOf(this.isSingleContinuumFDMHiRes$value) + ")";
        }
    }
}

