/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class BOPropertyDescriptor
extends PropertyDescriptor {
    private PropertyDescriptor pdesc = null;
    private Method adder = null;
    private Method indexedReadMethod = null;
    private Method indexedWriteMethod = null;
    private Method remover = null;
    private Class<?> boClass = null;

    public BOPropertyDescriptor(IndexedPropertyDescriptor indexedPropertyDescriptor) throws IntrospectionException {
        this((PropertyDescriptor)indexedPropertyDescriptor);
        this.indexedReadMethod = indexedPropertyDescriptor.getIndexedReadMethod();
        this.indexedWriteMethod = indexedPropertyDescriptor.getIndexedWriteMethod();
        this.adder = this.findAddMethod();
        this.remover = this.findRemoveMethod();
    }

    public BOPropertyDescriptor(PropertyDescriptor propertyDescriptor) throws IntrospectionException {
        this(propertyDescriptor.getName(), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod());
        this.pdesc = propertyDescriptor;
    }

    private BOPropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        super(string, method, method2);
        this.boClass = method.getDeclaringClass();
    }

    public boolean isIndexed() {
        return this.pdesc instanceof IndexedPropertyDescriptor;
    }

    public boolean isArray() {
        return this.getPropertyType().isArray();
    }

    public boolean isPrimitive() {
        return this.getPropertyType().isPrimitive();
    }

    public boolean isSimple() {
        Class<?> clazz = this.getPropertyType();
        return clazz.isPrimitive() || clazz == String.class;
    }

    public boolean isBusinessObject() {
        Class<?> clazz = this.getPropertyType();
        return BusinessObject.class.isAssignableFrom(clazz);
    }

    Method findAddMethod() {
        Method[] methodArray = this.boClass.getMethods();
        String string = BOPropertyDescriptor.makeMethodName("add", this.getName());
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?> clazz;
            Class<?>[] classArray;
            Method method = methodArray[i];
            if (!method.getName().equals(string) || (classArray = method.getParameterTypes()).length != 2 || !classArray[0].equals(Integer.TYPE) || !classArray[1].equals(clazz = this.getPropertyType())) continue;
            return method;
        }
        return null;
    }

    Method findRemoveMethod() {
        Method[] methodArray = this.boClass.getMethods();
        String string = BOPropertyDescriptor.makeMethodName("remove", this.getName());
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?> clazz;
            Class<?>[] classArray;
            Method method = methodArray[i];
            if (!method.getName().equals(string) || (classArray = method.getParameterTypes()).length != 1 || !classArray[0].equals(clazz = this.getPropertyType())) continue;
            return method;
        }
        return null;
    }

    static String makeMethodName(String string, String string2) {
        char c = Character.toUpperCase(string2.charAt(0));
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(c);
        stringBuilder.append(string2.substring(1));
        return stringBuilder.toString();
    }

    @Override
    public Class<?> getPropertyType() {
        Class<?> clazz = super.getPropertyType();
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        return clazz;
    }

    @Override
    public String toString() {
        return "property[" + this.getName() + "]";
    }

    public Method getAdder() {
        return this.adder;
    }

    public Method getIndexedReadMethod() {
        return this.indexedReadMethod;
    }

    public Method getIndexedWriteMethod() {
        return this.indexedWriteMethod;
    }

    public Method getRemover() {
        return this.remover;
    }
}

