/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.enumerations;

import alma.entity.xmlbinding.obsproject.types.AdvancedWindowSetupTSmoothingFunctionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum SpectralAverage {
    SPEC_AVERAGE_FACTOR_1(1, 1.0),
    SPEC_AVERAGE_FACTOR_2(2, 2.0),
    SPEC_AVERAGE_FACTOR_4(4, 4.0),
    SPEC_AVERAGE_FACTOR_8(8, 8.0),
    SPEC_AVERAGE_FACTOR_16(16, 16.0);

    private static Map<Integer, Map<String, Double>> spectralResolutionFactors;
    private Double dataRateScalingFactor;
    private Integer spectralAveragingFactor;
    private static String[] labels;

    private SpectralAverage(Integer n2, Double d) {
        this.spectralAveragingFactor = n2;
        this.dataRateScalingFactor = d;
    }

    public Double getResolutionScalingFactor(String string) throws UnknownWindowingFunctionException {
        if (spectralResolutionFactors.get(this.spectralAveragingFactor).get(string) == null) {
            throw new UnknownWindowingFunctionException("Unknown windowing function " + string);
        }
        return spectralResolutionFactors.get(this.spectralAveragingFactor).get(string);
    }

    public String getLabel() {
        return this.getSpectralAveragingFactor().toString();
    }

    public static String[] getLabels() {
        if (labels == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SpectralAverage spectralAverage : SpectralAverage.values()) {
                arrayList.add(spectralAverage.getSpectralAveragingFactor().toString());
            }
            labels = arrayList.toArray(new String[arrayList.size()]);
        }
        return labels;
    }

    public static SpectralAverage getValue(Integer n) {
        for (SpectralAverage spectralAverage : SpectralAverage.values()) {
            if (!spectralAverage.spectralAveragingFactor.equals(n)) continue;
            return spectralAverage;
        }
        return null;
    }

    public static SpectralAverage getValue(String string) {
        Integer n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return SpectralAverage.getValue(n);
    }

    public Double getDataRateScalingFactor() {
        return this.dataRateScalingFactor;
    }

    public Integer getSpectralAveragingFactor() {
        return this.spectralAveragingFactor;
    }

    static {
        spectralResolutionFactors = new HashMap<Integer, Map<String, Double>>();
        final String string = AdvancedWindowSetupTSmoothingFunctionType.HANNING.toString();
        final String string2 = AdvancedWindowSetupTSmoothingFunctionType.UNIFORM.toString();
        final String string3 = AdvancedWindowSetupTSmoothingFunctionType.WELCH.toString();
        final String string4 = AdvancedWindowSetupTSmoothingFunctionType.HAMMING.toString();
        final String string5 = AdvancedWindowSetupTSmoothingFunctionType.BARTLETT.toString();
        final String string6 = AdvancedWindowSetupTSmoothingFunctionType.BLACKMANN.toString();
        final String string7 = AdvancedWindowSetupTSmoothingFunctionType.BLACKMANN_HARRIS.toString();
        spectralResolutionFactors.put(1, (Map<String, Double>)new HashMap<String, Double>(){
            {
                this.put(string, 2.0);
                this.put(string2, 1.207);
                this.put(string3, 1.59);
                this.put(string4, 1.815);
                this.put(string5, 1.772);
                this.put(string6, 2.299);
                this.put(string7, 2.666);
            }
        });
        spectralResolutionFactors.put(2, (Map<String, Double>)new HashMap<String, Double>(){
            {
                this.put(string, 2.312);
                this.put(string2, 1.639);
                this.put(string3, 1.952);
            }
        });
        spectralResolutionFactors.put(4, (Map<String, Double>)new HashMap<String, Double>(){
            {
                this.put(string, 4.0);
                this.put(string2, 4.063);
                this.put(string3, 4.007);
            }
        });
        spectralResolutionFactors.put(8, (Map<String, Double>)new HashMap<String, Double>(){
            {
                this.put(string, 8.0);
                this.put(string2, 8.033);
                this.put(string3, 8.001);
            }
        });
        spectralResolutionFactors.put(16, (Map<String, Double>)new HashMap<String, Double>(){
            {
                this.put(string, 16.0);
                this.put(string2, 16.017);
                this.put(string3, 16.0);
            }
        });
        Collections.unmodifiableMap(spectralResolutionFactors);
    }

    public static class UnknownWindowingFunctionException
    extends Exception {
        UnknownWindowingFunctionException(String string) {
            super(string);
        }
    }
}

