/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.common.calibratorCatalogue.calQueryParameters.types.CalibrationUseType;
import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.obsprep.bo.obsproject.ICalibratorExpertDocument;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;

public class QuerySourceAdapter
implements ICalibratorExpertDocument {
    private String sourceName = null;
    private IQuerySource querySourceAdaptee;
    private final List<Measurement> measurements = new ArrayList<Measurement>();
    private CalibratorExpert.SourceCatalog catalog;

    public QuerySourceAdapter(@NonNull IQuerySource iQuerySource) {
        if (iQuerySource == null) {
            throw new NullPointerException("adaptee is marked non-null but is null");
        }
        this.querySourceAdaptee = iQuerySource;
        String[] stringArray = CalibratorExpert.SourceCatalog.getNames();
        if (stringArray.length > 0) {
            this.catalog = CalibratorExpert.SourceCatalog.byName(stringArray[0]);
        }
    }

    public void setAdaptee(IQuerySource iQuerySource) {
        this.querySourceAdaptee = iQuerySource;
        this.measurements.clear();
    }

    @Override
    public CalibrationUseType getCalType() {
        String string = this.querySourceAdaptee.getUse();
        if (string != null) {
            return CalibrationUseType.valueOf((String)string);
        }
        return null;
    }

    @Override
    public List<Measurement> getCalibList() {
        return this.measurements;
    }

    @Override
    public String getCatalogueLocation() {
        return this.catalog.getName();
    }

    @Override
    public int getDec() {
        SkyCoordinates skyCoordinates = this.querySourceAdaptee.getQueryCenter();
        double d = skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_ARCSEC);
        return (int)(d * 1000.0);
    }

    @Override
    public Date getEarliestObservation() {
        Time time = this.querySourceAdaptee.getMaxTimeSinceObserved();
        if (time.getContent() == 0.0) {
            return null;
        }
        long l = Calendar.getInstance().getTime().getTime();
        Date date = QuerySourceAdapter.convertToDate(time);
        long l2 = date.getTime();
        return new Date(l - l2);
    }

    @Override
    public Date getLatestObservation() {
        Time time = this.querySourceAdaptee.getMinTimeSinceObserved();
        if (time.getContent() == 0.0) {
            return null;
        }
        long l = Calendar.getInstance().getTime().getTime();
        Date date = QuerySourceAdapter.convertToDate(time);
        long l2 = date.getTime();
        return new Date(l - l2);
    }

    @Override
    public Flux getMaxFlux() {
        return this.querySourceAdaptee.getMaxFlux();
    }

    @Override
    public Frequency getMaxFrequency() {
        return this.querySourceAdaptee.getMaxFrequency();
    }

    @Override
    public Flux getMinFlux() {
        return this.querySourceAdaptee.getMinFlux();
    }

    @Override
    public Frequency getMinFrequency() {
        return this.querySourceAdaptee.getMinFrequency();
    }

    @Override
    public CatalogQueryParameters getQuery() {
        CatalogQueryParameters catalogQueryParameters = new CatalogQueryParameters();
        catalogQueryParameters.setMaxSources(this.getMaxSources());
        if (!StringUtils.isEmpty((String)this.sourceName)) {
            catalogQueryParameters.setName(this.getSourceName());
            return catalogQueryParameters;
        }
        if (this.getRadius() > 0.0) {
            catalogQueryParameters.setRightAscension((double)this.getRa() / 3.6E7);
            catalogQueryParameters.setDeclination((double)this.getDec() / 3600000.0);
            catalogQueryParameters.setRadius(this.getRadius());
        } else {
            catalogQueryParameters.deleteRightAscension();
            catalogQueryParameters.deleteDeclination();
            catalogQueryParameters.deleteRadius();
        }
        if (this.getMinFlux().getContent() > 0.0) {
            catalogQueryParameters.setMinFlux(QuerySourceAdapter.convertToJy(this.getMinFlux()));
        } else {
            catalogQueryParameters.deleteMinFlux();
        }
        if (this.getMaxFlux().getContent() > 0.0) {
            catalogQueryParameters.setMaxFlux(QuerySourceAdapter.convertToJy(this.getMaxFlux()));
        } else {
            catalogQueryParameters.deleteMaxFlux();
        }
        if (this.getMinFrequency().getContent() > 0.0) {
            catalogQueryParameters.setMinFrequency(this.getMinFrequency().getContentInUnits(Frequency.UNIT_GHZ));
        } else {
            catalogQueryParameters.deleteMinFrequency();
        }
        if (this.getMaxFrequency().getContent() > 0.0) {
            catalogQueryParameters.setMaxFrequency(this.getMaxFrequency().getContentInUnits(Frequency.UNIT_GHZ));
        } else {
            catalogQueryParameters.deleteMaxFrequency();
        }
        catalogQueryParameters.setEarliestObservation(this.getEarliestObservation());
        catalogQueryParameters.setLatestObservation(this.getLatestObservation());
        return catalogQueryParameters;
    }

    private static double convertToJy(Flux flux) {
        return flux.getContentInUnits(Flux.UNIT_JY);
    }

    @Override
    public long getRa() {
        SkyCoordinates skyCoordinates = this.querySourceAdaptee.getQueryCenter();
        double d = skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_ARCSEC);
        long l = (long)(d * 10000.0);
        return l;
    }

    @Override
    public double getRadius() {
        Angle angle = this.querySourceAdaptee.getSearchRadius();
        return angle.getContentInUnits(Angle.UNIT_DEG);
    }

    @Override
    public void setCalType(CalibrationUseType calibrationUseType) {
        String string = calibrationUseType.toString();
        this.querySourceAdaptee.setUse(string);
    }

    @Override
    public void setCalibList(List<Measurement> list) {
        this.measurements.clear();
        this.measurements.addAll(list);
    }

    public Integer getMaxSources() {
        return this.querySourceAdaptee.getMaxSources();
    }

    public void setMaxSources(Integer n) {
        this.querySourceAdaptee.setMaxSources(n);
    }

    @Override
    public void setCatalogueLocation(String string) {
        this.catalog = CalibratorExpert.SourceCatalog.byName(string);
    }

    @Override
    public void setDec(double d) {
        double d2 = d / 1000.0;
        Latitude latitude = Latitude.createLatitude((double)d2, (String)Latitude.UNIT_ARCSEC);
        SkyCoordinates skyCoordinates = this.querySourceAdaptee.getQueryCenter();
        skyCoordinates.setLatitude(latitude);
    }

    @Override
    public void setEarliestObservation(Date date) {
        throw new UnsupportedOperationException("Cannot translate from earliest observation date to maximum time");
    }

    public void setEarliestObservation(Date date, Date date2) {
        if (date.before(date2)) {
            Long l = date2.getTime() - date.getTime();
            Time time = Time.createTime((double)l.longValue(), (String)Time.UNIT_MS);
            this.querySourceAdaptee.setMaxTimeSinceObserved(time);
        }
    }

    @Override
    public void setLatestObservation(Date date) {
        throw new UnsupportedOperationException("Cannot translate from latest observation date to minimum time");
    }

    public void setLatestObservation(Date date, Date date2) {
        if (date.before(date2)) {
            Long l = date2.getTime() - date.getTime();
            Time time = Time.createTime((double)l.longValue(), (String)Time.UNIT_MS);
            this.querySourceAdaptee.setMinTimeSinceObserved(time);
        }
    }

    @Override
    public void setMaxFlux(Flux flux) {
        this.querySourceAdaptee.setMaxFlux(flux);
    }

    @Override
    public void setMaxFrequency(Frequency frequency) {
        this.querySourceAdaptee.setMaxFrequency(frequency);
    }

    @Override
    public void setMinFlux(Flux flux) {
        this.querySourceAdaptee.setMinFlux(flux);
    }

    @Override
    public void setMinFrequency(Frequency frequency) {
        this.querySourceAdaptee.setMinFrequency(frequency);
    }

    @Override
    public void setQuery(CatalogQueryParameters catalogQueryParameters) {
        Latitude latitude = Latitude.createLatitude((double)catalogQueryParameters.getDeclination(), (String)Latitude.UNIT_DEG);
        this.querySourceAdaptee.getQueryCenter().setLatitude(latitude);
        Longitude longitude = Longitude.createLongitude((double)catalogQueryParameters.getRightAscension(), (String)Longitude.UNIT_DEG);
        this.querySourceAdaptee.getQueryCenter().setLongitude(longitude);
        Angle angle = Angle.createAngle((double)catalogQueryParameters.getRadius(), (String)Angle.UNIT_DEG);
        this.querySourceAdaptee.setSearchRadius(angle);
        Frequency frequency = Frequency.createFrequencyGHZ(catalogQueryParameters.getMinFrequency());
        this.querySourceAdaptee.setMinFrequency(frequency);
        Frequency frequency2 = Frequency.createFrequencyGHZ(catalogQueryParameters.getMaxFrequency());
        this.querySourceAdaptee.setMaxFrequency(frequency2);
        Flux flux = Flux.createFlux((double)catalogQueryParameters.getMinFlux(), (String)Flux.UNIT_JY);
        this.querySourceAdaptee.setMinFlux(flux);
        Flux flux2 = Flux.createFlux((double)catalogQueryParameters.getMaxFlux(), (String)Flux.UNIT_JY);
        this.querySourceAdaptee.setMaxFlux(flux2);
        Time time = Time.createTime((double)catalogQueryParameters.getEarliestObservation().getTime(), (String)Time.UNIT_MS);
        this.querySourceAdaptee.setMinTimeSinceObserved(time);
        Time time2 = Time.createTime((double)catalogQueryParameters.getLatestObservation().getTime(), (String)Time.UNIT_MS);
        this.querySourceAdaptee.setMaxTimeSinceObserved(time2);
        String string = catalogQueryParameters.getCalibrationUse().toString();
        this.querySourceAdaptee.setUse(string);
    }

    @Override
    public void setRa(double d) {
        double d2 = d / 10000.0;
        Longitude longitude = Longitude.createLongitude((double)d2, (String)Latitude.UNIT_ARCSEC);
        SkyCoordinates skyCoordinates = this.querySourceAdaptee.getQueryCenter();
        skyCoordinates.setLongitude(longitude);
    }

    @Override
    public void setRadius(double d) {
        Angle angle = Angle.createAngle((double)d, (String)Angle.UNIT_DEG);
        this.querySourceAdaptee.setSearchRadius(angle);
    }

    private static Date convertToDate(Time time) {
        long l = (long)time.getContentInUnits(Time.UNIT_MS);
        return new Date(l);
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public void setSourceName(String string) {
        this.sourceName = string;
    }

    public IQuerySource getQuerySourceAdaptee() {
        return this.querySourceAdaptee;
    }
}

