/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.CorrConfigModeErr.wrappers.AcsJConstructorFailureEx;
import alma.entity.xmlbinding.schedblock.AbstractCorrelatorConfigurationT;
import alma.entity.xmlbinding.schedblock.types.SpectralSpecTReceiverTypeType;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.BaseBandHolder;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.DataRateChangeEvent;
import alma.obsprep.bo.schedblock.DataRateNode;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.TooManySpectralWindowsException;
import alma.obsprep.bo.schedblock.data.AbstractCorrelatorConfigurationData;
import alma.obsprep.ot.valdef.corrconfig.CorrelatorConfigDataRate;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.DataRate;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Formatter;
import lombok.NonNull;

public abstract class AbstractCorrelatorConfiguration
extends AbstractCorrelatorConfigurationData
implements BaseBandHolder,
DataRateNode {
    private final PropertyChangeListener correlatorConfigurationChangeListener = new CorrelatorConfigurationChangeListener();
    private CorrelatorConfigDataRate dataRateCalculator;
    private boolean isDataRateCalculatorActivated = false;
    static double DEF_INTDURATION_SECS = 5.04;
    static double DEF_CHANAVDURATION_SECS = 1.008;

    public AbstractCorrelatorConfiguration(AbstractCorrelatorConfigurationT abstractCorrelatorConfigurationT) {
        super(abstractCorrelatorConfigurationT);
        this.addPropertyChangeListener(this.correlatorConfigurationChangeListener);
        this.addPropertyChangeListener(new DataProductsUpdater());
        try {
            this.dataRateCalculator = new CorrelatorConfigDataRate(this);
        }
        catch (AcsJConstructorFailureEx acsJConstructorFailureEx) {
            acsJConstructorFailureEx.printStackTrace();
            Log.logger((Object)this).severe(acsJConstructorFailureEx.getMessage());
            throw new RuntimeException(acsJConstructorFailureEx.getMessage());
        }
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setAPCDataSets(APCDATASETS_AP_UNCORRECTED);
        this.setCAM(CAM_NORMAL);
        this.setLOOffsettingMode(LOOFFSETTINGMODE_NONE);
        this.setChannelAverageDuration(Time.createTimeSec(DEF_CHANAVDURATION_SECS));
        this.setIntegrationDuration(Time.createTimeSec(DEF_INTDURATION_SECS));
    }

    public static AbstractCorrelatorConfiguration createCorrelatorConfiguration(CorrelatorType correlatorType) {
        switch (correlatorType) {
            case ACA: {
                return ACACorrelatorConfiguration.createACACorrelatorConfiguration();
            }
            case BL: {
                return BLCorrelatorConfiguration.createBLCorrelatorConfiguration();
            }
        }
        return null;
    }

    protected AbstractBaseBandConfig addNewBaseBandConfig() {
        return this.addNewBaseBandConfig(this.getBaseBandConfigCount());
    }

    protected AbstractBaseBandConfig addNewBaseBandConfig(int n) {
        AbstractBaseBandConfig abstractBaseBandConfig = this.newBaseBandConfig();
        this.primitiveAddBaseBandConfig(n, abstractBaseBandConfig);
        return abstractBaseBandConfig;
    }

    public AbstractBaseBandConfig addBaseBandConfig(int n, AbstractBaseBandConfig abstractBaseBandConfig) {
        this.primitiveAddBaseBandConfig(n, abstractBaseBandConfig);
        abstractBaseBandConfig.updateDataProducts();
        this.dataRateChanged();
        return abstractBaseBandConfig;
    }

    public boolean removeBaseBandConfig(AbstractBaseBandConfig abstractBaseBandConfig) {
        boolean bl = this.primitiveRemoveBaseBandConfig(abstractBaseBandConfig);
        this.dataRateChanged();
        return bl;
    }

    public abstract AbstractBaseBandConfig newBaseBandConfig();

    public abstract AbstractBaseBandConfig primitiveAddBaseBandConfig(int var1, AbstractBaseBandConfig var2);

    public abstract boolean primitiveRemoveBaseBandConfig(AbstractBaseBandConfig var1);

    public abstract AbstractBaseBandConfig getBaseBandConfig(int var1);

    public abstract AbstractBaseBandConfig[] getBaseBandConfig();

    public abstract int getBaseBandConfigCount();

    public abstract void clearBaseBandConfig();

    public abstract CorrelatorType getCorrelatorType();

    @Override
    public DataRate getInstantaneousDataRate() {
        return this.dataRateCalculator.getConfigTotalDataRate();
    }

    @Override
    public DataRateNode getParentDataRateNode() {
        return (DataRateNode)this.getParent();
    }

    public void dataRateChanged() {
        this.dataRateChanged(new DataRateChangeEvent(this));
    }

    public void activateDataRateCalculator() {
        this.isDataRateCalculatorActivated = true;
    }

    @Override
    public void dataRateChanged(DataRateChangeEvent dataRateChangeEvent) {
        DataRateNode dataRateNode = this.getParentDataRateNode();
        if (this.isDataRateCalculatorActivated) {
            this.dataRateCalculator.updateDataRateForConfig(this);
        }
        if (dataRateNode != null) {
            dataRateNode.dataRateChanged(dataRateChangeEvent);
        }
    }

    public void setIntegrationDuration(Time time) {
        super.setIntegrationDuration(time);
        time.addPropertyChangeListener(this.correlatorConfigurationChangeListener);
    }

    @Override
    public void format(Formatter formatter, String string) {
        formatter.format("%s%s@%h%n", string, this.getClass().getSimpleName(), this.hashCode());
        for (AbstractBaseBandConfig abstractBaseBandConfig : this.getBaseBandConfig()) {
            abstractBaseBandConfig.format(formatter, string + "\t");
        }
    }

    public ReceiverBand getReceiverBand() {
        return ((SpectralSpec)this.getParent()).getReceiverBand();
    }

    public SpectralSpec getSpectralSpec() {
        return (SpectralSpec)this.getParent();
    }

    public String getReceiverType() {
        return this.getSpectralSpec().getReceiverType();
    }

    public void setReceiverType(String string) {
        this.getSpectralSpec().setReceiverType(string);
    }

    public Velocity getSourceVelocity() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        return spectralSpec == null ? Velocity.createVelocity() : spectralSpec.getSourceVelocity();
    }

    public void updateSideband() {
        for (AbstractBaseBandConfig abstractBaseBandConfig : this.getBaseBandConfig()) {
            abstractBaseBandConfig.updateSpectralWindowSideband();
        }
    }

    public boolean isValidTypeCombination() {
        return true;
    }

    public boolean isSideBandSeprationMode() {
        String string = this.getReceiverType();
        if (!string.equals(SpectralSpecTReceiverTypeType.DSB.toString())) {
            return false;
        }
        return this.getEnable90DegreeWalshFunction();
    }

    @Override
    public BaseBand[] getBaseBand() {
        return this.getBaseBandConfig();
    }

    @Override
    public BaseBand getBaseBand(int n) {
        return this.getBaseBandConfig(n);
    }

    @Override
    public int getBaseBandCount() {
        return this.getBaseBandConfigCount();
    }

    public void setEnable90DegreeWalshFunction(boolean bl) {
        boolean bl2 = this.getEnable90DegreeWalshFunction();
        super.setEnable90DegreeWalshFunction(bl);
        if (bl2 != bl) {
            for (AbstractBaseBandConfig abstractBaseBandConfig : this.getBaseBandConfig()) {
                try {
                    abstractBaseBandConfig.walsh90updated();
                }
                catch (TooManySpectralWindowsException tooManySpectralWindowsException) {
                    GUIUtilities.warning(null, tooManySpectralWindowsException.getMessage());
                    this.setEnable90DegreeWalshFunction(bl2);
                    return;
                }
            }
        }
    }

    public void setEnable180DegreeWalshFunction(boolean bl) {
        boolean bl2 = this.getEnable180DegreeWalshFunction();
        super.setEnable180DegreeWalshFunction(bl);
        if (bl2 != bl) {
            for (AbstractBaseBandConfig abstractBaseBandConfig : this.getBaseBandConfig()) {
                abstractBaseBandConfig.walsh180updated(bl);
            }
        }
    }

    public boolean isTDM() {
        boolean bl = true;
        block0: for (AbstractBaseBandConfig abstractBaseBandConfig : this.getBaseBandConfig()) {
            for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                if (!spectralWindowI.getCorrConfigMode().getFilter().equals((Object)CorrFilter.TFB)) continue;
                bl = false;
                continue block0;
            }
        }
        return bl;
    }

    public CorrelatorConfigDataRate getDataRateCalculator() {
        return this.dataRateCalculator;
    }

    private class CorrelatorConfigurationChangeListener
    implements PropertyChangeListener {
        private CorrelatorConfigurationChangeListener() {
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                throw new NullPointerException("evt is marked non-null but is null");
            }
            propertyChangeEvent.getPropertyName();
            propertyChangeEvent.getSource();
            try {
                AbstractCorrelatorConfiguration.this.dataRateChanged();
            }
            catch (Exception exception) {
                Log.logger(CorrelatorConfigurationChangeListener.class).warning("Unable to calculate data rate: " + exception.getMessage());
            }
        }
    }

    private class DataProductsUpdater
    implements PropertyChangeListener {
        private DataProductsUpdater() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.endsWith("CorrelatorConfiguration.cAM")) {
                for (AbstractBaseBandConfig abstractBaseBandConfig : AbstractCorrelatorConfiguration.this.getBaseBandConfig()) {
                    abstractBaseBandConfig.updateDataProducts();
                }
            }
        }
    }
}

