/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TechnicalJustification;
import alma.obsprep.bo.workbooks.WorkbookPage;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.actions.SearchActionFilters;
import alma.obsprep.ot.actions.SearchFilter;
import alma.obsprep.ot.actions.SearchProjectTree;
import alma.obsprep.ot.actions.SearchProjectTreeInteractor;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGuiProjectCompartment;
import alma.obsprep.ot.project.OTTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.util.GUIUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SearchProjectTreePerformer
extends Performer {
    private static final String SEARCH_BO_TYPE_DELIMITER = "#";
    private static final int NOT_FOUND = -1;

    public SearchProjectTreePerformer(SearchProjectTreeInteractor searchProjectTreeInteractor) {
        super(searchProjectTreeInteractor);
    }

    @Override
    public void perform() {
        SearchProjectTreeInteractor searchProjectTreeInteractor = (SearchProjectTreeInteractor)this.getGui();
        Log.logger(SearchProjectTreePerformer.class).fine("Searching for : " + searchProjectTreeInteractor.getSearchString());
        this.searchBusinessObject(searchProjectTreeInteractor);
    }

    private void searchBusinessObject(SearchProjectTreeInteractor searchProjectTreeInteractor) {
        if (StringUtils.isBlank((CharSequence)searchProjectTreeInteractor.getSearchString())) {
            return;
        }
        ProjectTreeNode projectTreeNode = searchProjectTreeInteractor.getSelectedNode();
        SearchProjectTree.SearchDirection searchDirection = searchProjectTreeInteractor.getSearchDirection();
        Optional<Object> optional = Optional.empty();
        try {
            optional = searchDirection.equals((Object)SearchProjectTree.SearchDirection.Down) ? this.searchForBODownwardsThroughProjectTree(projectTreeNode, searchProjectTreeInteractor) : this.searchForBOUpwardsThroughProjectTree(projectTreeNode, searchProjectTreeInteractor);
        }
        catch (UnableToExecuteSearchException unableToExecuteSearchException) {
            GUIUtilities.info(null, "Project Tree Search", "Select a node in the tree from which to start your search");
            return;
        }
        if (!optional.isPresent()) {
            GUIUtilities.info(null, "<html>The token <b>" + searchProjectTreeInteractor.getSearchString() + "</b> was not found when searching " + searchDirection.toString().toLowerCase() + "wards through the project tree from the currently selected node.</html>");
        }
        this.displaySpecifiedNodeInTree(searchProjectTreeInteractor, optional);
    }

    private void displaySpecifiedNodeInTree(@NonNull SearchProjectTreeInteractor searchProjectTreeInteractor, Optional<ProjectTreeNode> optional) {
        if (searchProjectTreeInteractor == null) {
            throw new NullPointerException("interactor is marked non-null but is null");
        }
        if (optional.isPresent()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            ProjectTreeNode projectTreeNode;
            DefaultMutableTreeNode defaultMutableTreeNode2 = projectTreeNode = optional.get();
            int n = 0;
            do {
                if ((defaultMutableTreeNode = searchProjectTreeInteractor.getSearchDirection().equals((Object)SearchProjectTree.SearchDirection.Down) ? defaultMutableTreeNode2.getNextLeaf() : defaultMutableTreeNode2.getPreviousLeaf()) == null) continue;
                defaultMutableTreeNode2 = defaultMutableTreeNode;
            } while (++n < 3 && defaultMutableTreeNode != null);
            TreePath treePath = new TreePath(optional.get().getPath());
            ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = ObservingToolController.getOTGui().activeProjectCompartment();
            OTTree oTTree = observingToolGuiProjectCompartment.getProjectTreePanels().getPhase1Tree().getTree();
            oTTree.setSelectionPath(treePath);
            oTTree.scrollPathToVisible(treePath);
            oTTree.expandPath(treePath);
            oTTree.setScrollsOnExpand(true);
            oTTree = observingToolGuiProjectCompartment.getProjectTreePanels().getPhase2Tree().getTree();
            oTTree.setSelectionPath(treePath);
            oTTree.expandPath(treePath);
            oTTree.scrollPathToVisible(treePath);
            oTTree.setScrollsOnExpand(true);
        }
    }

    private Optional<ProjectTreeNode> searchForBODownwardsThroughProjectTree(ProjectTreeNode projectTreeNode, SearchProjectTreeInteractor searchProjectTreeInteractor) throws UnableToExecuteSearchException {
        if (projectTreeNode == null) {
            throw new UnableToExecuteSearchException();
        }
        ProjectTreeNode projectTreeNode2 = (ProjectTreeNode)projectTreeNode.getRoot();
        Enumeration<TreeNode> enumeration = projectTreeNode2.preorderEnumeration();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            ProjectTreeNode projectTreeNode3 = (ProjectTreeNode)enumeration.nextElement();
            if (bl && this.searchNode(projectTreeNode3, searchProjectTreeInteractor.getSearchString())) {
                return Optional.of(projectTreeNode3);
            }
            if (!projectTreeNode3.equals(projectTreeNode)) continue;
            bl = true;
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    private boolean searchNode(ProjectTreeNode projectTreeNode, String string2) {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        int n = StringUtils.indexOf((CharSequence)string2, (CharSequence)SEARCH_BO_TYPE_DELIMITER);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n != -1) {
            stringArray = StringUtils.splitByWholeSeparator((String)StringUtils.substring((String)string2, (int)0, (int)n), (String)",");
            arrayList.addAll(Arrays.asList(stringArray));
            object3 = StringUtils.splitByWholeSeparator((String)string2, (String)SEARCH_BO_TYPE_DELIMITER);
            if (((String[])object3).length != 2) {
                return false;
            }
            string2 = object3[1];
        }
        stringArray = projectTreeNode.getUserObject();
        object3 = List.of(projectTreeNode.getUserObject());
        if (stringArray instanceof WorkbookPage && (object2 = ((WorkbookPage)(object = (WorkbookPage)stringArray)).getParent()) instanceof ScienceGoal) {
            ScienceGoal scienceGoal = (ScienceGoal)object2;
            switch (((WorkbookPage)object).getIndex()) {
                case 1: {
                    void var12_18;
                    object3 = new ArrayList();
                    TargetParameters[] objectArray = scienceGoal.getTargetParameters();
                    int n2 = objectArray.length;
                    boolean bl = false;
                    while (var12_18 < n2) {
                        TargetParameters targetParameters = objectArray[var12_18];
                        object3.add(targetParameters);
                        ++var12_18;
                    }
                    break;
                }
                case 2: {
                    object3 = List.of(scienceGoal.getSpectralSetupParameters());
                    break;
                }
                case 3: {
                    object3 = List.of(scienceGoal.getCalibrationSetupParameters());
                    break;
                }
                case 4: {
                    object3 = List.of(scienceGoal.getPerformanceParameters());
                    break;
                }
                case 5: {
                    void var12_20;
                    object3 = new ArrayList();
                    TechnicalJustification[] technicalJustificationArray = scienceGoal.getTechnicalJustification();
                    int n2 = technicalJustificationArray.length;
                    boolean bl = false;
                    while (var12_20 < n2) {
                        TechnicalJustification technicalJustification = technicalJustificationArray[var12_20];
                        object3.add(technicalJustification);
                        ++var12_20;
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        object = object3.iterator();
        while (object.hasNext()) {
            object2 = object.next();
            for (SearchFilter searchFilter : SearchActionFilters.getBOsearchfilters()) {
                if (!object2.getClass().isAssignableFrom(searchFilter.getBoClass()) || !arrayList.isEmpty() && searchFilter.getSearchTypeIndentifier().isPresent() && !arrayList.stream().filter(string -> searchFilter.getSearchTypeIndentifier().get().equalsIgnoreCase((String)string)).findFirst().isPresent()) continue;
                searchFilter.setSearchString(string2);
                for (Predicate<BusinessObject> predicate : searchFilter.getPredicates()) {
                    if (!predicate.test((BusinessObject)object2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Optional<ProjectTreeNode> searchForBOUpwardsThroughProjectTree(ProjectTreeNode projectTreeNode, SearchProjectTreeInteractor searchProjectTreeInteractor) throws UnableToExecuteSearchException {
        if (projectTreeNode == null) {
            throw new UnableToExecuteSearchException();
        }
        ProjectTreeNode projectTreeNode2 = (ProjectTreeNode)projectTreeNode.getRoot();
        Enumeration<TreeNode> enumeration = projectTreeNode2.preorderEnumeration();
        Optional<ProjectTreeNode> optional = Optional.empty();
        projectTreeNode.getUserObject();
        while (enumeration.hasMoreElements()) {
            ProjectTreeNode projectTreeNode3 = (ProjectTreeNode)enumeration.nextElement();
            if (projectTreeNode3.equals(projectTreeNode)) {
                return optional;
            }
            if (!this.searchNode(projectTreeNode3, searchProjectTreeInteractor.getSearchString())) continue;
            optional = Optional.of(projectTreeNode3);
        }
        return optional;
    }

    public class UnableToExecuteSearchException
    extends Exception {
    }
}

