/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.ot.editors.misc.CalendarPopup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.swing.JButton;

public class CalendarTextButton
extends JButton
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 5941093995685486152L;
    String dateParam = "date";
    ZonedDateTime targetDate = null;
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd");

    public CalendarTextButton() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        this.setTargetDate(zonedDateTime);
        this.setMargin(CalendarPopup.NO_INSETS);
        this.setOpaque(false);
        this.addActionListener(this);
    }

    public CalendarTextButton(ZonedDateTime zonedDateTime) {
        this();
        this.init(null, zonedDateTime);
    }

    public CalendarTextButton(String string, ZonedDateTime zonedDateTime) {
        this();
        this.init(string, zonedDateTime);
    }

    public void init(String string, ZonedDateTime zonedDateTime) {
        if (string == null) {
            string = "date";
        }
        this.dateParam = string;
        this.setTargetDate(zonedDateTime);
    }

    public ZonedDateTime getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(ZonedDateTime zonedDateTime) {
        this.targetDate = zonedDateTime;
        this.setText(dateTimeFormat.format(this.targetDate));
    }

    public String getDateParam() {
        return this.dateParam;
    }

    public void setDateParam(String string) {
        this.dateParam = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this) {
            ZonedDateTime zonedDateTime = this.getTargetDate();
            CalendarPopup calendarPopup = CalendarPopup.createCalendarPopup(this.getDateParam(), zonedDateTime, this);
            calendarPopup.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        if (this.dateParam.equalsIgnoreCase(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof ZonedDateTime) {
            this.setTargetDate((ZonedDateTime)propertyChangeEvent.getNewValue());
        }
    }
}

