/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.GUIUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionListener;

public class AttachableComponentChooser
extends JDialog {
    private static final long serialVersionUID = -718384194110194469L;
    private ActionListener actionListener;
    private Container contentPane;
    private JButton attachButton;
    private JButton cancelButton;
    private JButton okButton;
    private JButton detachButton;
    private JList<BusinessObject> rightList;
    private JList<BusinessObject> leftList;
    private ListCellRenderer<Object> cellRenderer;
    private ListSelectionListener selectionListener;
    private final boolean isMultipleRowsToBeSelected;
    DefaultListModel<BusinessObject> leftModel = new DefaultListModel();
    DefaultListModel<BusinessObject> rightModel = new DefaultListModel();
    private final List<BusinessObject> allBOList = new ArrayList<BusinessObject>();
    private final boolean[] isBOCurrentlyAttached;
    private boolean isOperationCancelled = true;

    private AttachableComponentChooser(JFrame jFrame, BusinessObject[] businessObjectArray, BusinessObject[] businessObjectArray2, boolean bl) {
        super(jFrame, "Attach/Detach", true);
        this.setDefaultCloseOperation(2);
        this.isMultipleRowsToBeSelected = bl;
        if (!this.isMultipleRowsToBeSelected) {
            businessObjectArray2 = new BusinessObject[]{};
        }
        this.isBOCurrentlyAttached = new boolean[businessObjectArray.length];
        for (int i = 0; i < businessObjectArray.length; ++i) {
            this.allBOList.add(businessObjectArray[i]);
            this.isBOCurrentlyAttached[i] = false;
            for (int j = 0; j < businessObjectArray2.length; ++j) {
                if (businessObjectArray2[j] != businessObjectArray[i]) continue;
                this.isBOCurrentlyAttached[i] = true;
            }
        }
        this.build();
    }

    public static Iterator<BusinessObject> chooseMultiple(BusinessObject[] businessObjectArray, BusinessObject[] businessObjectArray2) {
        return AttachableComponentChooser.chooseMultiple(null, businessObjectArray, businessObjectArray2);
    }

    public static Iterator<BusinessObject> chooseMultiple(JFrame jFrame, BusinessObject[] businessObjectArray, BusinessObject[] businessObjectArray2) {
        AttachableComponentChooser attachableComponentChooser = new AttachableComponentChooser(jFrame, businessObjectArray, businessObjectArray2, true);
        List<BusinessObject> list = attachableComponentChooser.getSelection();
        if (list == null) {
            return null;
        }
        return list.iterator();
    }

    public static BusinessObject chooseSingle(JFrame jFrame, BusinessObject[] businessObjectArray) {
        AttachableComponentChooser attachableComponentChooser = new AttachableComponentChooser(jFrame, businessObjectArray, null, false);
        List<BusinessObject> list = attachableComponentChooser.getSelection();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    protected void setButtons() {
        boolean bl = this.leftList.getSelectedIndex() != -1;
        this.attachButton.setEnabled(bl);
        boolean bl2 = this.rightList.getSelectedIndex() != -1;
        this.detachButton.setEnabled(bl2);
        if (!this.isMultipleRowsToBeSelected) {
            this.okButton.setEnabled(bl);
        }
    }

    private ActionListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = actionEvent -> {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.equals(this.attachButton)) {
                    BusinessObject businessObject;
                    int n;
                    int n2;
                    int[] nArray = this.leftList.getSelectedIndices();
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        n = nArray[n2];
                        businessObject = this.leftModel.get(n);
                        if (!this.isExclusiveObject(businessObject)) continue;
                        for (int i = n2 + 1; i < nArray.length; ++i) {
                            if (!this.isExclusive(this.leftModel.get(nArray[i]), businessObject)) continue;
                            GUIUtilities.error(null, "Can not select these components simultaneously.");
                            return;
                        }
                    }
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        n = nArray[n2];
                        businessObject = this.leftModel.get(n);
                        this.isBOCurrentlyAttached[this.allBOList.indexOf((Object)businessObject)] = true;
                        if (!this.isExclusiveObject(businessObject)) continue;
                        Enumeration<BusinessObject> enumeration = this.rightModel.elements();
                        while (enumeration.hasMoreElements()) {
                            BusinessObject businessObject2 = enumeration.nextElement();
                            if (!this.isExclusive(businessObject2, businessObject)) continue;
                            this.isBOCurrentlyAttached[this.allBOList.indexOf((Object)businessObject2)] = false;
                        }
                    }
                    this.setListModels();
                } else if (jButton.equals(this.detachButton)) {
                    int[] nArray = this.rightList.getSelectedIndices();
                    for (int i = 0; i < nArray.length; ++i) {
                        int n = nArray[i];
                        BusinessObject businessObject = this.rightModel.get(n);
                        this.isBOCurrentlyAttached[this.allBOList.indexOf((Object)businessObject)] = false;
                    }
                    this.setListModels();
                } else if (jButton.equals(this.okButton)) {
                    this.isOperationCancelled = false;
                    this.setVisible(false);
                } else if (jButton.equals(this.cancelButton)) {
                    this.leftList.clearSelection();
                    this.rightList.clearSelection();
                    this.leftModel.clear();
                    this.setVisible(false);
                }
                this.setButtons();
            };
        }
        return this.actionListener;
    }

    private boolean isExclusiveObject(Object object) {
        if (object instanceof FieldSource) {
            return true;
        }
        return object instanceof AbstractInstrumentSpec;
    }

    private boolean isExclusive(Object object, Object object2) {
        if (object.getClass() == object2.getClass()) {
            return true;
        }
        return object instanceof AbstractInstrumentSpec && object2 instanceof AbstractInstrumentSpec;
    }

    private ListCellRenderer<Object> getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = new CellRenderer();
        }
        return this.cellRenderer;
    }

    private void setListModels() {
        this.leftModel.removeAllElements();
        this.rightModel.removeAllElements();
        for (int i = 0; i < this.isBOCurrentlyAttached.length; ++i) {
            BusinessObject businessObject = this.allBOList.get(i);
            if (!this.isBOCurrentlyAttached[i]) {
                this.leftModel.addElement(businessObject);
                continue;
            }
            this.rightModel.addElement(businessObject);
        }
    }

    private List<BusinessObject> getSelection() {
        if (this.isOperationCancelled) {
            return null;
        }
        ArrayList<BusinessObject> arrayList = new ArrayList<BusinessObject>();
        if (this.isMultipleRowsToBeSelected) {
            for (int i = 0; i < this.rightModel.getSize(); ++i) {
                arrayList.add(this.rightModel.elementAt(i));
            }
        } else {
            int n = this.leftList.getSelectedIndex();
            if (n >= 0) {
                arrayList.add(this.leftModel.elementAt(n));
            }
        }
        return arrayList;
    }

    private ListSelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = listSelectionEvent -> this.setButtons();
        }
        return this.selectionListener;
    }

    private void build() {
        this.contentPane = this.getContentPane();
        this.createComponents();
        this.layoutComponents();
        this.setButtons();
        this.pack();
        this.setVisible(true);
    }

    private void createComponents() {
        this.setListModels();
        this.leftList = new JList<BusinessObject>(this.leftModel);
        this.rightList = new JList<BusinessObject>(this.rightModel);
        this.attachButton = new JButton("\u2192");
        this.detachButton = new JButton("\u2190");
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        ActionListener actionListener = this.getActionListener();
        this.attachButton.addActionListener(actionListener);
        this.detachButton.addActionListener(actionListener);
        this.okButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener);
        int n = this.isMultipleRowsToBeSelected ? 2 : 0;
        this.leftList.setSelectionMode(n);
        this.rightList.setSelectionMode(n);
        this.leftList.getSelectionModel().addListSelectionListener(this.getSelectionListener());
        this.rightList.getSelectionModel().addListSelectionListener(this.getSelectionListener());
        this.leftList.setCellRenderer(this.getCellRenderer());
        this.rightList.setCellRenderer(this.getCellRenderer());
    }

    private void layoutComponents() {
        JPanel jPanel;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.contentPane.setLayout(gridBagLayout);
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel("Attachable Components");
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.contentPane.add(jLabel);
        if (this.isMultipleRowsToBeSelected) {
            jLabel = new JLabel("Selected");
            gridBagConstraints.gridx = 2;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.contentPane.add(jLabel);
        }
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.leftList);
        gridBagLayout.setConstraints(scrollWhenFocusedPane, gridBagConstraints);
        this.contentPane.add(scrollWhenFocusedPane);
        if (this.isMultipleRowsToBeSelected) {
            gridBagConstraints.gridx = 1;
            jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 3));
            jPanel2.add(this.attachButton);
            jPanel2.add(Box.createVerticalStrut(5));
            jPanel2.add(this.detachButton);
            jPanel.add(jPanel2);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.contentPane.add(jPanel);
            gridBagConstraints.gridx = 2;
            scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.rightList);
            gridBagLayout.setConstraints(scrollWhenFocusedPane, gridBagConstraints);
            this.contentPane.add(scrollWhenFocusedPane);
        }
        gridBagConstraints.gridy = 2;
        jPanel = new JPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        if (this.isMultipleRowsToBeSelected) {
            gridBagConstraints.gridwidth = 0;
        }
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.contentPane.add(jPanel);
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        Target target = schedBlock.createTarget();
        ScienceParameters scienceParameters = schedBlock.createScienceParameters();
        scienceParameters.setName("sp1");
        ScienceParameters scienceParameters2 = schedBlock.createScienceParameters();
        scienceParameters2.setName("sp2");
        ScienceParameters scienceParameters3 = schedBlock.createScienceParameters();
        scienceParameters3.setName("sp3");
        ScienceParameters scienceParameters4 = schedBlock.createScienceParameters();
        scienceParameters4.setName("sp4");
        ScienceParameters scienceParameters5 = schedBlock.createScienceParameters();
        scienceParameters5.setName("sp5");
        PhaseCalParameters phaseCalParameters = schedBlock.createPhaseCalParameters();
        phaseCalParameters.setName("ph1");
        FieldSource fieldSource = schedBlock.createFieldSource();
        fieldSource.setName("source1");
        FieldSource fieldSource2 = schedBlock.createFieldSource();
        fieldSource2.setName("source2");
        FieldSource fieldSource3 = schedBlock.createFieldSource();
        fieldSource3.setName("source3");
        FieldSource fieldSource4 = schedBlock.createFieldSource();
        fieldSource4.setName("source4");
        SpectralSpec spectralSpec = schedBlock.createSpectralSpec();
        spectralSpec.setName("spec1");
        BusinessObject[] businessObjectArray = new BusinessObject[]{scienceParameters, scienceParameters2, scienceParameters3, scienceParameters4, scienceParameters5, phaseCalParameters, fieldSource, fieldSource2, fieldSource3, fieldSource4, spectralSpec};
        schedBlock.getObservingParameters();
        schedBlock.getFieldSource();
        target.setFieldSource(fieldSource);
        BusinessObject[] businessObjectArray2 = new BusinessObject[]{target.getFieldSource(), scienceParameters, phaseCalParameters};
        Iterator<BusinessObject> iterator = AttachableComponentChooser.chooseMultiple(businessObjectArray, businessObjectArray2);
        if (iterator == null) {
            System.out.println("Canceled!!!");
        } else {
            while (iterator.hasNext()) {
                System.out.println("multi  : " + String.valueOf(iterator.next()));
            }
            System.out.println("multi done");
        }
    }

    private final class CellRenderer
    extends DefaultListCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            try {
                BusinessObject businessObject = (BusinessObject)object;
                if (businessObject == null) {
                    this.setText("#" + n + ": null");
                } else {
                    this.setText(businessObject.getShortClassName() + " - " + businessObject.getNameOrDefault());
                }
            }
            catch (ClassCastException classCastException) {
                this.setText(object.toString());
            }
            return this;
        }
    }
}

