/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.editors.schedblock.FieldPatternEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.FieldPatternModel;
import alma.obsprep.ot.models.schedblock.FieldSourceModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;

public class FieldPatternEditorTestMain {
    private final FieldSourceModel fsmodel = new FieldSourceModel(null);
    private final FieldPatternModel model = this.fsmodel.getFieldPatternModel();
    private final FieldPatternEditor editor = new FieldPatternEditor(this.model);

    private FieldSource createFieldSource() {
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        Target target = schedBlock.createTarget();
        SpectralSpec spectralSpec = schedBlock.createSpectralSpec();
        spectralSpec.getRestFrequency().setContentAndUnit(100.0, Frequency.UNIT_GHZ);
        FieldSource fieldSource = schedBlock.createFieldSource();
        fieldSource.getSourceCoordinates().setType(SkyCoordinates.TYPE_ABSOLUTE);
        target.setSpectralSpec(spectralSpec);
        target.setFieldSource(fieldSource);
        return fieldSource;
    }

    public void test0() {
        FieldSource fieldSource = this.createFieldSource();
        this.fsmodel.setDocument(fieldSource);
        TestUtilities.runTestApp(this.editor, 600, 800);
    }

    public void test1() {
        FieldSource fieldSource = this.createFieldSource();
        PointingPattern pointingPattern = PointingPattern.createPointingPattern();
        fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
        this.fsmodel.setDocument(fieldSource);
        TestUtilities.runTestApp(this.editor, 600, 800);
    }

    public void test2() {
        FieldSource fieldSource = this.createFieldSource();
        RectanglePattern rectanglePattern = RectanglePattern.createRectanglePattern();
        rectanglePattern.getLatitudeLength().setContentAndUnit(10.0, Angle.UNIT_ARCMIN);
        rectanglePattern.getLongitudeLength().setContentAndUnit(10.0, Angle.UNIT_ARCMIN);
        fieldSource.setFieldPattern((FieldPattern)((Object)rectanglePattern));
        this.fsmodel.setDocument(fieldSource);
        TestUtilities.runTestApp(this.editor, 600, 800);
    }

    public void run() {
        this.test1();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        FieldPatternEditorTestMain fieldPatternEditorTestMain = new FieldPatternEditorTestMain();
        fieldPatternEditorTestMain.run();
    }
}

