/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.editors.schedblock.AbstractSwitchingStateTable;
import alma.obsprep.ot.editors.spectralvisual.ResourceColumnRenderer;
import alma.valuetypes.Frequency;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FrequencySwitchingStateTable
extends AbstractSwitchingStateTable {
    private static final long serialVersionUID = 8912350792595521467L;

    public FrequencySwitchingStateTable(TableModel tableModel) {
        super(tableModel);
    }

    @Override
    protected void setupTableCellEditors() {
        super.setupTableCellEditors();
        ValueUnitPairCellEditor.FrequencyEditor frequencyEditor = new ValueUnitPairCellEditor.FrequencyEditor();
        TableColumn tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(frequencyEditor);
    }

    @Override
    protected void setupTableCellRenderers() {
        super.setupTableCellRenderers();
        ResourceColumnRenderer resourceColumnRenderer = new ResourceColumnRenderer(){
            private static final long serialVersionUID = -9048767156104266422L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Frequency frequency = (Frequency)((Object)object);
                String string = String.format("%.5f %s", frequency.getContentInUnits(Frequency.UNIT_GHZ), Frequency.UNIT_GHZ);
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        };
        this.table.setDefaultRenderer(Frequency.class, resourceColumnRenderer);
    }
}

