/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.FieldTargetPart;
import alma.obsprep.bo.annotations.NameResolvable;
import alma.obsprep.bo.obsproject.ResolvableTarget;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.ot.editors.schedblock.NameResolverResultsDialog;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.astro.NEDNameResolver;
import alma.obsprep.util.astro.Resolver;
import alma.obsprep.util.astro.SimbadNameResolver;
import alma.obsprep.util.job.ObsprepThreadGroup;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.data.VelocityData;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class NameResolver {
    private final DialogId iauAdvisoryDialogId = new DialogId("FieldSetup.NameResolver.iauInfo", "IAU lookups are not advised");
    private final Log.Logger logger = Log.logger((Object)this);
    private static final int TIMEOUT_s = 10;
    private final List<Resolver> resolvers = List.of(new SimbadNameResolver(), new NEDNameResolver());
    private FieldTargetPart fieldTargetPart;
    private Thread resolveWorker;
    private ObservingToolGui.FeedbackInfo feedback;

    public Object resolve(FieldTargetPart fieldTargetPart) {
        this.fieldTargetPart = fieldTargetPart;
        Object object = this.resolve(fieldTargetPart.getSourceName());
        if (object instanceof Resolver) {
            this.setResult((Resolver)object);
        }
        return object;
    }

    public Object resolve(NameResolvable nameResolvable) {
        Object object = this.resolve(nameResolvable.getSourceName());
        if (object instanceof Resolver) {
            Resolver resolver = (Resolver)object;
            SkyCoordinates skyCoordinates = nameResolvable.getSourceCoordinates();
            if (skyCoordinates == null) {
                skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
            }
            skyCoordinates.getLongitude().setContent(resolver.getRa());
            skyCoordinates.getLatitude().setContent(resolver.getDec());
            skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
        }
        return object;
    }

    public Object resolve(ResolvableTarget resolvableTarget) {
        Object object = this.resolve(resolvableTarget.getSourceName());
        if (object instanceof Resolver) {
            Resolver resolver = (Resolver)object;
            SkyCoordinates skyCoordinates = resolvableTarget.getSourceCoordinates();
            skyCoordinates.getLongitude().setContent(resolver.getRa());
            skyCoordinates.getLatitude().setContent(resolver.getDec());
            skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
            VelocityData velocityData = resolvableTarget.getSourceVelocity();
            if (resolver.getSourceVelocity() != null) {
                velocityData.setDopplerCalcType(resolver.getSourceVelocity().getDopplerCalcType());
                velocityData.getCenterVelocity().setContent(resolver.getSourceVelocity().getCenterVelocity().getContent());
                velocityData.getCenterVelocity().setUnit(resolver.getSourceVelocity().getCenterVelocity().getUnit());
                velocityData.setReferenceSystem(resolver.getSourceVelocity().getReferenceSystem());
            } else {
                velocityData.getCenterVelocity().setContent(0.0);
            }
        }
        return object;
    }

    private Object resolve(String string) {
        if ((string = string.trim()) == null || string.length() == 0) {
            Log.logger((Object)this).warning("Source Name must be set.");
            return null;
        }
        boolean bl = string.matches("^[ ]?[JBjb]?[0-9]+[\\+\\-]+[0-9]+");
        if (bl) {
            Log.logger((Object)this).warning("Source name " + string + " will be interpreted as a coordinate: rejected");
            return GUIUtilities.offer(null, "<html><center><p>Resolving source names that just use coordinates is no longer allowed. <P><BR>Source names that are built from coordinates must include an acronym <P>at the beginning e.g. <b>JVAS B0218+357</b></p></center>", "Reset name to previous target", "Leave name for editing");
        }
        boolean bl2 = string.matches("^iau[ ][jJ][0-9]+[\\+\\-]+[0-9]+");
        if (bl2) {
            GUIUtilities.warningWithDoNotShowAgain(this.iauAdvisoryDialogId, "<html><b>iau</b> searches are discouraged as they usually return the wrong source.</html>");
        }
        boolean bl3 = bl2 || bl;
        string = string.replaceFirst("[ ]?\\+[ ]?", "+");
        Log.logger(NameResolver.class).fine("sourceName to be resolved : " + string);
        for (Resolver resolver : this.resolvers) {
            Object object;
            resolver.setName(string);
            resolver.reset();
            this.logger.fine(resolver.toString());
            this.resolveWorker = new Thread(ObsprepThreadGroup.getInstance(), resolver, "NameResolver");
            this.resolveWorker.start();
            try {
                object = Stopwatch.createStarted();
                this.resolveWorker.join(10000L);
                Log.logger(NameResolver.class).fine(object.elapsed(TimeUnit.NANOSECONDS) + " " + String.valueOf((Object)this.resolveWorker.getState()));
            }
            catch (InterruptedException interruptedException) {
                this.resolveWorker.interrupt();
                return null;
            }
            if (resolver.isQueryReturned()) {
                if (resolver.isQuerySuccessful()) {
                    Object object2;
                    object = resolver.getResults();
                    if (object.size() == 1) {
                        bl3 |= ((Resolver)object.get(0)).getSourceVelocity() == null;
                    }
                    if (object.size() != 1 || bl3) {
                        object2 = new NameResolverResultsDialog(null);
                        ((NameResolverResultsDialog)object2).setResults((Collection<Resolver>)object, string);
                        ((NameResolverResultsDialog)object2).setVisible(true);
                        resolver = ((NameResolverResultsDialog)object2).getSelected();
                    } else {
                        resolver = (Resolver)object.get(0);
                    }
                    if (resolver != null) {
                        object2 = "The object \"" + string + "\" was resolved by " + resolver.getName() + "(" + resolver.getNameServer() + ")";
                        this.feedback = new ObservingToolGui.FeedbackInfo((String)object2, resolver.toString());
                    }
                    return resolver;
                }
                this.logger.fine(resolver.getNameServer() + " could not resolve the name: " + string);
                continue;
            }
            this.resolveWorker.interrupt();
            this.logger.fine(resolver.getNameServer() + " query timeout: " + string);
        }
        return GUIUtilities.offer(null, "<html><p>Could not resolve the name <b>" + string + "</b></p><p>Do you wish to reset the name to the previous target?</p>", "Reset name", "Leave name for editing");
    }

    private void setResult(Resolver resolver) {
        SkyCoordinates skyCoordinates = this.fieldTargetPart.getSourceCoordinates();
        skyCoordinates.getLongitude().setContent(resolver.getRa());
        skyCoordinates.getLatitude().setContent(resolver.getDec());
        skyCoordinates.getLatitude().setUnit(Latitude.UNIT_DEG);
        skyCoordinates.getLongitude().setUnit(Longitude.UNIT_DEG);
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
        if (resolver.getProperMotionRa() != Resolver.NODATA) {
            this.fieldTargetPart.getPMRA().setContent(resolver.getProperMotionRa());
            this.fieldTargetPart.getPMRA().setUnit(AngularVelocity.UNIT_MAS_YR);
        } else {
            this.fieldTargetPart.getPMRA().setContent(0.0);
        }
        if (resolver.getProperMotionDec() != Resolver.NODATA) {
            this.fieldTargetPart.getPMDec().setContent(resolver.getProperMotionDec());
            this.fieldTargetPart.getPMDec().setUnit(AngularVelocity.UNIT_MAS_YR);
        } else {
            this.fieldTargetPart.getPMDec().setContent(0.0);
        }
        if (resolver.getParallax() != Resolver.NODATA) {
            this.fieldTargetPart.getParallax().setContent(resolver.getParallax());
            this.fieldTargetPart.getParallax().setUnit(Angle.UNIT_MAS);
        } else {
            this.fieldTargetPart.getParallax().setContent(0.0);
        }
        if (resolver.getSourceVelocity() != null) {
            this.fieldTargetPart.getSourceVelocity().getCenterVelocity().setContent(resolver.getSourceVelocity().getCenterVelocity().getContent());
            this.fieldTargetPart.getSourceVelocity().getCenterVelocity().setUnit(resolver.getSourceVelocity().getCenterVelocity().getUnit());
            this.fieldTargetPart.getSourceVelocity().setDopplerCalcType(resolver.getSourceVelocity().getDopplerCalcType());
            this.fieldTargetPart.getSourceVelocity().setReferenceSystem(resolver.getSourceVelocity().getReferenceSystem());
        } else {
            this.fieldTargetPart.getSourceVelocity().getCenterVelocity().setContent(0.0);
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        NameResolver nameResolver = new NameResolver();
        FieldSource fieldSource = FieldSource.createFieldSource();
        Object object = nameResolver.resolve(fieldSource);
        fieldSource.setSourceName("J0004-476");
        if (object instanceof Resolver) {
            System.out.println(object);
        }
    }

    public ObservingToolGui.FeedbackInfo getFeedback() {
        return this.feedback;
    }
}

