/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.MultipageViewException;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.TargetEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.schedblock.TargetModel;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class NoFieldSourcePanel
extends EditorWithGridBagLayout {
    public static final FieldID FS_DROPDOWN_FID = new FieldID("NoFieldSourcePanel.DropDownFID");
    public static final FieldID FID_FS_OK = new FieldID("NoFieldSourcePanel.OKButtonFID");
    private JTable summaryTable;
    protected final String labelNew = "Create new";
    private static final int TABLE_WIDTH = 400;
    private static final int TABLE_HEIGHT = 200;

    public NoFieldSourcePanel(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public TargetModel getModel() {
        return (TargetModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        this.initEvents(jButton, FID_FS_OK);
        jPanel.add(jButton);
        this.addLabel(this, this.layout, this.constraints, "<html><br><br><p>Please select a Field Source for this target</p><br><br><br></html>");
        this.addComboBox((JComponent)this, this.layout, this.constraints, FS_DROPDOWN_FID, "Field Source to use", "<html>Select the field source to use for this target,<br>or choose to create a new one</html>", this.getFieldSourceNames());
        this.setupSummaryTable();
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.summaryTable);
        this.addComponent(this, this.layout, this.constraints, scrollWhenFocusedPane);
        this.addComponent(this, this.layout, this.constraints, jPanel);
        this.setBorder(BorderFactory.createTitledBorder(string));
    }

    private String[] getFieldSourceNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("Create new");
        FieldSourceCollection fieldSourceCollection = this.getFieldSourceCollection();
        if (fieldSourceCollection != null) {
            for (BusinessObject businessObject : fieldSourceCollection.getCollection()) {
                try {
                    FieldSource fieldSource = (FieldSource)businessObject;
                    vector.add(fieldSource.getNameOrDefault());
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    private FieldSourceCollection getFieldSourceCollection() {
        SchedBlock schedBlock;
        FieldSourceCollection fieldSourceCollection = null;
        Target target = this.getModel().getTarget();
        if (target != null && (schedBlock = target.getSchedBlock()) != null) {
            fieldSourceCollection = new FieldSourceCollection(schedBlock);
        }
        return fieldSourceCollection;
    }

    @Override
    protected void build() {
        super.build("No Field Source");
    }

    public FieldSource getSelectedFieldSource() {
        String string;
        JComboBox jComboBox = (JComboBox)this.getComponent(FS_DROPDOWN_FID);
        int n = jComboBox.getSelectedIndex();
        Target target = this.getModel().getTarget();
        SchedBlock schedBlock = target.getSchedBlock();
        FieldSource fieldSource = null;
        if (n == 0) {
            fieldSource = schedBlock.createFieldSource();
        } else if (n - 1 < schedBlock.getFieldSourceCount() && !(string = (fieldSource = schedBlock.getFieldSource(n - 1)).getNameOrDefault()).equals(jComboBox.getSelectedItem())) {
            fieldSource = null;
        }
        return fieldSource;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_FS_OK)) {
            ObservingToolGui observingToolGui;
            Target target = this.getModel().getTarget();
            FieldSource fieldSource = this.getSelectedFieldSource();
            if (fieldSource != null) {
                target.setFieldSource(fieldSource);
                this.getModel().getFieldSourceModel().setDocument(fieldSource);
                this.getModel().publish(TargetEditor.DOCUMENT_FID, target);
            }
            this.update(FS_DROPDOWN_FID, "Create new");
            ObservingToolController observingToolController = ObservingToolController.getMyInstance();
            if (observingToolController != null && (observingToolGui = observingToolController.getGui()) != null) {
                observingToolGui.refreshCrossHighlight();
                try {
                    observingToolGui.updateEditor();
                    observingToolGui.jumpToBO((BusinessObject)this.getModel().getTarget());
                }
                catch (MultipageViewException multipageViewException) {
                    Log.logger((Object)this).warning("Cannot display component part " + target.getNameOrDefault() + " - " + multipageViewException.getLocalizedMessage());
                }
            }
            return;
        }
        if (fieldID == FS_DROPDOWN_FID) {
            JComboBox jComboBox = (JComboBox)this.getComponent(fieldID);
            this.updateFieldSourceDropDown(jComboBox, (String)object);
            int n = jComboBox.getSelectedIndex();
            if (n == 0) {
                this.summaryTable.clearSelection();
            } else if (n - 1 < this.summaryTable.getRowCount()) {
                this.summaryTable.setRowSelectionInterval(n - 1, n - 1);
            }
            return;
        }
        super.update(fieldID, object);
    }

    private void updateFieldSourceDropDown(JComboBox jComboBox, String string) {
        String[] stringArray = this.getFieldSourceNames();
        this.suspendEvents(jComboBox);
        jComboBox.removeAllItems();
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
        this.resumeEvents(jComboBox);
        this.set(jComboBox, string);
    }

    private void updateFieldSourceDropDown(JComboBox jComboBox, int n) {
        String[] stringArray = this.getFieldSourceNames();
        String string = stringArray[n + 1];
        this.updateFieldSourceDropDown(jComboBox, string);
    }

    private void setupSummaryTable() {
        this.summaryTable = new Table();
        this.summaryTable.setModel(this.getModel().getFieldSourceSummaryTableModel());
        this.summaryTable.getTableHeader().setReorderingAllowed(false);
        this.summaryTable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        ListSelectionModel listSelectionModel = this.summaryTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        TableModel tableModel = this.summaryTable.getModel();
        tableModel.addTableModelListener(tableModelEvent -> {
            if (tableModelEvent.getType() == -1 || tableModelEvent.getType() == 0) {
                JComboBox jComboBox = (JComboBox)this.getComponent(FS_DROPDOWN_FID);
                this.updateFieldSourceDropDown(jComboBox, -1);
            }
        });
        ListSelectionListener listSelectionListener = listSelectionEvent -> {
            int n = this.summaryTable.getSelectedRow();
            JComboBox jComboBox = (JComboBox)this.getComponent(FS_DROPDOWN_FID);
            this.updateFieldSourceDropDown(jComboBox, n);
        };
        listSelectionModel.addListSelectionListener(listSelectionListener);
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("NoFieldSourcePanel");
        jFrame.setDefaultCloseOperation(3);
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        Target target = schedBlock.createTarget();
        FieldSource fieldSource = schedBlock.createFieldSource();
        fieldSource.setName("fs1");
        FieldSource fieldSource2 = schedBlock.createFieldSource();
        fieldSource2.setName("fs2");
        ObservingToolController observingToolController = new ObservingToolController();
        TargetModel targetModel = new TargetModel(null, observingToolController);
        NoFieldSourcePanel noFieldSourcePanel = new NoFieldSourcePanel(targetModel);
        targetModel.setDocument(target);
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 3));
        jFrame.getContentPane().add(noFieldSourcePanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

