/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.SchedBlockTemporalEditor;
import alma.obsprep.ot.models.schedblock.SchedBlockTemporalModel;
import alma.obsprep.ot.models.schedblock.SchedBlockTemporalTabbedModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;

public class SchedBlockTemporalTabbedEditor
extends EditorWithGridBagLayout {
    public static final FieldID FID_TABBEDPANE = new FieldID("SchedBlockTemporal.tabs");
    public static final FieldID FID_ADD_BUTTON = new FieldID("SchedBlockTemporal.addBtn");
    public static final FieldID FID_DELETE_BUTTON = new FieldID("SchedBlockTemporal.delBtn");
    public static final FieldID FID_DELETE_ALL_BUTTON = new FieldID("SchedBlockTemporal.delAllBtn");
    SchedBlockTemporalEditor tempEditor;
    SchedBlockTemporalModel tempModel;
    private int selectedTabIndex = 0;
    private boolean tabSelectionListenerActivated = true;
    private Box buttonBox;
    private JButton addButton;
    private JButton deleteButton;
    private JButton deleteAllButton;
    private JTabbedPane tabbedPane;
    private final ChangeListener tabSelectionListener = changeEvent -> {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1) {
            return;
        }
        if (this.tabSelectionListenerActivated) {
            this.setEditorAtSelectedTab();
        }
    };

    public SchedBlockTemporalTabbedEditor(Model model) {
        this.tempModel = ((SchedBlockTemporalTabbedModel)model).getSchedBlockTemporalModel();
        this.tempModel.subscribe(this);
        this.tempEditor = new SchedBlockTemporalEditor(this.tempModel);
        this.registerSubView(this.tempEditor);
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public SchedBlockTemporalTabbedModel getModel() {
        return (SchedBlockTemporalTabbedModel)super.getModel();
    }

    private SchedBlock getSchedBlock() {
        return (SchedBlock)this.getModel().getDocument();
    }

    public int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    private Box createTemporalButtonBox() {
        Box box = Box.createHorizontalBox();
        this.addButton = new JButton("Add Temporal Constraint");
        this.addButton.setToolTipText("Add another temporal constraint");
        this.initEvents(this.addButton, FID_ADD_BUTTON);
        box.add(this.addButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setToolTipText("Delete temporal constraint");
        this.deleteButton.setEnabled(false);
        this.initEvents(this.deleteButton, FID_DELETE_BUTTON);
        box.add(this.deleteButton);
        this.deleteAllButton = new JButton("Delete All");
        this.deleteAllButton.setToolTipText("Delete all temporal constraint");
        this.deleteAllButton.setEnabled(false);
        this.initEvents(this.deleteAllButton, FID_DELETE_ALL_BUTTON);
        box.add(this.deleteAllButton);
        return box;
    }

    private void updateTabbedPane() {
        if (this.getSchedBlock() == null) {
            return;
        }
        if (this.getSchedBlock().getTemporalConstraintsCount() > 0) {
            this.tabbedPane.setVisible(true);
        } else {
            this.tabbedPane.setVisible(false);
        }
    }

    private void updateButtons() {
        if (this.getSchedBlock() == null) {
            return;
        }
        if (this.getSchedBlock().getTemporalConstraintsCount() > 0) {
            this.deleteButton.setEnabled(true);
            this.deleteAllButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
            this.deleteAllButton.setEnabled(false);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FID_TABBEDPANE) {
            if (object instanceof SchedBlock) {
                this.resetTabEditor((SchedBlock)object);
                this.updateTabbedPane();
                this.updateButtons();
                this.setEditorAtSelectedTab();
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                try {
                    if (n >= 0) {
                        this.tabbedPane.setSelectedIndex(n);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return;
        }
        if (fieldID == FID_ADD_BUTTON) {
            int n = this.getSchedBlock().getTemporalConstraintsCount();
            this.tabbedPane.setSelectedIndex(n - 1);
            return;
        }
        if (fieldID == FID_DELETE_BUTTON) {
            return;
        }
        if (fieldID == FID_DELETE_ALL_BUTTON) {
            return;
        }
        super.update(fieldID, object);
    }

    @Override
    protected void addComponents(String string) {
        this.setLayout(new BoxLayout(this, 3));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(0);
        this.tabbedPane.addChangeListener(this.tabSelectionListener);
        this.initEvents(this.tabbedPane, FID_TABBEDPANE);
        this.tabbedPane.setVisible(false);
        this.add(this.tabbedPane);
        this.addVerticalSpace(this, this.layout, this.constraints);
        this.buttonBox = this.createTemporalButtonBox();
        this.add(this.buttonBox);
    }

    @Override
    protected void build() {
        super.build("SchedBlockTemporalConstraints");
    }

    public void resetTabEditor(SchedBlock schedBlock) {
        this.tabbedPane.removeChangeListener(this.tabSelectionListener);
        this.tabbedPane.removeAll();
        for (int i = 1; i <= schedBlock.getTemporalConstraintsCount(); ++i) {
            this.tabbedPane.add("TC" + i, new JLabel("dummy"));
        }
        if (schedBlock.getTemporalConstraintsCount() <= this.selectedTabIndex) {
            this.selectedTabIndex = 0;
        }
        if (schedBlock.getTemporalConstraintsCount() > 0) {
            this.tabbedPane.setSelectedIndex(this.selectedTabIndex);
        }
        this.tabbedPane.addChangeListener(this.tabSelectionListener);
    }

    private void setEditorAtSelectedTab() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.getModel().setSelectedTemporalConstraintsIndex(n);
        int n2 = this.tabbedPane.indexOfComponent(this.tempEditor);
        this.tabSelectionListenerActivated = false;
        try {
            this.tabbedPane.setComponentAt(n2, new JLabel("dummy"));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.tabbedPane.setComponentAt(n, this.tempEditor);
        this.selectedTabIndex = n;
        this.tabSelectionListenerActivated = true;
    }
}

