/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintEditor;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintTableModel;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintsTable;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.MonitoringConstraintsListModel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MonitoringConstraintListEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    private static final long serialVersionUID = 6076446159232048976L;
    public static final FieldID MONITORING_CONSTRAINT_TABLE_FID = new FieldID("TemporalParameterTable");
    public static final FieldID addMCFID = new FieldID("addMonConstFID");
    public static final FieldID delMCFID = new FieldID("delMonConstFID");
    public static final FieldID delAllMCFID = new FieldID("deleteAllMonConstFID");
    public static final FieldID upMCFID = new FieldID("upMonConstFID");
    public static final FieldID downMCFID = new FieldID("downMonConstFID");
    public static final FieldID tpCountLabelFID = new FieldID("tpCountLabelFID");
    public static final FieldID hintsLabel = new FieldID("hintsLabel");
    public static final FieldID timingParamStartDate = new FieldID("startDate");
    public static final FieldID selectIfExclusive = new FieldID("selectIfExclusive");
    public static final FieldID updateNote = new FieldID("updateNote");
    private JButton tpAddButton = null;
    private JButton tpDelButton = null;
    private JButton tpDelAllButton = null;
    private MonitoringConstraintsTable mcTable = null;
    private final String COUNT_LABEL_STRING = "Monitoring specified : ";
    public static final int MIN_TABLE_WIDTH = 900;
    public static final int TABLE_HEIGHT = 150;
    public static final int ROW_HEIGHT = 35;

    public MonitoringConstraintListEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected MonitoringConstraintListEditor() {
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addLabel(jPanel, gridBagLayout, gridBagConstraints, tpCountLabelFID, "", "Monitoring specified : ");
        this.addTable(jPanel, gridBagLayout, gridBagConstraints, string);
        this.addNonCollapsingGroup(jPanel, string);
        jPanel.setBorder(null);
    }

    protected void addTable(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        MonitoringConstraintsListModel monitoringConstraintsListModel = (MonitoringConstraintsListModel)this.getModel();
        this.tpAddButton = this.makeButton(addMCFID, "Add", "Add Time Range");
        this.tpDelButton = this.makeButton(delMCFID, "Delete", "Delete Time Range");
        this.tpDelAllButton = this.makeButton(delAllMCFID, "DeleteAll", "DeleteAll");
        this.mcTable = new MonitoringConstraintsTable(monitoringConstraintsListModel.getMonitoringConstraintsTableModel());
        int n = Math.max(900, this.mcTable.getPreferredEditorWidth());
        int n2 = n / 4 - 10;
        int n3 = this.tpAddButton.getPreferredSize().height;
        this.tpAddButton.setPreferredSize(new Dimension(n2, n3));
        this.tpDelButton.setPreferredSize(new Dimension(n2, n3));
        this.tpDelAllButton.setPreferredSize(new Dimension(n2, n3));
        this.mcTable.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        this.mcTable.setRowHeight(35);
        this.mcTable.getTableHeader().setReorderingAllowed(false);
        this.mcTable.setSelectionMode(0);
        this.mcTable.setColumnSelectionAllowed(false);
        this.mcTable.getSelectionModel().addListSelectionListener(this);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.mcTable);
        scrollWhenFocusedPane.setPreferredSize(new Dimension(n, 150));
        this.mcTable.setToolTipText("Details of Constraints");
        this.mcTable.setName("TimingConstraintListEditor.tpTable");
        this.initEvents(this.mcTable, MONITORING_CONSTRAINT_TABLE_FID);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.tpAddButton);
        jPanel2.add(this.tpDelButton);
        jPanel2.add(this.tpDelAllButton);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
    }

    @Override
    protected void build() {
        super.build("");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        MonitoringConstraintsListModel monitoringConstraintsListModel = (MonitoringConstraintsListModel)this.getModel();
        if (fieldID.equals(addMCFID)) {
            int n = this.mcTable.getSelectedRow();
            this.closeEditorIfOpen();
            monitoringConstraintsListModel.addMonitoringConstraint(n + 1);
        } else if (fieldID.equals(delMCFID)) {
            int n = this.mcTable.getSelectedRow();
            this.closeEditorIfOpen();
            monitoringConstraintsListModel.deleteMonitoringConstraint(n);
            if (n == 0) {
                if (monitoringConstraintsListModel.getMonitoringConstraintCount() != 0) {
                    this.mcTable.setRowSelectionInterval(n, n);
                }
            } else if (n == monitoringConstraintsListModel.getMonitoringConstraintCount()) {
                this.mcTable.setRowSelectionInterval(n - 1, n - 1);
            } else if (n != -1) {
                this.mcTable.setRowSelectionInterval(n, n);
            }
        } else if (fieldID.equals(delAllMCFID)) {
            this.closeEditorIfOpen();
            monitoringConstraintsListModel.clearMonitoringConstraintList();
        } else if (fieldID.equals(upMCFID)) {
            int n = this.mcTable.getSelectedRow();
            if (n > 0) {
                monitoringConstraintsListModel.upMonitoringConstraints(n);
                this.mcTable.setRowSelectionInterval(n - 1, n - 1);
            }
        } else if (fieldID.equals(downMCFID)) {
            int n = this.mcTable.getSelectedRow();
            if (n != -1 && n < this.getMonitoringConstraintCount() - 1) {
                monitoringConstraintsListModel.downMonitoringConstraints(n);
                this.mcTable.setRowSelectionInterval(n + 1, n + 1);
            }
        } else if (fieldID.equals(timingParamStartDate)) {
            int n = this.mcTable.getSelectedRow();
            int n2 = this.mcTable.getSelectedColumn();
            this.mcTable.setValueAt((String)object, n, n2);
        } else if (!fieldID.equals(tpCountLabelFID)) {
            if (fieldID.equals(MONITORING_CONSTRAINT_TABLE_FID)) {
                this.fireTableDataChanged();
                return;
            }
            if (fieldID.equals(updateNote)) {
                String string = object.toString();
                monitoringConstraintsListModel.updateAssociatedeNote(string);
                return;
            }
            super.update(fieldID, object);
        }
        this.updateTargetCountLabel();
        this.setButtons(monitoringConstraintsListModel);
    }

    private void closeEditorIfOpen() {
        MonitoringConstraintEditor monitoringConstraintEditor = (MonitoringConstraintEditor)this.mcTable.getEditorComponent();
        if (monitoringConstraintEditor != null) {
            int n = this.mcTable.getSelectedRow();
            monitoringConstraintEditor.stopCellEditing();
            this.mcTable.setRowSelectionInterval(n, n);
        }
    }

    private void fireTableDataChanged() {
        MonitoringConstraintTableModel monitoringConstraintTableModel = (MonitoringConstraintTableModel)this.mcTable.getModel();
        monitoringConstraintTableModel.fireTableDataChanged();
    }

    private int getMonitoringConstraintCount() {
        MonitoringConstraintsListModel monitoringConstraintsListModel = (MonitoringConstraintsListModel)this.getModel();
        return null == monitoringConstraintsListModel ? 0 : monitoringConstraintsListModel.getMonitoringConstraintCount();
    }

    public void updateTargetCountLabel() {
        JLabel jLabel = (JLabel)this.getComponent(tpCountLabelFID);
        jLabel.setText("Monitoring specified : " + this.getMonitoringConstraintCount());
    }

    private void setButtons(MonitoringConstraintsListModel monitoringConstraintsListModel) {
        if (this.tpAddButton == null || this.tpDelButton == null || this.tpDelAllButton == null) {
            return;
        }
        int n = this.getMonitoringConstraintCount();
        this.setEnabled(this.tpAddButton, true);
        this.setEnabled(this.tpDelButton, n > 0 && this.mcTable.getSelectedRow() != -1);
        this.setEnabled(this.tpDelAllButton, n > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons((MonitoringConstraintsListModel)this.getModel());
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Single Field Editor");
        jFrame.setDefaultCloseOperation(3);
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        MonitoringConstraintsListModel monitoringConstraintsListModel = new MonitoringConstraintsListModel(null);
        MonitoringConstraintListEditor monitoringConstraintListEditor = new MonitoringConstraintListEditor(monitoringConstraintsListModel);
        monitoringConstraintsListModel.setDocument(performanceParameters);
        TestUtilities.runTestApp(monitoringConstraintListEditor);
    }
}

