/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.ot.editors.sciencegoals.TimingConstraintsListEditor;
import alma.obsprep.ot.models.sciencegoals.TimingConstraintsListModel;
import alma.valuetypes.Time;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class TimingConstraintTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -2474027992060494967L;
    private static final AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    private static final int MIN_ADVISED_TIME_MARGIN = (int)almaPolicies.getMinAdvisedTimeMargin().getContentInUnits(Time.UNIT_D);
    private TimingConstraintsListModel timingConstraintsListModel;

    public TimingConstraintTableModel(TimingConstraintsListModel timingConstraintsListModel) {
        this.timingConstraintsListModel = timingConstraintsListModel;
    }

    public void setModel(TimingConstraintsListModel timingConstraintsListModel) {
        this.timingConstraintsListModel = timingConstraintsListModel;
    }

    @Override
    public int getRowCount() {
        if (this.timingConstraintsListModel == null) {
            return 0;
        }
        return this.timingConstraintsListModel.getTemporalParametersCount();
    }

    @Override
    public int getColumnCount() {
        return ColumnDescriptor.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        ColumnDescriptor columnDescriptor = ColumnDescriptor.getColumnDescriptor(n);
        return columnDescriptor.getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        ColumnDescriptor columnDescriptor = ColumnDescriptor.getColumnDescriptor(n);
        return columnDescriptor.getColumnClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        TemporalParameters temporalParameters = this.timingConstraintsListModel.getTemporalParameters(n);
        ColumnDescriptor columnDescriptor = ColumnDescriptor.getColumnDescriptor(n2);
        switch (columnDescriptor) {
            case START: {
                return temporalParameters.getStartTimeInDate();
            }
            case END: {
                return temporalParameters.getEndTimeInDate();
            }
        }
        String string = "Invalid column index : " + n2 + "(descriptor = " + String.valueOf((Object)columnDescriptor) + ")";
        throw new IllegalArgumentException(string);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.timingConstraintsListModel != null && n <= this.timingConstraintsListModel.getTemporalParametersCount()) {
            TemporalParameters temporalParameters = this.timingConstraintsListModel.getTemporalParameters(n);
            ColumnDescriptor columnDescriptor = ColumnDescriptor.getColumnDescriptor(n2);
            switch (columnDescriptor) {
                case START: {
                    if (object instanceof ZonedDateTime) {
                        temporalParameters.setStartTimeInDate((ZonedDateTime)object);
                    } else if (object instanceof String) {
                        temporalParameters.setStartTime((String)object);
                    }
                    ZonedDateTime zonedDateTime = temporalParameters.getStartTimeInDate().plus(MIN_ADVISED_TIME_MARGIN, ChronoUnit.DAYS);
                    if (!temporalParameters.getEndTimeInDate().isBefore(zonedDateTime)) break;
                    temporalParameters.setEndTimeInDate(zonedDateTime);
                    break;
                }
                case END: {
                    if (object instanceof ZonedDateTime) {
                        temporalParameters.setEndTimeInDate((ZonedDateTime)object);
                        break;
                    }
                    if (!(object instanceof String)) break;
                    temporalParameters.setEndTime((String)object);
                    break;
                }
                default: {
                    String string = "Invalid column index : " + n2 + "(descriptor = " + String.valueOf((Object)columnDescriptor) + ")";
                    throw new IllegalArgumentException(string);
                }
            }
            this.timingConstraintsListModel.publish(TimingConstraintsListEditor.TEMPORAL_PARAM_TABLE_FID, temporalParameters);
        }
    }

    public Object[] getReferenceValues() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ColumnDescriptor columnDescriptor : ColumnDescriptor.values()) {
            arrayList.add(columnDescriptor.referenceValue);
        }
        Object[] objectArray = new Object[arrayList.size()];
        return arrayList.toArray(objectArray);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(TableModelListener.class, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(TableModelListener.class, tableModelListener);
    }

    @Override
    public TableModelListener[] getTableModelListeners() {
        return (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
    }

    @Override
    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void fireTableRowsInserted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 1));
    }

    @Override
    public void fireTableRowsUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 0));
    }

    @Override
    public void fireTableRowsDeleted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, -1));
    }

    @Override
    public void fireTableCellUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n, n2));
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableModelListener.class) continue;
            ((TableModelListener)objectArray[i + 1]).tableChanged(tableModelEvent);
        }
    }

    public static enum ColumnDescriptor {
        START("<html><center>Start Date/Time (UTC)<br></center></html>", Date.class, new Date()),
        END("<html><center>End Date/Time (UTC)<br></center></html>", Date.class, new Date());

        public final String columnName;
        public final Class<?> columnClass;
        public final Object referenceValue;

        protected static int getColumnCount() {
            return ColumnDescriptor.values().length;
        }

        protected static ColumnDescriptor getColumnDescriptor(int n) {
            return ColumnDescriptor.values()[n];
        }

        public int getColumnIndex() {
            int n = 0;
            for (ColumnDescriptor columnDescriptor : ColumnDescriptor.values()) {
                if (this == columnDescriptor) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private ColumnDescriptor(String string2, Class<?> clazz, Object object) {
            this.columnName = string2;
            this.columnClass = clazz;
            this.referenceValue = object;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        public Object getReferenceValue() {
            return this.referenceValue;
        }
    }
}

