/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.acs.commandcenter.gui.thirdparty.SpringUtilities;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.factory.TextField;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.Dialog;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.services.submission.RemoteProgressListener;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.IHelpfulError;
import alma.obsprep.util.job.AbstractJob;
import alma.obsprep.util.job.JobUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ObsProjectChooser
extends JPanel {
    private static final long serialVersionUID = -3210424097579377994L;
    protected static DialogId DIALOG_DELETE_PROJECT = new DialogId("ProjectFinder.DeleteProject");
    protected static final String NULL = "";
    protected Log.Logger logger = Log.logger((Object)this);
    protected ProjectRepository repository;
    protected JButton btnChoose;
    protected JButton btnDone;
    protected JButton btnDelete;
    protected JButton btnSearch;
    protected JCheckBox chkIgnoreCase;
    protected JCheckBox chkExactMatch;
    protected JCheckBox chkIncludeStatus;
    protected JRadioButton allProjectsRadioButton;
    protected JRadioButton allMyProjectsRadioButton;
    protected JRadioButton byPIRadioButton;
    protected JRadioButton byProjectNameRadioButton;
    protected JRadioButton byProjectCodeRadioButton;
    protected TextField txtPI;
    protected TextField txtProjName;
    protected TextField txtProjCode;
    private JPanel pnlAdv;
    private final RemoteProgressListener progressListener = (n, n2, string) -> new AbstractJob("Update status label", true, JobUtility.swing){

        @Override
        public void job() throws Exception {
            ObsProjectChooser.this.lblStatus.setText(string + " (" + (n + 1) + "/" + n2 + ")");
        }
    }.go();
    private int projectNameColumnIndex;
    protected Vector<Vector<String>> modelData;
    protected Vector<String> columnNames;
    protected Table table;
    protected ReadonlyModel tableModel;
    protected JLabel lblStatus;
    protected ChangeListener changeListener;
    protected String username;
    protected JobUtility.CustomExecutor networkQueue = JobUtility.createCustomExecutor(3, "OT-NetworkQueue");
    protected AbstractJob currentSearchJob;
    private boolean everpaint;
    private int projectIDColumnIndex;

    public ObsProjectChooser(@NonNull ChangeListener changeListener, final @NonNull ProjectRepository projectRepository) {
        super(new BorderLayout());
        if (changeListener == null) {
            throw new NullPointerException("projectChangeListener is marked non-null but is null");
        }
        if (projectRepository == null) {
            throw new NullPointerException("repository is marked non-null but is null");
        }
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.changeListener = changeListener;
        this.repository = projectRepository;
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        jPanel.setBorder(new TitledBorder(new LineBorder(Color.black, 2), " Found Projects "));
        jPanel.setLayout(new BorderLayout());
        this.setupTableColumns();
        this.modelData = new Vector();
        this.tableModel = new ReadonlyModel(this.modelData, this.columnNames);
        this.table = new Table(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowSorter(new TableRowSorter<ReadonlyModel>(this.tableModel));
        this.table.setSelectionMode(0);
        this.table.setFocusPainted(false);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.table.setAutoResizeMode(3);
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        Box box = Box.createVerticalBox();
        jPanel.add((Component)box, "East");
        this.btnChoose = new JButton("Open", Icons.okay);
        box.add(this.btnChoose);
        this.btnChoose.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.btnChoose.setEnabled(this.tableModel.getRowCount() > 0 && this.table.getSelectedRowCount() > 0));
        box.add(Box.createVerticalStrut(10));
        JSeparator jSeparator = new JSeparator(0);
        box.add(jSeparator);
        box.add(Box.createVerticalStrut(10));
        this.btnDelete = new JButton("Cancel Project", Icons.destroy);
        box.add(this.btnDelete);
        box.add(Box.createVerticalStrut(20));
        box.add(Box.createVerticalGlue());
        this.btnDone = new JButton("Cancel", Icons.close);
        box.add(this.btnDone);
        Dimension dimension = new Dimension(Short.MAX_VALUE, new JButton().getPreferredSize().height);
        List.of(this.btnChoose, this.btnDelete, this.btnDone, jSeparator).stream().forEach(jComponent -> jComponent.setMaximumSize(dimension));
        this.lblStatus = new JLabel(" ");
        this.lblStatus.setBorder(new EmptyBorder(0, 5, 0, 0));
        jPanel.add((Component)this.lblStatus, "South");
        JPanel jPanel2 = new JPanel();
        this.add((Component)jPanel2, "North");
        jPanel2.setBorder(new TitledBorder(new LineBorder(Color.black, 2), " Search for Projects "));
        jPanel2.setLayout(new BorderLayout());
        this.pnlAdv = new JPanel(new SpringLayout());
        this.allProjectsRadioButton = new JRadioButton("all projects");
        this.pnlAdv.add(this.allProjectsRadioButton);
        this.pnlAdv.add(new JPanel());
        SpringUtilities.makeCompactGrid((Container)this.pnlAdv, (int)0, (int)2);
        jPanel2.add((Component)this.pnlAdv, "North");
        JPanel jPanel3 = new JPanel(new SpringLayout());
        this.allMyProjectsRadioButton = new JRadioButton("all my projects");
        jPanel3.add(this.allMyProjectsRadioButton);
        jPanel3.add(new JPanel());
        this.byPIRadioButton = new JRadioButton("by PI ALMA ID");
        jPanel3.add(this.byPIRadioButton);
        this.txtPI = new TextField(20);
        jPanel3.add(this.txtPI);
        this.byProjectCodeRadioButton = new JRadioButton("by Project Code");
        jPanel3.add(this.byProjectCodeRadioButton);
        this.txtProjCode = new TextField(20);
        jPanel3.add(this.txtProjCode);
        this.byProjectNameRadioButton = new JRadioButton("by Project Name");
        jPanel3.add(this.byProjectNameRadioButton);
        this.txtProjName = new TextField(20);
        jPanel3.add(this.txtProjName);
        SpringUtilities.makeCompactGrid((Container)jPanel3, (int)0, (int)2);
        jPanel2.add((Component)jPanel3, "Center");
        this.allProjectsRadioButton.setMnemonic('a');
        this.allMyProjectsRadioButton.setMnemonic('m');
        this.byPIRadioButton.setMnemonic('i');
        this.byProjectCodeRadioButton.setMnemonic('c');
        this.byProjectCodeRadioButton.setDisplayedMnemonicIndex(this.byProjectCodeRadioButton.getText().indexOf(67));
        this.byProjectNameRadioButton.setMnemonic('n');
        jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(0, 20, 0, 5));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(Box.createVerticalGlue());
        this.chkIgnoreCase = new JCheckBox("Ignore Case");
        jPanel3.add(this.chkIgnoreCase);
        this.chkExactMatch = new JCheckBox("Exact Match");
        jPanel3.add(this.chkExactMatch);
        this.chkIncludeStatus = new JCheckBox("Retrieve Status");
        jPanel3.add(this.chkIncludeStatus);
        jPanel3.add(Box.createVerticalStrut(5));
        this.btnSearch = new JButton("   Search   ");
        jPanel3.add(this.btnSearch);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel2.add((Component)jPanel3, "East");
        TextField.ActivationRequestHandler activationRequestHandler = textField -> {
            this.byPIRadioButton.setSelected(this.txtPI.hasFocus());
            this.byProjectNameRadioButton.setSelected(this.txtProjName.hasFocus());
            this.byProjectCodeRadioButton.setSelected(this.txtProjCode.hasFocus());
        };
        List.of(this.txtPI, this.txtProjName, this.txtProjCode).stream().forEach(textField -> textField.setActivationRequestHandler(activationRequestHandler));
        ItemListener itemListener = itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                boolean bl = this.byPIRadioButton.isSelected();
                this.txtPI.setActive(bl);
                if (bl) {
                    this.txtPI.requestFocusInWindow();
                }
                boolean bl2 = this.byProjectNameRadioButton.isSelected();
                this.txtProjName.setActive(bl2);
                if (bl2) {
                    this.txtProjName.requestFocusInWindow();
                }
                boolean bl3 = this.byProjectCodeRadioButton.isSelected();
                this.txtProjCode.setActive(bl3);
                if (bl3) {
                    this.txtProjCode.requestFocusInWindow();
                }
                this.chkExactMatch.setEnabled(this.txtPI.isActive() || this.txtProjName.isActive() || this.txtProjCode.isActive());
                this.chkIgnoreCase.setEnabled(this.chkExactMatch.isEnabled());
            }
        };
        List.of(this.allProjectsRadioButton, this.allMyProjectsRadioButton, this.byPIRadioButton, this.byProjectCodeRadioButton, this.byProjectNameRadioButton).stream().forEach(jRadioButton -> jRadioButton.addItemListener(itemListener));
        ButtonGroup buttonGroup = new ButtonGroup();
        List.of(this.allProjectsRadioButton, this.allMyProjectsRadioButton, this.byPIRadioButton, this.byProjectCodeRadioButton, this.byProjectNameRadioButton).stream().forEach(jRadioButton -> buttonGroup.add((AbstractButton)jRadioButton));
        this.chkIgnoreCase.setSelected(true);
        this.chkExactMatch.setSelected(false);
        this.chkIncludeStatus.setSelected(false);
        this.chkIncludeStatus.setVisible(false);
        this.btnDelete.setVisible(false);
        this.chkIgnoreCase.setVisible(false);
        this.chkExactMatch.setVisible(false);
        this.allMyProjectsRadioButton.setSelected(true);
        this.table.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (ObsProjectChooser.this.table.getSelectedRow() == -1) {
                    ObsProjectChooser.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        });
        ActionListener actionListener = actionEvent -> {
            String string = this.getSelectedEntityId();
            if (string != NULL) {
                this.fireChosen(string);
            }
        };
        this.btnChoose.addActionListener(actionListener);
        this.table.addActionListener(actionListener);
        this.btnDone.addActionListener(actionEvent -> this.fireChosen(NULL));
        this.btnDelete.addActionListener(actionEvent -> {
            final String string = this.getSelectedEntityId();
            if (string == NULL || !GUIUtilities.confirm(DIALOG_DELETE_PROJECT, "This will delete project \"" + this.getSelectedProjectName() + "\" from the archive.\nUndoing this operation is possible but requires help from external tools.\nAre you sure?")) {
                return;
            }
            this.lblStatus.setText(" ");
            new AbstractJob("delete project " + string, false, this.networkQueue){

                @Override
                public void job() throws Exception {
                    try {
                        final Vector<String> vector = ObsProjectChooser.this.getSelectedRow();
                        projectRepository.delete(string);
                        new AbstractJob("remove row", false, JobUtility.swing){

                            @Override
                            public void job() throws Exception {
                                ObsProjectChooser.this.lblStatus.setText("1 project deleted");
                                ObsProjectChooser.this.modelData.remove(vector);
                                ObsProjectChooser.this.tableModel.fireTableDataChanged();
                            }
                        }.go();
                    }
                    catch (Exception exception) {
                        String string2 = "Delete operation cancelled: " + string + ": " + exception.getMessage();
                        ObsProjectChooser.this.logger.log(Level.FINE, string2, (Throwable)exception);
                        GUIUtilities.error(null, string2, exception);
                    }
                }
            }.go();
        });
        this.btnSearch.addActionListener(actionEvent -> {
            boolean bl;
            boolean bl2;
            String string;
            int n;
            this.lblStatus.setText("Searching");
            this.btnSearch.setEnabled(false);
            if (this.allProjectsRadioButton.isSelected()) {
                n = 2;
                string = NULL;
                bl2 = true;
                bl = true;
            } else if (this.allMyProjectsRadioButton.isSelected()) {
                n = 1;
                string = "__{RequestingUser}__";
                bl2 = true;
                bl = false;
            } else if (this.byPIRadioButton.isSelected()) {
                n = 0;
                string = StringUtils.trim((String)this.txtPI.getText());
                bl2 = !this.chkIgnoreCase.isSelected();
                bl = !this.chkExactMatch.isSelected();
            } else if (this.byProjectNameRadioButton.isSelected()) {
                n = 2;
                string = this.txtProjName.getText();
                bl2 = !this.chkIgnoreCase.isSelected();
                bl = !this.chkExactMatch.isSelected();
            } else if (this.byProjectCodeRadioButton.isSelected()) {
                n = 3;
                string = StringUtils.trim((String)this.txtProjCode.getText());
                bl2 = !this.chkIgnoreCase.isSelected();
                bl = !this.chkExactMatch.isSelected();
            } else {
                return;
            }
            final boolean bl3 = this.chkIncludeStatus.isSelected();
            this.currentSearchJob = new AbstractJob("search for projects", false, this.networkQueue){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void job() throws Exception {
                    block4: {
                        try {
                            final String[][] stringArray = ObsProjectChooser.this.search(n, string, bl2, bl);
                            if (this != ObsProjectChooser.this.currentSearchJob) break block4;
                            new AbstractJob("show results", false, JobUtility.swing){

                                @Override
                                public void job() throws Exception {
                                    ObsProjectChooser.this.lblStatus.setText(stringArray.length + " project(s) found");
                                    ObsProjectChooser.this.setListContent(stringArray, bl3);
                                    if (stringArray.length > 0) {
                                        ObsProjectChooser.this.table.requestFocusInWindow();
                                    }
                                }
                            }.go();
                        }
                        catch (Exception exception) {
                            try {
                                String string3 = exception instanceof IHelpfulError ? ((IHelpfulError)((Object)exception)).getUserMeaning() : exception.getMessage();
                                final String string2 = "Search operation cancelled: " + string3;
                                new AbstractJob("show error", false, JobUtility.swing){

                                    @Override
                                    public void job() {
                                        if (!ObsProjectChooser.this.lblStatus.isShowing()) {
                                            return;
                                        }
                                        ObsProjectChooser.this.lblStatus.setText("Search Failed");
                                        GUIUtilities.error(null, string2, exception);
                                    }
                                }.go();
                            }
                            catch (Throwable throwable) {
                                new AbstractJob("re-enable search button", false, JobUtility.swing){

                                    @Override
                                    public void job() {
                                        if (ObsProjectChooser.this.btnSearch != null) {
                                            ObsProjectChooser.this.btnSearch.setEnabled(true);
                                        }
                                    }
                                }.go();
                                throw throwable;
                            }
                            new /* invalid duplicate definition of identical inner class */.go();
                        }
                    }
                    new /* invalid duplicate definition of identical inner class */.go();
                }
            }.go();
        });
        this.setName("ProjectFinder");
        this.btnChoose.setName("ProjectFinder.btnChoose");
        this.btnDone.setName("ProjectFinder.btnDone");
        this.btnDelete.setName("ProjectFinder.btnDelete");
        this.btnSearch.setName("ProjectFinder.btnSearch");
        this.chkIgnoreCase.setName("ProjectFinder.chkIgnoreCase");
        this.chkExactMatch.setName("ProjectFinder.chkExactMatch");
        this.chkIncludeStatus.setName("ProjectFinder.chkIncludeStatus");
        this.allProjectsRadioButton.setName("ProjectFinder.radAll");
        this.allMyProjectsRadioButton.setName("ProjectFinder.radMine");
        this.byPIRadioButton.setName("ProjectFinder.radPI");
        this.byProjectNameRadioButton.setName("ProjectFinder.radProjName");
        this.byProjectCodeRadioButton.setName("ProjectFinder.radProjCode");
        this.txtPI.setName("ProjectFinder.txtPI");
        this.txtProjName.setName("ProjectFinder.txtProjName");
        this.txtProjCode.setName("ProjectFinder.txtProjCode");
        this.table.setName("ProjectFinder.tblResults");
        this.lblStatus.setName("ProjectFinder.lblStatus");
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.everpaint) {
            JRadioButton[] jRadioButtonArray;
            this.everpaint = true;
            for (JRadioButton jRadioButton : jRadioButtonArray = new JRadioButton[]{this.allProjectsRadioButton, this.allMyProjectsRadioButton, this.byPIRadioButton, this.byProjectNameRadioButton, this.byProjectCodeRadioButton}) {
                if (!jRadioButton.isSelected()) continue;
                jRadioButton.requestFocusInWindow();
                break;
            }
        }
    }

    protected void fireChosen(String string) {
        ChangeEvent changeEvent = new ChangeEvent(string);
        this.changeListener.stateChanged(changeEvent);
    }

    public void cleanUp() {
        this.networkQueue.shutdown();
    }

    protected String[][] search(int n, String string, boolean bl, boolean bl2) throws PersistenceException {
        try {
            return this.repository.query2(n, string, bl, bl2, this.progressListener);
        }
        catch (PersistenceException persistenceException) {
            if (persistenceException.getErrorCode() == 401) {
                return new String[0][];
            }
            throw persistenceException;
        }
    }

    protected void setupTableColumns() {
        this.columnNames = new Vector();
        this.columnNames.add("Project Name");
        this.projectNameColumnIndex = this.columnNames.size() - 1;
        this.columnNames.add("Project Code");
        this.columnNames.add("PI ALMA ID");
        this.columnNames.add("Creation Time");
        this.columnNames.add("Submission Time");
        this.columnNames.add("Project ID");
        this.projectIDColumnIndex = this.columnNames.size() - 1;
    }

    protected String getSelectedProjectName() {
        return this.getSelectedValue(this.projectNameColumnIndex);
    }

    protected String getSelectedEntityId() {
        return this.getSelectedValue(this.projectIDColumnIndex);
    }

    protected void setListContent(String[][] stringArray, boolean bl) {
        this.modelData.clear();
        for (String[] stringArray2 : stringArray) {
            Vector<String> vector = new Vector<String>();
            vector.add(stringArray2[1]);
            vector.add(stringArray2[2]);
            vector.add(stringArray2[3]);
            vector.add(stringArray2[4]);
            vector.add(stringArray2[5]);
            vector.add(stringArray2[0]);
            this.modelData.add(vector);
        }
        this.tableModel.fireTableDataChanged();
        ColumnResizer.adjustColumnPreferredWidths(this.table);
    }

    protected String getSelectedValue(int n) {
        Vector<String> vector = this.getSelectedRow();
        if (vector == null) {
            return NULL;
        }
        return vector.get(n);
    }

    protected Vector<String> getSelectedRow() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return null;
        }
        n = this.table.convertRowIndexToModel(n);
        return this.modelData.get(n);
    }

    protected class ReadonlyModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 2882981784374408252L;

        ReadonlyModel(Vector<? extends Vector> vector, Vector<?> vector2) {
            super(vector, vector2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    public static class DefaultDialog
    extends Dialog
    implements ChangeListener {
        private static final long serialVersionUID = 8282898081357338361L;
        private final ObsProjectChooser chooser;
        protected String answer;

        public DefaultDialog(ProjectRepository projectRepository) {
            this.setTitle("Find Projects In ALMA Archive");
            this.setModal(true);
            this.setSize(1050, 500);
            this.setLocationRelativeTo(this.getOwner());
            this.chooser = new ObsProjectChooser(this, projectRepository);
            this.getContentPane().add(this.chooser);
            this.setDefaultButton(this.chooser.btnSearch);
            this.setAdvancedOptionsVisible(false);
        }

        public String letUserChooseProject() {
            this.answer = null;
            this.setVisible(true);
            this.chooser.cleanUp();
            return this.answer;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            String string = (String)changeEvent.getSource();
            this.answer = string == ObsProjectChooser.NULL ? null : string;
            this.setVisible(false);
        }

        public void setAdvancedOptionsVisible(boolean bl) {
            this.chooser.pnlAdv.setVisible(bl);
            this.chooser.allProjectsRadioButton.setEnabled(bl);
        }
    }
}

