/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.acs.commandcenter.gui.thirdparty.SpringUtilities;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.factory.TextField;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.Dialog;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.persistence.PersonalDb;
import alma.obsprep.ot.persistence.XPathQueries;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.VerticalFlowLayout;
import alma.obsprep.util.job.AbstractJob;
import alma.obsprep.util.job.JobUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import javax.xml.xpath.XPathExpression;

public class ObsProjectChooserPdb
extends JPanel {
    private boolean dbg = false;
    protected static DialogId DIALOG_DELETE_PROJECT = new DialogId("ProjectFinder.DeleteProject");
    protected ChangeListener outside;
    protected QueryPanel pnlQueries;
    protected DirectoryPanel pnlFolders;
    protected ResultPanel pnlResults;
    protected JLabel lblStatus;
    protected JButton btnChoose;
    protected JButton btnDone;
    protected JButton btnDelete;
    protected JButton btnSearch;
    protected File answer;
    protected Action actChoose = new AbstractAction("Open", Icons.okay){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = ObsProjectChooserPdb.this.pnlResults.getSelectedFile();
            if (file == null) {
                return;
            }
            ObsProjectChooserPdb.this.answer = ObsProjectChooserPdb.this.pnlResults.getSelectedFile();
            ObsProjectChooserPdb.this.outside.stateChanged(new ChangeEvent(ObsProjectChooserPdb.this));
        }
    };
    protected Action actDone = new AbstractAction("Done", Icons.close){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ObsProjectChooserPdb.this.answer = null;
            ObsProjectChooserPdb.this.outside.stateChanged(new ChangeEvent(ObsProjectChooserPdb.this));
        }
    };
    protected Action actDelete = new AbstractAction("Delete", Icons.destroy){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final File file = ObsProjectChooserPdb.this.pnlResults.getSelectedFile();
            if (file == null) {
                return;
            }
            if (!GUIUtilities.confirm(DIALOG_DELETE_PROJECT, "This will delete file \"" + String.valueOf(file) + "\" permanently.\nAre you sure?")) {
                return;
            }
            ObsProjectChooserPdb.this.lblStatus.setText(" ");
            new AbstractJob("delete file " + String.valueOf(file), false, JobUtility.otqueue){

                @Override
                public void job() throws Exception {
                    try {
                        file.delete();
                        new AbstractJob("remove row", false, JobUtility.swing){

                            @Override
                            public void job() throws Exception {
                                ObsProjectChooserPdb.this.lblStatus.setText("1 project deleted");
                                ObsProjectChooserPdb.this.pnlResults.removeResult(file);
                            }
                        }.go();
                    }
                    catch (Exception exception) {
                        String string = "Failed to delete " + String.valueOf(file) + ": " + exception.getMessage();
                        GUIUtilities.error(null, string, exception);
                    }
                }
            }.go();
        }
    };
    protected Action actSearch = new AbstractAction("Search"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ObsProjectChooserPdb.this.lblStatus.setText("searching...");
            final StopSearchAction stopSearchAction = new StopSearchAction();
            ObsProjectChooserPdb.this.btnSearch.setAction(stopSearchAction);
            ObsProjectChooserPdb.this.pnlResults.clearResults();
            new AbstractJob("run search", false, JobUtility.otqueue){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void job() throws Exception {
                    try {
                        XPathQueries.PredefinedQuery predefinedQuery = ObsProjectChooserPdb.this.pnlQueries.getSelectedQuery();
                        PersonalDb personalDb = new PersonalDb();
                        XPathExpression xPathExpression = personalDb.compile(predefinedQuery.expression());
                        PersonalDb.Cursor cursor = personalDb.query(ObsProjectChooserPdb.this.pnlFolders.getFiles(), predefinedQuery.aotEntry, xPathExpression);
                        while (cursor.hasNext()) {
                            final PersonalDb.FileResult fileResult = cursor.next();
                            if (!stopSearchAction.stopRequested) {
                                if (ObsProjectChooserPdb.this.dbg) {
                                    Thread.sleep(1000L);
                                }
                                new AbstractJob("display results", false, JobUtility.swing){

                                    @Override
                                    public void job() throws Exception {
                                        ObsProjectChooserPdb.this.pnlResults.addResult(fileResult);
                                    }
                                }.go();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        new AbstractJob("display results", false, JobUtility.swing){

                            @Override
                            public void job() throws Exception {
                                ObsProjectChooserPdb.this.lblStatus.setText(ObsProjectChooserPdb.this.pnlResults.getResultCount() + " project(s) found");
                                ObsProjectChooserPdb.this.btnSearch.setAction(ObsProjectChooserPdb.this.actSearch);
                            }
                        }.go();
                        throw throwable;
                    }
                    new /* invalid duplicate definition of identical inner class */.go();
                }
            }.go();
        }
    };

    public static void main(String[] stringArray) {
        try {
            GuiFactory guiFactory = GuiFactory.getFactory();
            guiFactory.giveFileChooser("finder", "personaldb/marcus");
            DefaultDialog defaultDialog = new DefaultDialog(guiFactory);
            defaultDialog.chooser.dbg = true;
            File file = defaultDialog.letUserChooseProject();
            if (file == null) {
                System.out.println("you cancelled");
            } else {
                System.out.println("you chose " + String.valueOf(file));
            }
            defaultDialog.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ObsProjectChooserPdb(ChangeListener changeListener, GuiFactory guiFactory) {
        this.outside = changeListener;
        this.pnlQueries = new QueryPanel();
        this.pnlFolders = new DirectoryPanel(guiFactory);
        this.lblStatus = new JLabel(" ");
        this.pnlResults = new ResultPanel();
        this.btnChoose = new JButton(this.actChoose);
        this.btnDone = new JButton(this.actDone);
        this.btnDelete = new JButton(this.actDelete);
        this.pnlResults.table.addActionListener(this.actChoose);
        this.btnSearch = new JButton(this.actSearch);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder(new LineBorder(Color.black, 2), " Search for Projects "));
        JPanel jPanel2 = new JPanel(new VerticalFlowLayout());
        jPanel2.add(this.pnlQueries);
        jPanel2.add((Component)this.pnlFolders, "Stretch Width");
        jPanel.add((Component)jPanel2, "Center");
        JComponent jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        jComponent.add(Box.createVerticalGlue());
        jComponent.add(this.btnSearch);
        jComponent.setBorder(new EmptyBorder(0, 20, 5, 5));
        jPanel.add((Component)jComponent, "East");
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new TitledBorder(new LineBorder(Color.black, 2), " Found Projects "));
        Box box = Box.createVerticalBox();
        box.add(this.btnChoose);
        box.add(Box.createVerticalStrut(10));
        jComponent = new JSeparator(0);
        box.add(jComponent);
        box.add(Box.createVerticalStrut(10));
        box.add(this.btnDelete);
        box.add(Box.createVerticalStrut(20));
        box.add(Box.createVerticalGlue());
        box.add(this.btnDone);
        Dimension dimension = new Dimension(Short.MAX_VALUE, new JButton().getPreferredSize().height);
        for (JComponent jComponent2 : Arrays.asList(this.btnChoose, this.btnDelete, this.btnDone, jComponent)) {
            jComponent2.setMaximumSize(dimension);
        }
        this.lblStatus.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.pnlResults.setPreferredSize(new Dimension(200, 200));
        jPanel2.add((Component)this.pnlResults, "Center");
        jPanel2.add((Component)box, "East");
        jPanel2.add((Component)this.lblStatus, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
    }

    public void cleanUp() {
    }

    public File getAnswer() {
        return this.answer;
    }

    public static class DefaultDialog
    extends Dialog
    implements ChangeListener {
        ObsProjectChooserPdb chooser;

        public DefaultDialog(GuiFactory guiFactory) {
            this.setTitle("Find Projects On Disk");
            this.setModal(true);
            this.chooser = new ObsProjectChooserPdb(this, guiFactory);
            this.getContentPane().add(this.chooser);
            this.setDefaultButton(this.chooser.btnSearch);
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }

        public File letUserChooseProject() {
            this.chooser.answer = null;
            this.setVisible(true);
            this.chooser.cleanUp();
            return this.chooser.getAnswer();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setVisible(false);
        }
    }

    protected class QueryPanel
    extends JPanel {
        protected ButtonGroup group;
        PredefinedQueryGui<XPathQueries.AllProjects> g1;
        PredefinedQueryGui<XPathQueries.ProjectAlmaPI> g2;
        PredefinedQueryGui<XPathQueries.ProjectCode> g3;
        PredefinedQueryGui<XPathQueries.ProjectName> g4;
        PredefinedQueryGui<XPathQueries.TestLogicalConjunction> g7;
        protected List<PredefinedQueryGui<?>> queries;
        private boolean everpainted;
        protected ItemListener radioListener;
        TextField.ActivationRequestHandler arh;

        public QueryPanel() {
            super(new SpringLayout());
            this.group = new ButtonGroup();
            this.queries = new ArrayList();
            this.radioListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    for (PredefinedQueryGui<?> predefinedQueryGui : QueryPanel.this.queries) {
                        for (TextField textField : predefinedQueryGui.txt) {
                            textField.setActive(predefinedQueryGui.rad.isSelected());
                        }
                    }
                }
            };
            this.arh = new TextField.ActivationRequestHandler(){

                @Override
                public void activationRequested(TextField textField) {
                    for (PredefinedQueryGui<?> predefinedQueryGui : QueryPanel.this.queries) {
                        for (TextField textField2 : predefinedQueryGui.txt) {
                            if (textField2 != textField) continue;
                            predefinedQueryGui.rad.setSelected(true);
                        }
                    }
                }
            };
            this.g1 = this.addQuery(new XPathQueries.AllProjects(), 0);
            this.add(this.g1.rad);
            this.add(new JPanel());
            this.add(new JPanel());
            this.g2 = this.addQuery(new XPathQueries.ProjectAlmaPI(), 1);
            this.add(this.g2.rad);
            this.add(this.g2.txt.get(0));
            this.add(new JPanel());
            this.g3 = this.addQuery(new XPathQueries.ProjectCode(), 1);
            this.add(this.g3.rad);
            this.add(this.g3.txt.get(0));
            this.add(new JPanel());
            this.g4 = this.addQuery(new XPathQueries.ProjectName(), 1);
            this.add(this.g4.rad);
            this.add(this.g4.txt.get(0));
            this.add(new JPanel());
            this.g7 = this.addQuery(new XPathQueries.TestLogicalConjunction(), 2);
            this.add(this.g7.rad);
            this.add(this.g7.txt.get(0));
            this.add(this.g7.txt.get(1));
            SpringUtilities.makeCompactGrid((Container)this, (int)0, (int)3);
        }

        public XPathQueries.PredefinedQuery getSelectedQuery() {
            if (this.g1.isSelected()) {
                return this.g1.query;
            }
            if (this.g2.isSelected()) {
                ((XPathQueries.ProjectAlmaPI)this.g2.query).varPI = this.g2.getText(0);
                return this.g2.query;
            }
            if (this.g3.isSelected()) {
                ((XPathQueries.ProjectCode)this.g3.query).varPrjCode = this.g3.getText(0);
                return this.g3.query;
            }
            if (this.g4.isSelected()) {
                ((XPathQueries.ProjectName)this.g4.query).varPrjName = this.g4.getText(0);
                return this.g4.query;
            }
            if (this.g7.isSelected()) {
                ((XPathQueries.TestLogicalConjunction)this.g7.query).varPI = this.g7.getText(0);
                ((XPathQueries.TestLogicalConjunction)this.g7.query).varStatus = this.g7.getText(1);
                return this.g7.query;
            }
            return null;
        }

        <T extends XPathQueries.PredefinedQuery> PredefinedQueryGui<T> addQuery(T t, int n) {
            PredefinedQueryGui predefinedQueryGui = new PredefinedQueryGui();
            predefinedQueryGui.query = t;
            predefinedQueryGui.rad = new JRadioButton(t.prettyName);
            for (int i = 0; i < n; ++i) {
                predefinedQueryGui.txt.add(new TextField(15));
            }
            for (TextField textField : predefinedQueryGui.txt) {
                textField.setActivationRequestHandler(this.arh);
            }
            this.group.add(predefinedQueryGui.rad);
            predefinedQueryGui.rad.addItemListener(this.radioListener);
            this.queries.add(predefinedQueryGui);
            return predefinedQueryGui;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (!this.everpainted && this.queries.size() > 0) {
                this.everpainted = true;
                JRadioButton jRadioButton = this.queries.get((int)0).rad;
                jRadioButton.setSelected(true);
                jRadioButton.requestFocusInWindow();
            }
        }

        protected class PredefinedQueryGui<T extends XPathQueries.PredefinedQuery> {
            protected T query;
            protected JRadioButton rad;
            protected List<TextField> txt = new ArrayList<TextField>();

            protected PredefinedQueryGui() {
            }

            boolean isSelected() {
                return this.rad.isSelected();
            }

            String getText(int n) {
                return this.txt.get(n).getText();
            }
        }
    }

    protected class DirectoryPanel
    extends JPanel {
        OTTextField txtDir;
        JFileChooser chDir;
        JCheckBox chkSub;
        boolean everpaint;

        private GridBagConstraints rowcol(int n, int n2) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridx = n2;
            return gridBagConstraints;
        }

        private GridBagConstraints rowcol_stretch(int n, int n2) {
            GridBagConstraints gridBagConstraints = this.rowcol(n, n2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            return gridBagConstraints;
        }

        public DirectoryPanel(GuiFactory guiFactory) {
            this.setLayout(new GridBagLayout());
            this.txtDir = new OTTextField();
            this.add((Component)new JLabel("  Search in  "), this.rowcol(0, 0));
            this.add((Component)this.txtDir, this.rowcol_stretch(0, 1));
            this.chDir = guiFactory.giveFileChooser("finder");
            this.chDir.setFileSelectionMode(1);
            JButton jButton = new JButton(new AbstractAction("..."){
                {
                    super(string);
                    this.putValue("ShortDescription", "Choose your \"personal db\" folder");
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = DirectoryPanel.this.chDir.showDialog(DirectoryPanel.this, "Choose Folder");
                    if (n == 0) {
                        DirectoryPanel.this.txtDir.setText(DirectoryPanel.this.chDir.getSelectedFile().getAbsolutePath());
                    }
                }
            });
            jButton.setMargin(new Insets(0, 3, 0, 3));
            this.add((Component)jButton, this.rowcol(0, 2));
            this.add((Component)new JLabel("  Including:"), this.rowcol(1, 0));
            this.chkSub = new JCheckBox("sub-directories");
            this.chkSub.setEnabled(false);
            this.add((Component)this.chkSub, this.rowcol(1, 1));
            this.txtDir.setEditable(false);
            this.txtDir.setFocusable(false);
            String string = this.chDir.getCurrentDirectory().getAbsolutePath();
            this.txtDir.setText(string);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (!this.everpaint) {
                this.everpaint = true;
                this.txtDir.setCaretPosition(this.txtDir.getText().length());
            }
        }

        public List<File> getFiles() {
            String string = this.txtDir.getText().trim();
            File file = new File(string);
            List<File> list = Arrays.asList(file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".aot");
                }
            }));
            return list;
        }
    }

    protected class ResultPanel
    extends JPanel {
        protected Vector<PersonalDb.FileResult> resultData;
        protected Vector<Vector<String>> modelData;
        protected Vector<String> columnNames;
        protected Table table;
        protected ReadonlyModel tableModel;

        public ResultPanel() {
            super(new BorderLayout());
            this.columnNames = new Vector();
            this.columnNames.add("Project Name");
            this.columnNames.add("Project Code");
            this.columnNames.add("PI ALMA ID");
            this.columnNames.add("In File");
            this.modelData = new Vector();
            this.tableModel = new ReadonlyModel(this.modelData, this.columnNames);
            this.table = new Table(this.tableModel);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.setRowSorter(new TableRowSorter<ReadonlyModel>(this.tableModel));
            this.table.setSelectionMode(0);
            this.table.setFocusPainted(false);
            this.add((Component)new JScrollPane(this.table), "Center");
            this.resultData = new Vector();
        }

        protected void clearResults() {
            this.modelData.clear();
            this.tableModel.fireTableDataChanged();
            this.resultData.clear();
        }

        protected void addResult(PersonalDb.FileResult fileResult) {
            Vector<String> vector = new Vector<String>();
            vector.add(fileResult.prjName.toString());
            vector.add(fileResult.prjCode.toString());
            vector.add(fileResult.prjPI.toString());
            vector.add(fileResult.file.getName());
            this.modelData.add(vector);
            int n = this.tableModel.getRowCount() - 1;
            this.tableModel.fireTableRowsInserted(n, n);
            this.resultData.add(fileResult);
        }

        protected int getResultCount() {
            return this.modelData.size();
        }

        protected void removeResult(File file) {
            for (int i = 0; i < this.resultData.size(); ++i) {
                if (this.resultData.get((int)i).file != file) continue;
                this.resultData.remove(i);
                this.modelData.remove(i);
                this.tableModel.fireTableDataChanged();
                break;
            }
        }

        protected File getSelectedFile() {
            int n = this.table.getSelectedRow();
            if (n == -1) {
                return null;
            }
            n = this.table.convertRowIndexToModel(n);
            PersonalDb.FileResult fileResult = this.resultData.get(n);
            return fileResult.file;
        }

        protected class ReadonlyModel
        extends DefaultTableModel {
            ReadonlyModel(Vector<? extends Vector> vector, Vector<?> vector2) {
                super(vector, vector2);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }
    }

    protected class StopSearchAction
    extends AbstractAction {
        boolean stopRequested;

        public StopSearchAction() {
            super("Stop");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.stopRequested = true;
        }
    }
}

