/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.misc;

import alma.obsprep.ot.editors.misc.ExpertParametersEditor;
import alma.obsprep.ot.models.misc.ExpertParametersModel;
import alma.valuetypes.KeywordValue;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class ExpertParametersTableModel
extends AbstractTableModel {
    private ExpertParametersModel expertParametersModel = null;

    public ExpertParametersTableModel(ExpertParametersModel expertParametersModel) {
        this.expertParametersModel = expertParametersModel;
    }

    private List<KeywordValue> getKeywordValuePairs() {
        return this.expertParametersModel.getKeywordValuePairs();
    }

    @Override
    public int getRowCount() {
        List<KeywordValue> list = this.getKeywordValuePairs();
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Keyword";
            }
            case 1: {
                return "Value";
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        KeywordValue keywordValue = this.getKeywordValuePairs().get(n);
        String string = keywordValue.getKeyword();
        String string2 = keywordValue.getValue();
        switch (n2) {
            case 0: {
                return string;
            }
            case 1: {
                return string2;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        KeywordValue keywordValue = this.getKeywordValuePairs().get(n);
        String string = (String)object;
        switch (n2) {
            case 0: {
                keywordValue.setKeyword(string);
                break;
            }
            case 1: {
                keywordValue.setValue(string);
                break;
            }
        }
        if (this.expertParametersModel != null) {
            this.expertParametersModel.publish(ExpertParametersEditor.KEYWORDVALUE_TABLE_FID, this.getKeywordValuePairs());
        }
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(TableModelListener.class, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(TableModelListener.class, tableModelListener);
    }

    @Override
    public TableModelListener[] getTableModelListeners() {
        return (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
    }

    @Override
    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    @Override
    public void fireTableRowsInserted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 1));
    }

    @Override
    public void fireTableRowsUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 0));
    }

    @Override
    public void fireTableRowsDeleted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, -1));
    }

    @Override
    public void fireTableCellUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n, n2));
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableModelListener.class) continue;
            ((TableModelListener)objectArray[i + 1]).tableChanged(tableModelEvent);
        }
    }
}

