/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.schedblock.SpectralWindowPair;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.models.schedblock.CARTableModel;
import alma.obsprep.ot.models.schedblock.DataRateUpdaterInterface;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ChannelAverageRegionModel
extends Model
implements TableModelListener {
    private CARTableModel carTableModel = null;
    private DataRateUpdaterInterface dataRateUpdater = null;
    private final AtomicBoolean inhibitUpdatingOfDataRates = new AtomicBoolean(false);

    public ChannelAverageRegionModel(Object object) {
        super(object);
        this.carTableModel = new CARTableModel(null);
        this.carTableModel.addTableModelListener(this);
    }

    public CARTableModel getCARTableModel() {
        return this.carTableModel;
    }

    public SpectralWindowI getSpectralWindow() {
        return (SpectralWindowI)this.getDocument();
    }

    @Override
    public void publish() {
        this.inhibitUpdatingOfDataRates.set(true);
        this.carTableModel.fireTableDataChanged();
        this.inhibitUpdatingOfDataRates.set(false);
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return null;
    }

    public void addChannelAverageRegion(int n) {
        this.carTableModel.addChannelAverageRegion(n);
        this.updateDataRates();
    }

    public void deleteChannelAverageRegion(int n) {
        this.carTableModel.deleteChannelAverageRegion(n);
        this.updateDataRates();
    }

    public int getChannelAverageRegionCount() {
        SpectralWindowI spectralWindowI = this.getSpectralWindow();
        if (spectralWindowI == null) {
            return 0;
        }
        return spectralWindowI.getChannelAverageRegionCount();
    }

    public void setUsesInBoth(boolean bl) {
        this.carTableModel.setUsesInBoth(bl);
        try {
            SpectralWindowPair spectralWindowPair = (SpectralWindowPair)this.getSpectralWindow();
            spectralWindowPair.setAllChannelAverageRegionUseToBoth();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.carTableModel.fireTableStructureChanged();
        this.updateDataRates();
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        this.carTableModel.setSpectralWindow(this.getSpectralWindow());
        this.publish();
        this.updateDataRates();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.updateDataRates();
        }
    }

    private void updateDataRates() {
        if (this.dataRateUpdater != null && this.inhibitUpdatingOfDataRates.compareAndSet(false, true)) {
            this.dataRateUpdater.updateDataRates();
            this.inhibitUpdatingOfDataRates.set(false);
        }
    }

    public void setDataRateUpdater(DataRateUpdaterInterface dataRateUpdaterInterface) {
        this.dataRateUpdater = dataRateUpdaterInterface;
    }
}

